/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.FormatMethod;
import io.airlift.json.JsonCodec;
import io.airlift.stats.TDigest;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.cost.PlanCostEstimate;
import io.trino.cost.PlanNodeStatsAndCostSummary;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.DistributionSnapshot;
import io.trino.execution.QueryStats;
import io.trino.execution.StageInfo;
import io.trino.execution.StageStats;
import io.trino.execution.TableInfo;
import io.trino.execution.TaskInfo;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.server.DynamicFilterService;
import io.trino.server.protocol.spooling.SpooledBlock;
import io.trino.spi.catalog.CatalogProperties;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.DescriptorArgument;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.TableStatisticType;
import io.trino.spi.type.Type;
import io.trino.sql.DynamicFilters;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.iterative.GroupReference;
import io.trino.sql.planner.plan.AdaptivePlanNode;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.DynamicFilterSourceNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.MergeProcessorNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.OffsetNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RefreshMaterializedViewNode;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SimpleTableExecuteNode;
import io.trino.sql.planner.plan.SkipToPosition;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.StatisticAggregations;
import io.trino.sql.planner.plan.StatisticAggregationsDescriptor;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableDeleteNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableUpdateNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.planprinter.Anonymizer;
import io.trino.sql.planner.planprinter.GraphvizPrinter;
import io.trino.sql.planner.planprinter.JsonRenderer;
import io.trino.sql.planner.planprinter.NoOpAnonymizer;
import io.trino.sql.planner.planprinter.NodeRepresentation;
import io.trino.sql.planner.planprinter.PlanNodeStats;
import io.trino.sql.planner.planprinter.PlanNodeStatsSummarizer;
import io.trino.sql.planner.planprinter.PlanRepresentation;
import io.trino.sql.planner.planprinter.TableInfoSupplier;
import io.trino.sql.planner.planprinter.TextRenderer;
import io.trino.sql.planner.planprinter.ValuePrinter;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.ClassifierValuePointer;
import io.trino.sql.planner.rowpattern.ExpressionAndValuePointers;
import io.trino.sql.planner.rowpattern.LogicalIndexPointer;
import io.trino.sql.planner.rowpattern.MatchNumberValuePointer;
import io.trino.sql.planner.rowpattern.ScalarValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.routine.ir.IrRoutine;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlanPrinter {
    private static final JsonCodec<Map<PlanFragmentId, JsonRenderer.JsonRenderedNode>> DISTRIBUTED_PLAN_CODEC = JsonCodec.mapJsonCodec(PlanFragmentId.class, JsonRenderer.JsonRenderedNode.class);
    private static final CatalogSchemaFunctionName COUNT_NAME = GlobalFunctionCatalog.builtinFunctionName("count");
    private final PlanRepresentation representation;
    private final Function<TableScanNode, TableInfo> tableInfoSupplier;
    private final Map<DynamicFilterId, DynamicFilterService.DynamicFilterDomainStats> dynamicFilterDomainStats;
    private final ValuePrinter valuePrinter;
    private final Anonymizer anonymizer;

    @VisibleForTesting
    PlanPrinter(PlanNode planRoot, Function<TableScanNode, TableInfo> tableInfoSupplier, Map<DynamicFilterId, DynamicFilterService.DynamicFilterDomainStats> dynamicFilterDomainStats, ValuePrinter valuePrinter, StatsAndCosts estimatedStatsAndCosts, Optional<Map<PlanNodeId, PlanNodeStats>> stats, Anonymizer anonymizer) {
        Objects.requireNonNull(planRoot, "planRoot is null");
        Objects.requireNonNull(tableInfoSupplier, "tableInfoSupplier is null");
        Objects.requireNonNull(dynamicFilterDomainStats, "dynamicFilterDomainStats is null");
        Objects.requireNonNull(valuePrinter, "valuePrinter is null");
        Objects.requireNonNull(estimatedStatsAndCosts, "estimatedStatsAndCosts is null");
        Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(anonymizer, "anonymizer is null");
        this.tableInfoSupplier = tableInfoSupplier;
        this.dynamicFilterDomainStats = ImmutableMap.copyOf(dynamicFilterDomainStats);
        this.valuePrinter = valuePrinter;
        this.anonymizer = anonymizer;
        Optional<Duration> totalScheduledTime = stats.map(s -> new Duration((double)s.values().stream().mapToLong(planNode -> planNode.getPlanNodeScheduledTime().toMillis()).sum(), TimeUnit.MILLISECONDS));
        Optional<Duration> totalCpuTime = stats.map(s -> new Duration((double)s.values().stream().mapToLong(planNode -> planNode.getPlanNodeCpuTime().toMillis()).sum(), TimeUnit.MILLISECONDS));
        Optional<Duration> totalBlockedTime = stats.map(s -> new Duration((double)s.values().stream().mapToLong(planNode -> planNode.getPlanNodeBlockedTime().toMillis()).sum(), TimeUnit.MILLISECONDS));
        this.representation = new PlanRepresentation(planRoot, totalCpuTime, totalScheduledTime, totalBlockedTime);
        Visitor visitor = new Visitor(estimatedStatsAndCosts, stats);
        planRoot.accept(visitor, new Context(Optional.empty(), false));
    }

    private String toText(boolean verbose, int level) {
        return new TextRenderer(verbose, level).render(this.representation);
    }

    @VisibleForTesting
    String toJson() {
        return new JsonRenderer().render(this.representation);
    }

    JsonRenderer.JsonRenderedNode toJsonRenderedNode() {
        return new JsonRenderer().renderJson(this.representation, this.representation.getRoot(), false);
    }

    public static String jsonFragmentPlan(PlanNode root, Metadata metadata, FunctionManager functionManager, Session session) {
        TableInfoSupplier tableInfoSupplier = new TableInfoSupplier(metadata, session);
        ValuePrinter valuePrinter = new ValuePrinter(metadata, functionManager, session);
        return new PlanPrinter(root, tableInfoSupplier, (Map<DynamicFilterId, DynamicFilterService.DynamicFilterDomainStats>)ImmutableMap.of(), valuePrinter, StatsAndCosts.empty(), Optional.empty(), new NoOpAnonymizer()).toJson();
    }

    public static String jsonLogicalPlan(PlanNode plan, Session session, Metadata metadata, FunctionManager functionManager, StatsAndCosts estimatedStatsAndCosts) {
        TableInfoSupplier tableInfoSupplier = new TableInfoSupplier(metadata, session);
        ValuePrinter valuePrinter = new ValuePrinter(metadata, functionManager, session);
        return new PlanPrinter(plan, tableInfoSupplier, (Map<DynamicFilterId, DynamicFilterService.DynamicFilterDomainStats>)ImmutableMap.of(), valuePrinter, estimatedStatsAndCosts, Optional.empty(), new NoOpAnonymizer()).toJson();
    }

    public static String jsonDistributedPlan(StageInfo outputStageInfo, Session session, Metadata metadata, FunctionManager functionManager, Anonymizer anonymizer) {
        List<StageInfo> allStages = StageInfo.getAllStages(Optional.of(outputStageInfo));
        Map tableInfos = (Map)allStages.stream().map(StageInfo::getTables).map(Map::entrySet).flatMap(Collection::stream).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        ValuePrinter valuePrinter = new ValuePrinter(metadata, functionManager, session);
        List planFragments = (List)allStages.stream().map(StageInfo::getPlan).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        return PlanPrinter.jsonDistributedPlan(planFragments, (TableScanNode tableScanNode) -> (TableInfo)tableInfos.get(tableScanNode.getId()), valuePrinter, anonymizer);
    }

    public static String jsonDistributedPlan(SubPlan plan, Metadata metadata, FunctionManager functionManager, Session session) {
        TableInfoSupplier tableInfoSupplier = new TableInfoSupplier(metadata, session);
        ValuePrinter valuePrinter = new ValuePrinter(metadata, functionManager, session);
        return PlanPrinter.jsonDistributedPlan(plan.getAllFragments(), tableInfoSupplier, valuePrinter, new NoOpAnonymizer());
    }

    private static String jsonDistributedPlan(List<PlanFragment> fragments, Function<TableScanNode, TableInfo> tableInfoSupplier, ValuePrinter valuePrinter, Anonymizer anonymizer) {
        Map anonymizedPlan = (Map)fragments.stream().collect(ImmutableMap.toImmutableMap(PlanFragment::getId, planFragment -> new PlanPrinter(planFragment.getRoot(), tableInfoSupplier, (Map<DynamicFilterId, DynamicFilterService.DynamicFilterDomainStats>)ImmutableMap.of(), valuePrinter, planFragment.getStatsAndCosts(), Optional.empty(), anonymizer).toJsonRenderedNode()));
        return DISTRIBUTED_PLAN_CODEC.toJson((Object)anonymizedPlan);
    }

    public static String textLogicalPlan(PlanNode plan, Metadata metadata, FunctionManager functionManager, StatsAndCosts estimatedStatsAndCosts, Session session, int level, boolean verbose) {
        return PlanPrinter.textLogicalPlan(plan, metadata, functionManager, estimatedStatsAndCosts, session, level, verbose, Optional.empty());
    }

    public static String textLogicalPlan(PlanNode plan, Metadata metadata, FunctionManager functionManager, StatsAndCosts estimatedStatsAndCosts, Session session, int level, boolean verbose, Optional<NodeVersion> version) {
        TableInfoSupplier tableInfoSupplier = new TableInfoSupplier(metadata, session);
        ValuePrinter valuePrinter = new ValuePrinter(metadata, functionManager, session);
        StringBuilder builder = new StringBuilder();
        version.ifPresent(v -> builder.append(String.format("Trino version: %s\n", v)));
        builder.append(new PlanPrinter(plan, tableInfoSupplier, (Map<DynamicFilterId, DynamicFilterService.DynamicFilterDomainStats>)ImmutableMap.of(), valuePrinter, estimatedStatsAndCosts, Optional.empty(), new NoOpAnonymizer()).toText(verbose, level));
        return builder.toString();
    }

    public static String textDistributedPlan(StageInfo outputStageInfo, QueryStats queryStats, Metadata metadata, FunctionManager functionManager, Session session, boolean verbose, NodeVersion version) {
        return PlanPrinter.textDistributedPlan(outputStageInfo, queryStats, new ValuePrinter(metadata, functionManager, session), verbose, new NoOpAnonymizer(), version);
    }

    public static String textDistributedPlan(StageInfo outputStageInfo, QueryStats queryStats, ValuePrinter valuePrinter, boolean verbose, Anonymizer anonymizer, NodeVersion version) {
        List<StageInfo> allStages = StageInfo.getAllStages(Optional.of(outputStageInfo));
        Map tableInfos = (Map)allStages.stream().map(StageInfo::getTables).map(Map::entrySet).flatMap(Collection::stream).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        StringBuilder builder = new StringBuilder();
        Map<PlanNodeId, PlanNodeStats> aggregatedStats = PlanNodeStatsSummarizer.aggregateStageStats(allStages);
        Map dynamicFilterDomainStats = (Map)queryStats.getDynamicFiltersStats().getDynamicFilterDomainStats().stream().collect(ImmutableMap.toImmutableMap(DynamicFilterService.DynamicFilterDomainStats::getDynamicFilterId, Function.identity()));
        builder.append(String.format("Trino version: %s\n", version));
        builder.append(String.format("Queued: %s, Analysis: %s, Planning: %s, Execution: %s\n", queryStats.getQueuedTime().convertToMostSuccinctTimeUnit(), queryStats.getAnalysisTime().convertToMostSuccinctTimeUnit(), queryStats.getPlanningTime().convertToMostSuccinctTimeUnit(), queryStats.getExecutionTime().convertToMostSuccinctTimeUnit()));
        for (StageInfo stageInfo : allStages) {
            builder.append(PlanPrinter.formatFragment(tableScanNode -> (TableInfo)tableInfos.get(tableScanNode.getId()), dynamicFilterDomainStats, valuePrinter, stageInfo.getPlan(), Optional.of(stageInfo), Optional.of(aggregatedStats), verbose, anonymizer));
        }
        return builder.toString();
    }

    public static String textDistributedPlan(SubPlan plan, Metadata metadata, FunctionManager functionManager, Session session, boolean verbose, NodeVersion version) {
        TableInfoSupplier tableInfoSupplier = new TableInfoSupplier(metadata, session);
        ValuePrinter valuePrinter = new ValuePrinter(metadata, functionManager, session);
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Trino version: %s\n", version));
        for (PlanFragment fragment : plan.getAllFragments()) {
            builder.append(PlanPrinter.formatFragment(tableInfoSupplier, (Map<DynamicFilterId, DynamicFilterService.DynamicFilterDomainStats>)ImmutableMap.of(), valuePrinter, fragment, Optional.empty(), Optional.empty(), verbose, new NoOpAnonymizer()));
        }
        return builder.toString();
    }

    private static String formatFragment(Function<TableScanNode, TableInfo> tableInfoSupplier, Map<DynamicFilterId, DynamicFilterService.DynamicFilterDomainStats> dynamicFilterDomainStats, ValuePrinter valuePrinter, PlanFragment fragment, Optional<StageInfo> stageInfo, Optional<Map<PlanNodeId, PlanNodeStats>> planNodeStats, boolean verbose, Anonymizer anonymizer) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Fragment %s [%s]\n", fragment.getId(), anonymizer.anonymize(fragment.getPartitioning())));
        if (stageInfo.isPresent()) {
            StageStats stageStats = stageInfo.get().getStageStats();
            List<TaskInfo> tasks = stageInfo.get().getTasks();
            double avgPositionsPerTask = tasks.stream().mapToLong(task -> task.stats().getProcessedInputPositions()).average().orElse(Double.NaN);
            double squaredDifferences = tasks.stream().mapToDouble(task -> Math.pow((double)task.stats().getProcessedInputPositions() - avgPositionsPerTask, 2.0)).sum();
            double sdAmongTasks = Math.sqrt(squaredDifferences / (double)tasks.size());
            DataSize maxPeakTaskMemoryUsage = tasks.stream().map(task -> task.stats().getPeakUserMemoryReservation()).max(DataSize::compareTo).orElse(DataSize.ofBytes((long)0L));
            builder.append(TextRenderer.indentString(1)).append(String.format("CPU: %s, Scheduled: %s, Blocked %s (Input: %s, Output: %s), Input: %s (%s); per task: avg.: %s std.dev.: %s, Output: %s (%s)\n", stageStats.getTotalCpuTime().convertToMostSuccinctTimeUnit(), stageStats.getTotalScheduledTime().convertToMostSuccinctTimeUnit(), stageStats.getTotalBlockedTime().convertToMostSuccinctTimeUnit(), stageStats.getInputBlockedTime().convertToMostSuccinctTimeUnit(), stageStats.getOutputBlockedTime().convertToMostSuccinctTimeUnit(), TextRenderer.formatPositions(stageStats.getProcessedInputPositions()), stageStats.getProcessedInputDataSize(), TextRenderer.formatDouble(avgPositionsPerTask), TextRenderer.formatDouble(sdAmongTasks), TextRenderer.formatPositions(stageStats.getOutputPositions()), stageStats.getOutputDataSize()));
            builder.append(TextRenderer.indentString(1)).append(String.format("Peak Memory: %s, Tasks count: %d; per task: max: %s\n", stageStats.getPeakUserMemoryReservation().succinct(), tasks.size(), maxPeakTaskMemoryUsage.succinct()));
            Optional<DistributionSnapshot> outputBufferUtilization = stageInfo.get().getStageStats().getOutputBufferUtilization();
            if (verbose && outputBufferUtilization.isPresent()) {
                builder.append(TextRenderer.indentString(1)).append(String.format("Output buffer active time: %s, buffer utilization distribution (%%): {p01=%s, p05=%s, p10=%s, p25=%s, p50=%s, p75=%s, p90=%s, p95=%s, p99=%s, min=%s, max=%s}\n", Duration.succinctNanos((long)outputBufferUtilization.get().total()), TextRenderer.formatDouble(outputBufferUtilization.get().p01() * 100.0), TextRenderer.formatDouble(outputBufferUtilization.get().p05() * 100.0), TextRenderer.formatDouble(outputBufferUtilization.get().p10() * 100.0), TextRenderer.formatDouble(outputBufferUtilization.get().p25() * 100.0), TextRenderer.formatDouble(outputBufferUtilization.get().p50() * 100.0), TextRenderer.formatDouble(outputBufferUtilization.get().p75() * 100.0), TextRenderer.formatDouble(outputBufferUtilization.get().p90() * 100.0), TextRenderer.formatDouble(outputBufferUtilization.get().p95() * 100.0), TextRenderer.formatDouble(outputBufferUtilization.get().p99() * 100.0), TextRenderer.formatDouble(outputBufferUtilization.get().min() * 100.0), TextRenderer.formatDouble(outputBufferUtilization.get().max() * 100.0)));
            }
            TDigest taskOutputDistribution = new TDigest();
            stageInfo.get().getTasks().forEach(task -> taskOutputDistribution.add((double)task.stats().getOutputDataSize().toBytes()));
            TDigest taskInputDistribution = new TDigest();
            stageInfo.get().getTasks().forEach(task -> taskInputDistribution.add((double)task.stats().getProcessedInputDataSize().toBytes()));
            if (verbose) {
                builder.append(TextRenderer.indentString(1)).append(String.format("Task output distribution: %s\n", PlanPrinter.formatSizeDistribution(taskOutputDistribution)));
                builder.append(TextRenderer.indentString(1)).append(String.format("Task input distribution: %s\n", PlanPrinter.formatSizeDistribution(taskInputDistribution)));
            }
            if (taskInputDistribution.valueAt(0.99) > taskInputDistribution.valueAt(0.49) * 2.0) {
                builder.append(TextRenderer.indentString(1)).append("Amount of input data processed by the workers for this stage might be skewed\n");
            }
        }
        PartitioningScheme partitioningScheme = fragment.getOutputPartitioningScheme();
        List layout = (List)partitioningScheme.getOutputLayout().stream().map(anonymizer::anonymize).filter(value -> !value.equals("$spooling:metadata$")).collect(ImmutableList.toImmutableList());
        builder.append(TextRenderer.indentString(1)).append(String.format("Output layout: [%s]\n", Joiner.on((String)", ").join((Iterable)layout)));
        boolean replicateNullsAndAny = partitioningScheme.isReplicateNullsAndAny();
        List arguments = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
            if (argument.isConstant()) {
                NullableValue constant = argument.getConstant();
                String printableValue = valuePrinter.castToVarchar(constant.getType(), constant.getValue());
                return constant.getType().getDisplayName() + "(" + anonymizer.anonymize(constant.getType(), printableValue) + ")";
            }
            return anonymizer.anonymize(argument.getColumn());
        }).collect(ImmutableList.toImmutableList());
        builder.append(TextRenderer.indentString(1));
        String hashColumn = partitioningScheme.getHashColumn().map(anonymizer::anonymize).map(column -> "[" + column + "]").orElse("");
        if (replicateNullsAndAny) {
            builder.append(String.format("Output partitioning: %s (replicate nulls and any) [%s]%s", anonymizer.anonymize(partitioningScheme.getPartitioning().getHandle()), Joiner.on((String)", ").join((Iterable)arguments), hashColumn));
        } else {
            builder.append(String.format("Output partitioning: %s [%s]%s\n", anonymizer.anonymize(partitioningScheme.getPartitioning().getHandle()), Joiner.on((String)", ").join((Iterable)arguments), hashColumn));
        }
        partitioningScheme.getPartitionCount().ifPresent(partitionCount -> builder.append(String.format("%sOutput partition count: %s\n", TextRenderer.indentString(1), partitionCount)));
        fragment.getPartitionCount().ifPresent(partitionCount -> builder.append(String.format("%sInput partition count: %s\n", TextRenderer.indentString(1), partitionCount)));
        builder.append(new PlanPrinter(fragment.getRoot(), tableInfoSupplier, dynamicFilterDomainStats, valuePrinter, fragment.getStatsAndCosts(), planNodeStats, anonymizer).toText(verbose, 1)).append("\n");
        return builder.toString();
    }

    private static String formatSizeDistribution(TDigest digest) {
        return String.format("{count=%s, p01=%s, p05=%s, p10=%s, p25=%s, p50=%s, p75=%s, p90=%s, p95=%s, p99=%s, max=%s}", TextRenderer.formatDouble(digest.getCount()), DataSize.succinctBytes((long)((long)digest.valueAt(0.01))), DataSize.succinctBytes((long)((long)digest.valueAt(0.05))), DataSize.succinctBytes((long)((long)digest.valueAt(0.1))), DataSize.succinctBytes((long)((long)digest.valueAt(0.25))), DataSize.succinctBytes((long)((long)digest.valueAt(0.5))), DataSize.succinctBytes((long)((long)digest.valueAt(0.75))), DataSize.succinctBytes((long)((long)digest.valueAt(0.9))), DataSize.succinctBytes((long)((long)digest.valueAt(0.95))), DataSize.succinctBytes((long)((long)digest.valueAt(0.99))), DataSize.succinctBytes((long)((long)digest.getMax())));
    }

    public static String graphvizLogicalPlan(PlanNode plan) {
        PlanFragment fragment = new PlanFragment(new PlanFragmentId("graphviz_plan"), plan, (Set<Symbol>)ImmutableSet.of(), SystemPartitioningHandle.SINGLE_DISTRIBUTION, Optional.empty(), (List<PlanNodeId>)ImmutableList.of((Object)plan.getId()), new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), plan.getOutputSymbols()), StatsAndCosts.empty(), (List<CatalogProperties>)ImmutableList.of(), (Map<FunctionId, IrRoutine>)ImmutableMap.of(), Optional.empty());
        return GraphvizPrinter.printLogical((List<PlanFragment>)ImmutableList.of((Object)fragment));
    }

    public static String graphvizDistributedPlan(SubPlan plan) {
        return GraphvizPrinter.printDistributed(plan);
    }

    private static String formatOrderingScheme(Anonymizer anonymizer, OrderingScheme orderingScheme) {
        return PlanPrinter.formatCollection(orderingScheme.orderBy(), input -> anonymizer.anonymize((Symbol)input) + " " + String.valueOf(orderingScheme.ordering((Symbol)input)));
    }

    private static <T> String formatCollection(Collection<T> collection, Function<T, String> formatter) {
        return collection.stream().map(formatter).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String formatAggregation(Anonymizer anonymizer, AggregationNode.Aggregation aggregation) {
        StringBuilder builder = new StringBuilder();
        List anonymizedArguments = (List)aggregation.getArguments().stream().map(anonymizer::anonymize).collect(ImmutableList.toImmutableList());
        Object arguments = Joiner.on((String)", ").join((Iterable)anonymizedArguments);
        if (aggregation.getArguments().isEmpty() && COUNT_NAME.equals((Object)aggregation.getResolvedFunction().signature().getName())) {
            arguments = "*";
        }
        if (aggregation.isDistinct()) {
            arguments = "DISTINCT " + (String)arguments;
        }
        builder.append(PlanPrinter.formatFunctionName(aggregation.getResolvedFunction())).append('(').append((String)arguments);
        aggregation.getOrderingScheme().map(orderingScheme -> PlanPrinter.formatOrderingScheme(anonymizer, orderingScheme)).ifPresent(ordering -> builder.append(' ').append((String)ordering));
        builder.append(')');
        aggregation.getFilter().map(anonymizer::anonymize).ifPresent(expression -> builder.append(" FILTER (WHERE ").append((String)expression).append(")"));
        aggregation.getMask().map(anonymizer::anonymize).ifPresent(symbol -> builder.append(" (mask = ").append((String)symbol).append(")"));
        return builder.toString();
    }

    private static String formatFunctionName(ResolvedFunction function) {
        CatalogSchemaFunctionName name = function.signature().getName();
        if (LanguageFunctionManager.isInlineFunction(name) || GlobalFunctionCatalog.isBuiltinFunctionName(name)) {
            return name.getFunctionName();
        }
        return name.toString();
    }

    private class Visitor
    extends PlanVisitor<Void, Context> {
        private final StatsAndCosts estimatedStatsAndCosts;
        private final Optional<Map<PlanNodeId, PlanNodeStats>> stats;

        public Visitor(StatsAndCosts estimatedStatsAndCosts, Optional<Map<PlanNodeId, PlanNodeStats>> stats) {
            this.estimatedStatsAndCosts = Objects.requireNonNull(estimatedStatsAndCosts, "estimatedStatsAndCosts is null");
            this.stats = Objects.requireNonNull(stats, "stats is null");
        }

        @Override
        public Void visitExplainAnalyze(ExplainAnalyzeNode node, Context context) {
            this.addNode(node, "ExplainAnalyze", context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitJoin(JoinNode node, Context context) {
            NodeRepresentation nodeOutput;
            List criteriaExpressions = (List)node.getCriteria().stream().map(JoinNode.EquiJoinClause::toExpression).collect(ImmutableList.toImmutableList());
            if (node.isCrossJoin()) {
                Preconditions.checkState((boolean)criteriaExpressions.isEmpty());
                Preconditions.checkState((boolean)node.getFilter().isEmpty());
                nodeOutput = this.addNode(node, "CrossJoin", context);
            } else {
                ImmutableMap.Builder descriptor = ImmutableMap.builder().put((Object)"criteria", (Object)Joiner.on((String)" AND ").join(this.anonymizeExpressions(criteriaExpressions)));
                node.getFilter().ifPresent(filter -> descriptor.put((Object)"filter", (Object)this.formatFilter((Expression)filter)));
                descriptor.put((Object)"hash", (Object)this.formatHash(node.getLeftHashSymbol(), node.getRightHashSymbol()));
                node.getDistributionType().ifPresent(distribution -> descriptor.put((Object)"distribution", (Object)distribution.name()));
                nodeOutput = this.addNode(node, node.getType().getJoinLabel(), (Map<String, String>)descriptor.buildOrThrow(), node.getReorderJoinStatsAndCost(), context);
            }
            node.getDistributionType().ifPresent(distributionType -> nodeOutput.appendDetails("Distribution: %s", distributionType));
            if (node.isMaySkipOutputDuplicates()) {
                nodeOutput.appendDetails("maySkipOutputDuplicates = %s", node.isMaySkipOutputDuplicates());
            }
            if (!node.getDynamicFilters().isEmpty()) {
                nodeOutput.appendDetails("dynamicFilterAssignments = %s", this.printDynamicFilterAssignments(node.getDynamicFilters()));
            }
            node.getLeft().accept(this, new Context(context.isInitialPlan()));
            node.getRight().accept(this, new Context(context.isInitialPlan()));
            return null;
        }

        @Override
        public Void visitSpatialJoin(SpatialJoinNode node, Context context) {
            NodeRepresentation nodeOutput = this.addNode(node, node.getType().getJoinLabel(), (Map<String, String>)ImmutableMap.of((Object)"filter", (Object)this.formatFilter(node.getFilter())), context);
            nodeOutput.appendDetails("Distribution: %s", new Object[]{node.getDistributionType()});
            node.getLeft().accept(this, new Context(context.isInitialPlan()));
            node.getRight().accept(this, new Context(context.isInitialPlan()));
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Context context) {
            NodeRepresentation nodeOutput = this.addNode(node, "SemiJoin", (Map<String, String>)ImmutableMap.of((Object)"criteria", (Object)(PlanPrinter.this.anonymizer.anonymize(node.getSourceJoinSymbol()) + " = " + PlanPrinter.this.anonymizer.anonymize(node.getFilteringSourceJoinSymbol())), (Object)"hash", (Object)this.formatHash(node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol())), context);
            node.getDistributionType().ifPresent(distributionType -> nodeOutput.appendDetails("Distribution: %s", distributionType));
            node.getDynamicFilterId().ifPresent(dynamicFilterId -> nodeOutput.appendDetails("dynamicFilterId: %s", dynamicFilterId));
            node.getSource().accept(this, new Context(context.isInitialPlan()));
            node.getFilteringSource().accept(this, new Context(context.isInitialPlan()));
            return null;
        }

        @Override
        public Void visitDynamicFilterSource(DynamicFilterSourceNode node, Context context) {
            this.addNode(node, "DynamicFilterSource", (Map<String, String>)ImmutableMap.of((Object)"dynamicFilterAssignments", (Object)this.printDynamicFilterAssignments(node.getDynamicFilters())), context);
            node.getSource().accept(this, new Context(context.isInitialPlan()));
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Context context) {
            NodeRepresentation nodeOutput = this.addNode(node, "IndexSource", (Map<String, String>)ImmutableMap.of((Object)"indexedTable", (Object)PlanPrinter.this.anonymizer.anonymize(node.getIndexHandle()), (Object)"lookup", (Object)this.formatSymbols(node.getLookupSymbols())), context);
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                if (!node.getOutputSymbols().contains(entry.getKey())) continue;
                nodeOutput.appendDetails("%s := %s", PlanPrinter.this.anonymizer.anonymize(entry.getKey()), PlanPrinter.this.anonymizer.anonymize(entry.getValue()));
            }
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Context context) {
            ArrayList<Expression> joinExpressions = new ArrayList<Expression>();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new Comparison(Comparison.Operator.EQUAL, clause.getProbe().toSymbolReference(), clause.getIndex().toSymbolReference()));
            }
            this.addNode(node, String.format("%sIndexJoin", node.getType().getJoinLabel()), (Map<String, String>)ImmutableMap.of((Object)"criteria", (Object)Joiner.on((String)" AND ").join(this.anonymizeExpressions(joinExpressions)), (Object)"hash", (Object)this.formatHash(node.getProbeHashSymbol(), node.getIndexHashSymbol())), context);
            node.getProbeSource().accept(this, new Context(context.isInitialPlan()));
            node.getIndexSource().accept(this, new Context(context.isInitialPlan()));
            return null;
        }

        @Override
        public Void visitOffset(OffsetNode node, Context context) {
            this.addNode(node, "Offset", (Map<String, String>)ImmutableMap.of((Object)"count", (Object)String.valueOf(node.getCount())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitLimit(LimitNode node, Context context) {
            this.addNode(node, String.format("Limit%s", node.isPartial() ? "Partial" : ""), (Map<String, String>)ImmutableMap.of((Object)"count", (Object)String.valueOf(node.getCount()), (Object)"withTies", (Object)this.formatBoolean(node.isWithTies()), (Object)"inputPreSortedBy", (Object)this.formatSymbols(node.getPreSortedInputs())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitDistinctLimit(DistinctLimitNode node, Context context) {
            this.addNode(node, String.format("DistinctLimit%s", node.isPartial() ? "Partial" : ""), (Map<String, String>)ImmutableMap.of((Object)"limit", (Object)String.valueOf(node.getLimit()), (Object)"hash", (Object)this.formatHash(node.getHashSymbol())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitAggregation(AggregationNode node, Context context) {
            String type = "";
            if (node.getStep() != AggregationNode.Step.SINGLE) {
                type = node.getStep().name();
            }
            if (node.isStreamable()) {
                type = String.format("%s (STREAMING)", type);
            }
            String keys = "";
            if (!node.getGroupingKeys().isEmpty()) {
                keys = this.formatSymbols(node.getGroupingKeys());
            }
            NodeRepresentation nodeOutput = this.addNode(node, "Aggregate", (Map<String, String>)ImmutableMap.of((Object)"type", (Object)type, (Object)"keys", (Object)keys, (Object)"hash", (Object)this.formatHash(node.getHashSymbol())), context);
            node.getAggregations().forEach((symbol, aggregation) -> nodeOutput.appendDetails("%s := %s", PlanPrinter.this.anonymizer.anonymize((Symbol)symbol), PlanPrinter.formatAggregation(PlanPrinter.this.anonymizer, aggregation)));
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitGroupId(GroupIdNode node, Context context) {
            List anonymizedInputGroupingSetSymbols = (List)node.getGroupingSets().stream().map(set -> (ImmutableList)set.stream().map(symbol -> node.getGroupingColumns().get(symbol)).collect(ImmutableList.toImmutableList())).map(this::formatSymbols).collect(ImmutableList.toImmutableList());
            NodeRepresentation nodeOutput = this.addNode(node, "GroupId", (Map<String, String>)ImmutableMap.of((Object)"symbols", (Object)PlanPrinter.formatCollection(anonymizedInputGroupingSetSymbols, Objects::toString)), context);
            for (Map.Entry<Symbol, Symbol> mapping : node.getGroupingColumns().entrySet()) {
                nodeOutput.appendDetails("%s := %s", PlanPrinter.this.anonymizer.anonymize(mapping.getKey()), PlanPrinter.this.anonymizer.anonymize(mapping.getValue()));
            }
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Context context) {
            this.addNode(node, "MarkDistinct", (Map<String, String>)ImmutableMap.of((Object)"distinct", (Object)this.formatOutputs(node.getDistinctSymbols()), (Object)"marker", (Object)PlanPrinter.this.anonymizer.anonymize(node.getMarkerSymbol()), (Object)"hash", (Object)this.formatHash(node.getHashSymbol())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitWindow(WindowNode node, Context context) {
            ImmutableMap.Builder descriptor = ImmutableMap.builder();
            if (!node.getPartitionBy().isEmpty()) {
                List prePartitioned = (List)node.getPartitionBy().stream().filter(node.getPrePartitionedInputs()::contains).collect(ImmutableList.toImmutableList());
                List notPrePartitioned = (List)node.getPartitionBy().stream().filter(column -> !node.getPrePartitionedInputs().contains(column)).collect(ImmutableList.toImmutableList());
                StringBuilder builder = new StringBuilder();
                if (!prePartitioned.isEmpty()) {
                    builder.append("<").append(Joiner.on((String)", ").join(this.anonymize(prePartitioned))).append(">");
                    if (!notPrePartitioned.isEmpty()) {
                        builder.append(", ");
                    }
                }
                if (!notPrePartitioned.isEmpty()) {
                    builder.append(Joiner.on((String)", ").join(this.anonymize(notPrePartitioned)));
                }
                descriptor.put((Object)"partitionBy", (Object)String.format("[%s]", builder));
            }
            if (node.getOrderingScheme().isPresent()) {
                descriptor.put((Object)"orderBy", (Object)this.formatOrderingScheme(node.getOrderingScheme().get(), node.getPreSortedOrderPrefix()));
            }
            NodeRepresentation nodeOutput = this.addNode(node, "Window", (Map<String, String>)descriptor.put((Object)"hash", (Object)this.formatHash(node.getHashSymbol())).buildOrThrow(), context);
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                WindowNode.Function function = entry.getValue();
                String frameInfo = this.formatFrame(function.getFrame());
                nodeOutput.appendDetails("%s := %s(%s%s) %s", PlanPrinter.this.anonymizer.anonymize(entry.getKey()), PlanPrinter.formatFunctionName(function.getResolvedFunction()), Joiner.on((String)", ").join(this.anonymizeExpressions(function.getArguments())), function.getOrderingScheme().map(this::formatOrderingScheme).orElse(""), frameInfo);
            }
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitPatternRecognition(PatternRecognitionNode node, Context context) {
            ImmutableMap.Builder descriptor = ImmutableMap.builder();
            if (!node.getPartitionBy().isEmpty()) {
                List prePartitioned = (List)node.getPartitionBy().stream().filter(node.getPrePartitionedInputs()::contains).collect(ImmutableList.toImmutableList());
                List notPrePartitioned = (List)node.getPartitionBy().stream().filter(column -> !node.getPrePartitionedInputs().contains(column)).collect(ImmutableList.toImmutableList());
                StringBuilder stringBuilder = new StringBuilder();
                if (!prePartitioned.isEmpty()) {
                    stringBuilder.append("<").append(Joiner.on((String)", ").join(this.anonymize(prePartitioned))).append(">");
                    if (!notPrePartitioned.isEmpty()) {
                        stringBuilder.append(", ");
                    }
                }
                if (!notPrePartitioned.isEmpty()) {
                    stringBuilder.append(Joiner.on((String)", ").join(this.anonymize(notPrePartitioned)));
                }
                descriptor.put((Object)"partitionBy", (Object)String.format("[%s]", stringBuilder));
            }
            if (node.getOrderingScheme().isPresent()) {
                descriptor.put((Object)"orderBy", (Object)this.formatOrderingScheme(node.getOrderingScheme().get(), node.getPreSortedOrderPrefix()));
            }
            NodeRepresentation nodeOutput = this.addNode(node, "PatternRecognition", (Map<String, String>)descriptor.put((Object)"hash", (Object)this.formatHash(node.getHashSymbol())).buildOrThrow(), context);
            if (node.getCommonBaseFrame().isPresent()) {
                nodeOutput.appendDetails("base frame: %s", this.formatFrame(node.getCommonBaseFrame().get()));
            }
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                WindowNode.Function function = entry.getValue();
                nodeOutput.appendDetails("%s := %s(%s)", PlanPrinter.this.anonymizer.anonymize(entry.getKey()), PlanPrinter.formatFunctionName(function.getResolvedFunction()), Joiner.on((String)", ").join(this.anonymizeExpressions(function.getArguments())));
            }
            for (Map.Entry<Symbol, Object> entry : node.getMeasures().entrySet()) {
                nodeOutput.appendDetails("%s := %s", PlanPrinter.this.anonymizer.anonymize(entry.getKey()), PlanPrinter.this.anonymizer.anonymize(((PatternRecognitionNode.Measure)entry.getValue()).getExpressionAndValuePointers().getExpression()));
                this.appendValuePointers(nodeOutput, ((PatternRecognitionNode.Measure)entry.getValue()).getExpressionAndValuePointers());
            }
            if (node.getRowsPerMatch() != RowsPerMatch.WINDOW) {
                nodeOutput.appendDetails("%s", this.formatRowsPerMatch(node.getRowsPerMatch()));
            }
            nodeOutput.appendDetails("%s", this.formatSkipTo(node.getSkipToPosition(), node.getSkipToLabels()));
            nodeOutput.appendDetails("pattern[%s] (%s)", node.getPattern(), node.isInitial() ? "INITIAL" : "SEEK");
            for (Map.Entry<Object, Object> entry : node.getVariableDefinitions().entrySet()) {
                nodeOutput.appendDetails("%s := %s", ((IrLabel)entry.getKey()).getName(), PlanPrinter.this.anonymizer.anonymize(((ExpressionAndValuePointers)entry.getValue()).getExpression()));
                this.appendValuePointers(nodeOutput, (ExpressionAndValuePointers)entry.getValue());
            }
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        private void appendValuePointers(NodeRepresentation nodeOutput, ExpressionAndValuePointers expressionAndPointers) {
            for (ExpressionAndValuePointers.Assignment assignment : expressionAndPointers.getAssignments()) {
                ValuePointer valuePointer;
                Objects.requireNonNull(assignment.valuePointer());
                int n = 0;
                String value = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AggregationValuePointer.class, ScalarValuePointer.class, ClassifierValuePointer.class, MatchNumberValuePointer.class}, (ValuePointer)valuePointer, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        AggregationValuePointer pointer = (AggregationValuePointer)valuePointer;
                        yield String.format("%s%s(%s)%s", pointer.getSetDescriptor().isRunning() ? "RUNNING " : "FINAL ", PlanPrinter.formatFunctionName(pointer.getFunction()), Joiner.on((String)", ").join(this.anonymizeExpressions(pointer.getArguments())), pointer.getSetDescriptor().getLabels().stream().map(IrLabel::getName).collect(Collectors.joining(", ", "{", "}")));
                    }
                    case 1 -> {
                        ScalarValuePointer pointer = (ScalarValuePointer)valuePointer;
                        yield String.format("%s[%s]", PlanPrinter.this.anonymizer.anonymize(pointer.getInputSymbol()), this.formatLogicalIndexPointer(pointer.getLogicalIndexPointer()));
                    }
                    case 2 -> {
                        ClassifierValuePointer pointer = (ClassifierValuePointer)valuePointer;
                        yield String.format("%s[%s]", "classifier", this.formatLogicalIndexPointer(pointer.getLogicalIndexPointer()));
                    }
                    case 3 -> {
                        MatchNumberValuePointer pointer = (MatchNumberValuePointer)valuePointer;
                        yield "match_number";
                    }
                };
                nodeOutput.appendDetails("%s%s := %s", TextRenderer.indentString(1), PlanPrinter.this.anonymizer.anonymize(assignment.symbol()), value);
            }
        }

        private String formatFrame(WindowNode.Frame frame) {
            StringBuilder builder = new StringBuilder(frame.getType().toString());
            frame.getStartValue().map(PlanPrinter.this.anonymizer::anonymize).ifPresent(value -> builder.append(" ").append((String)value));
            builder.append(" ").append((Object)frame.getStartType());
            frame.getEndValue().map(PlanPrinter.this.anonymizer::anonymize).ifPresent(value -> builder.append(" ").append((String)value));
            builder.append(" ").append((Object)frame.getEndType());
            return builder.toString();
        }

        private String formatLogicalIndexPointer(LogicalIndexPointer pointer) {
            StringBuilder builder = new StringBuilder();
            int physicalOffset = pointer.getPhysicalOffset();
            if (physicalOffset > 0) {
                builder.append("NEXT(");
            } else if (physicalOffset < 0) {
                builder.append("PREV(");
            }
            builder.append(pointer.isRunning() ? "RUNNING " : "FINAL ");
            builder.append(pointer.isLast() ? "LAST(" : "FIRST(");
            builder.append(pointer.getLabels().stream().map(IrLabel::getName).collect(Collectors.joining(", ", "{", "}")));
            if (pointer.getLogicalOffset() > 0) {
                builder.append(", ").append(pointer.getLogicalOffset());
            }
            builder.append(")");
            if (physicalOffset != 0) {
                builder.append(", ").append(Math.abs(physicalOffset)).append(")");
            }
            return builder.toString();
        }

        private String formatRowsPerMatch(RowsPerMatch rowsPerMatch) {
            return switch (rowsPerMatch) {
                case RowsPerMatch.ONE -> "ONE ROW PER MATCH";
                case RowsPerMatch.ALL_SHOW_EMPTY -> "ALL ROWS PER MATCH SHOW EMPTY MATCHES";
                case RowsPerMatch.ALL_OMIT_EMPTY -> "ALL ROWS PER MATCH OMIT EMPTY MATCHES";
                case RowsPerMatch.ALL_WITH_UNMATCHED -> "ALL ROWS PER MATCH WITH UNMATCHED ROWS";
                default -> throw new IllegalArgumentException("unexpected rowsPer match value: " + rowsPerMatch.name());
            };
        }

        private String formatSkipTo(SkipToPosition position, Set<IrLabel> labels) {
            return switch (position) {
                default -> throw new MatchException(null, null);
                case SkipToPosition.PAST_LAST -> "AFTER MATCH SKIP PAST LAST ROW";
                case SkipToPosition.NEXT -> "AFTER MATCH SKIP TO NEXT ROW";
                case SkipToPosition.FIRST -> "AFTER MATCH SKIP TO FIRST " + String.valueOf(labels);
                case SkipToPosition.LAST -> "AFTER MATCH SKIP TO LAST " + String.valueOf(labels);
            };
        }

        @Override
        public Void visitTopNRanking(TopNRankingNode node, Context context) {
            ImmutableMap.Builder descriptor = ImmutableMap.builder();
            descriptor.put((Object)"partitionBy", (Object)this.formatSymbols(node.getPartitionBy()));
            descriptor.put((Object)"orderBy", (Object)this.formatOrderingScheme(node.getOrderingScheme()));
            NodeRepresentation nodeOutput = this.addNode(node, "TopNRanking", (Map<String, String>)descriptor.put((Object)"limit", (Object)String.valueOf(node.getMaxRankingPerPartition())).put((Object)"hash", (Object)this.formatHash(node.getHashSymbol())).buildOrThrow(), context);
            nodeOutput.appendDetails("%s := %s", new Object[]{PlanPrinter.this.anonymizer.anonymize(node.getRankingSymbol()), node.getRankingType()});
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Context context) {
            ImmutableMap.Builder descriptor = ImmutableMap.builder();
            if (!node.getPartitionBy().isEmpty()) {
                descriptor.put((Object)"partitionBy", (Object)this.formatSymbols(node.getPartitionBy()));
            }
            if (node.getMaxRowCountPerPartition().isPresent()) {
                descriptor.put((Object)"limit", (Object)String.valueOf(node.getMaxRowCountPerPartition().get()));
            }
            NodeRepresentation nodeOutput = this.addNode(node, "RowNumber", (Map<String, String>)descriptor.put((Object)"hash", (Object)this.formatHash(node.getHashSymbol())).buildOrThrow(), context);
            nodeOutput.appendDetails("%s := %s", PlanPrinter.this.anonymizer.anonymize(node.getRowNumberSymbol()), "row_number()");
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitTableScan(TableScanNode node, Context context) {
            TableHandle table = node.getTable();
            TableInfo tableInfo = PlanPrinter.this.tableInfoSupplier.apply(node);
            NodeRepresentation nodeOutput = this.addNode(node, "TableScan", (Map<String, String>)ImmutableMap.of((Object)"table", (Object)PlanPrinter.this.anonymizer.anonymize(table, tableInfo)), context);
            this.printTableScanInfo(nodeOutput, node, tableInfo);
            PlanNodeStats nodeStats = this.stats.map(s -> (PlanNodeStats)s.get(node.getId())).orElse(null);
            if (nodeStats != null) {
                StringBuilder inputDetailBuilder = new StringBuilder();
                ImmutableList.Builder argsBuilder = ImmutableList.builder();
                Visitor.buildFormatString(inputDetailBuilder, (ImmutableList.Builder<String>)argsBuilder, "Input: %s (%s)", TextRenderer.formatPositions(nodeStats.getPlanNodeInputPositions()), nodeStats.getPlanNodeInputDataSize().toString());
                Visitor.addPhysicalInputStats(nodeStats, inputDetailBuilder, (ImmutableList.Builder<String>)argsBuilder);
                this.appendDetailsFromBuilder(nodeOutput, inputDetailBuilder, (ImmutableList.Builder<String>)argsBuilder);
            }
            return null;
        }

        @Override
        public Void visitValues(ValuesNode node, Context context) {
            NodeRepresentation nodeOutput = this.addNode(node, "Values", context);
            if (node.getRows().isEmpty()) {
                for (int i = 0; i < node.getRowCount(); ++i) {
                    nodeOutput.appendDetails("()", new Object[0]);
                }
                return null;
            }
            List<Expression> nodeRows = node.getRows().get();
            List rows = nodeRows.stream().map(row -> {
                if (row instanceof Row) {
                    return ((Row)row).items().stream().map(PlanPrinter.this.anonymizer::anonymize).collect(Collectors.joining(", ", "(", ")"));
                }
                return PlanPrinter.this.anonymizer.anonymize((Expression)row);
            }).limit(11L).collect(Collectors.toCollection(ArrayList::new));
            if (nodeRows.size() > 11) {
                rows.set(10, "(... %s more rows ...)".formatted(nodeRows.size() - 10));
            }
            for (String row2 : rows) {
                nodeOutput.appendDetails("%s", row2);
            }
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Context context) {
            return this.visitScanFilterAndProjectInfo(node, Optional.of(node), Optional.empty(), context);
        }

        @Override
        public Void visitProject(ProjectNode node, Context context) {
            if (node.getSource() instanceof FilterNode) {
                return this.visitScanFilterAndProjectInfo(node, Optional.of((FilterNode)node.getSource()), Optional.of(node), context);
            }
            return this.visitScanFilterAndProjectInfo(node, Optional.empty(), Optional.of(node), context);
        }

        private Void visitScanFilterAndProjectInfo(PlanNode node, Optional<FilterNode> filterNode, Optional<ProjectNode> projectNode, Context context) {
            Preconditions.checkState((projectNode.isPresent() || filterNode.isPresent() ? 1 : 0) != 0);
            PlanNode sourceNode = filterNode.isPresent() ? filterNode.get().getSource() : projectNode.get().getSource();
            Optional<Object> scanNode = sourceNode instanceof TableScanNode ? Optional.of((TableScanNode)sourceNode) : Optional.empty();
            Object operatorName = "";
            ImmutableMap.Builder descriptor = ImmutableMap.builder();
            if (scanNode.isPresent()) {
                operatorName = (String)operatorName + "Scan";
                descriptor.put((Object)"table", (Object)PlanPrinter.this.anonymizer.anonymize(((TableScanNode)scanNode.get()).getTable(), PlanPrinter.this.tableInfoSupplier.apply((TableScanNode)scanNode.get())));
            }
            Object dynamicFilters = ImmutableList.of();
            if (filterNode.isPresent()) {
                operatorName = (String)operatorName + "Filter";
                Expression predicate = filterNode.get().getPredicate();
                DynamicFilters.ExtractResult extractResult = DynamicFilters.extractDynamicFilters(predicate);
                descriptor.put((Object)"filterPredicate", (Object)this.formatFilter(IrUtils.combineConjunctsWithDuplicates(extractResult.getStaticConjuncts())));
                if (!extractResult.getDynamicConjuncts().isEmpty()) {
                    dynamicFilters = extractResult.getDynamicConjuncts();
                    descriptor.put((Object)"dynamicFilters", (Object)this.printDynamicFilters((Collection<DynamicFilters.Descriptor>)dynamicFilters));
                }
            }
            if (projectNode.isPresent()) {
                operatorName = (String)operatorName + "Project";
            }
            List<PlanNodeId> allNodes = Stream.of(scanNode, filterNode, projectNode).filter(Optional::isPresent).map(Optional::get).map(PlanNode::getId).collect(Collectors.toList());
            NodeRepresentation nodeOutput = this.addNode(node, (String)operatorName, (Map<String, String>)descriptor.buildOrThrow(), allNodes, (List<PlanNode>)ImmutableList.of((Object)sourceNode), (List<PlanNode>)ImmutableList.of(), Optional.empty(), context);
            projectNode.ifPresent(value -> this.printAssignments(nodeOutput, value.getAssignments()));
            if (scanNode.isPresent()) {
                this.printTableScanInfo(nodeOutput, (TableScanNode)scanNode.get(), PlanPrinter.this.tableInfoSupplier.apply((TableScanNode)scanNode.get()));
                PlanNodeStats nodeStats = this.stats.map(s -> (PlanNodeStats)s.get(node.getId())).orElse(null);
                if (nodeStats != null) {
                    double filtered = 100.0 * (double)(nodeStats.getPlanNodeInputPositions() - nodeStats.getPlanNodeOutputPositions()) / (double)nodeStats.getPlanNodeInputPositions();
                    StringBuilder inputDetailBuilder = new StringBuilder();
                    ImmutableList.Builder argsBuilder = ImmutableList.builder();
                    Visitor.buildFormatString(inputDetailBuilder, (ImmutableList.Builder<String>)argsBuilder, "Input: %s (%s), Filtered: %s%%", TextRenderer.formatPositions(nodeStats.getPlanNodeInputPositions()), nodeStats.getPlanNodeInputDataSize().toString(), TextRenderer.formatDouble(filtered));
                    Visitor.addPhysicalInputStats(nodeStats, inputDetailBuilder, (ImmutableList.Builder<String>)argsBuilder);
                    this.appendDetailsFromBuilder(nodeOutput, inputDetailBuilder, (ImmutableList.Builder<String>)argsBuilder);
                }
                List collectedDomainStats = (List)dynamicFilters.stream().map(DynamicFilters.Descriptor::getId).map(PlanPrinter.this.dynamicFilterDomainStats::get).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
                if (!collectedDomainStats.isEmpty()) {
                    nodeOutput.appendDetails("Dynamic filters: ", new Object[0]);
                    if (PlanPrinter.this.anonymizer instanceof NoOpAnonymizer) {
                        collectedDomainStats.forEach(stats -> nodeOutput.appendDetails("    - %s, %s, collection time=%s", stats.getDynamicFilterId(), stats.getSimplifiedDomain(), stats.getCollectionDuration().map(Duration::toString).orElse("uncollected")));
                    } else {
                        collectedDomainStats.forEach(stats -> nodeOutput.appendDetails("    - %s, collection time=%s", stats.getDynamicFilterId(), stats.getCollectionDuration().map(Duration::toString).orElse("uncollected")));
                    }
                }
                return null;
            }
            sourceNode.accept(this, new Context(context.isInitialPlan()));
            return null;
        }

        private static void addPhysicalInputStats(PlanNodeStats nodeStats, StringBuilder inputDetailBuilder, ImmutableList.Builder<String> argsBuilder) {
            if (nodeStats.getPlanNodePhysicalInputDataSize().toBytes() > 0L) {
                Visitor.buildFormatString(inputDetailBuilder, argsBuilder, ", Physical input: %s", nodeStats.getPlanNodePhysicalInputDataSize().toString());
                Visitor.buildFormatString(inputDetailBuilder, argsBuilder, ", Physical input time: %s", nodeStats.getPlanNodePhysicalInputReadTime().convertToMostSuccinctTimeUnit().toString());
            } else if (nodeStats.getPlanNodePhysicalInputReadTime().getValue() > 0.0) {
                Visitor.buildFormatString(inputDetailBuilder, argsBuilder, ", Physical input time: %s", nodeStats.getPlanNodePhysicalInputReadTime().convertToMostSuccinctTimeUnit().toString());
            }
        }

        @FormatMethod
        private static void buildFormatString(StringBuilder formatBuilder, ImmutableList.Builder<String> argsBuilder, String formatFragment, String ... fragmentArgs) {
            formatBuilder.append(formatFragment);
            argsBuilder.add((Object[])fragmentArgs);
        }

        private void appendDetailsFromBuilder(NodeRepresentation nodeOutput, StringBuilder inputDetailBuilder, ImmutableList.Builder<String> argsBuilder) {
            nodeOutput.appendDetails(inputDetailBuilder.toString(), argsBuilder.build().toArray());
        }

        private String printDynamicFilters(Collection<DynamicFilters.Descriptor> filters) {
            return filters.stream().map(filter -> PlanPrinter.this.anonymizer.anonymize(filter.getInput()) + " " + filter.getOperator().getValue() + " #" + String.valueOf(filter.getId())).collect(Collectors.joining(", ", "{", "}"));
        }

        private String printDynamicFilterAssignments(Map<DynamicFilterId, Symbol> filters) {
            return filters.entrySet().stream().map(filter -> PlanPrinter.this.anonymizer.anonymize((Symbol)filter.getValue()) + " -> #" + String.valueOf(filter.getKey())).collect(Collectors.joining(", ", "{", "}"));
        }

        private void printTableScanInfo(NodeRepresentation nodeOutput, TableScanNode node, TableInfo tableInfo) {
            TupleDomain<ColumnHandle> predicate = tableInfo.getPredicate();
            if (predicate.isNone()) {
                nodeOutput.appendDetails(":: NONE", new Object[0]);
            } else {
                for (Map.Entry<Symbol, ColumnHandle> assignment : node.getAssignments().entrySet()) {
                    ColumnHandle column = assignment.getValue();
                    nodeOutput.appendDetails("%s := %s", PlanPrinter.this.anonymizer.anonymize(assignment.getKey()), PlanPrinter.this.anonymizer.anonymize(column));
                    this.printConstraint(nodeOutput, column, predicate);
                }
                if (!predicate.isAll()) {
                    ImmutableSet outputs = ImmutableSet.copyOf(node.getAssignments().values());
                    ((Map)predicate.getDomains().get()).entrySet().stream().filter(arg_0 -> Visitor.lambda$printTableScanInfo$20((Set)outputs, arg_0)).forEach(entry -> {
                        ColumnHandle column = (ColumnHandle)entry.getKey();
                        nodeOutput.appendDetails("%s", PlanPrinter.this.anonymizer.anonymize(column));
                        this.printConstraint(nodeOutput, column, predicate);
                    });
                }
            }
        }

        @Override
        public Void visitUnnest(UnnestNode node, Context context) {
            Object name = node.getJoinType() == JoinType.INNER ? (node.getReplicateSymbols().isEmpty() ? "Unnest" : "CrossJoin Unnest") : node.getJoinType().getJoinLabel() + " Unnest on true";
            List unnestInputs = (List)node.getMappings().stream().map(UnnestNode.Mapping::getInput).collect(ImmutableList.toImmutableList());
            ImmutableMap.Builder descriptor = ImmutableMap.builder();
            if (!node.getReplicateSymbols().isEmpty()) {
                descriptor.put((Object)"replicate", (Object)this.formatOutputs(node.getReplicateSymbols()));
            }
            descriptor.put((Object)"unnest", (Object)this.formatOutputs(unnestInputs));
            this.addNode(node, (String)name, (Map<String, String>)descriptor.buildOrThrow(), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitOutput(OutputNode node, Context context) {
            NodeRepresentation nodeOutput = this.addNode(node, "Output", (Map<String, String>)ImmutableMap.of((Object)"columnNames", (Object)PlanPrinter.formatCollection(Collections2.filter(node.getColumnNames(), this::isNonSpooledColumn), PlanPrinter.this.anonymizer::anonymizeColumn)), context);
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                String name = node.getColumnNames().get(i);
                Symbol symbol = node.getOutputSymbols().get(i);
                if (symbol.type().equals((Object)SpooledBlock.SPOOLING_METADATA_TYPE) || name.equals(symbol.name())) continue;
                nodeOutput.appendDetails("%s := %s", PlanPrinter.this.anonymizer.anonymizeColumn(name), PlanPrinter.this.anonymizer.anonymize(symbol));
            }
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        private boolean isNonSpooledColumn(String columnName) {
            return !columnName.equals("$spooling:metadata$");
        }

        @Override
        public Void visitTopN(TopNNode node, Context context) {
            this.addNode(node, String.format("TopN%s", node.getStep() == TopNNode.Step.PARTIAL ? "Partial" : ""), (Map<String, String>)ImmutableMap.of((Object)"count", (Object)String.valueOf(node.getCount()), (Object)"orderBy", (Object)this.formatOrderingScheme(node.getOrderingScheme())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitSort(SortNode node, Context context) {
            this.addNode(node, String.format("%sSort", node.isPartial() ? "Partial" : ""), (Map<String, String>)ImmutableMap.of((Object)"orderBy", (Object)this.formatOrderingScheme(node.getOrderingScheme())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Context context) {
            this.addNode(node, String.format("Remote%s", node.getOrderingScheme().isPresent() ? "Merge" : "Source"), (Map<String, String>)ImmutableMap.of((Object)"sourceFragmentIds", (Object)PlanPrinter.formatCollection(node.getSourceFragmentIds(), Objects::toString)), (List<PlanNodeId>)ImmutableList.of(), (List<PlanNode>)ImmutableList.of(), (List<PlanNode>)ImmutableList.of(), Optional.empty(), context);
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Context context) {
            this.addNode(node, "Union", context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitIntersect(IntersectNode node, Context context) {
            this.addNode(node, "Intersect", (Map<String, String>)ImmutableMap.of((Object)"isDistinct", (Object)this.formatBoolean(node.isDistinct())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitExcept(ExceptNode node, Context context) {
            this.addNode(node, "Except", (Map<String, String>)ImmutableMap.of((Object)"isDistinct", (Object)this.formatBoolean(node.isDistinct())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitRefreshMaterializedView(RefreshMaterializedViewNode node, Context context) {
            this.addNode(node, "RefreshMaterializedView", (Map<String, String>)ImmutableMap.of((Object)"viewName", (Object)PlanPrinter.this.anonymizer.anonymize(node.getViewName())), context);
            return null;
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Context context) {
            NodeRepresentation nodeOutput = this.addNode(node, "TableWriter", context);
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                String name = node.getColumnNames().get(i);
                Symbol symbol = node.getColumns().get(i);
                nodeOutput.appendDetails("%s := %s", PlanPrinter.this.anonymizer.anonymizeColumn(name), PlanPrinter.this.anonymizer.anonymize(symbol));
            }
            if (node.getStatisticsAggregation().isPresent()) {
                Verify.verify((boolean)node.getStatisticsAggregationDescriptor().isPresent(), (String)"statisticsAggregationDescriptor is not present", (Object[])new Object[0]);
                this.printStatisticAggregations(nodeOutput, node.getStatisticsAggregation().get(), node.getStatisticsAggregationDescriptor().get());
            }
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitStatisticsWriterNode(StatisticsWriterNode node, Context context) {
            this.addNode(node, "StatisticsWriter", (Map<String, String>)ImmutableMap.of((Object)"target", (Object)PlanPrinter.this.anonymizer.anonymize(node.getTarget())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, Context context) {
            NodeRepresentation nodeOutput = this.addNode(node, "TableCommit", (Map<String, String>)ImmutableMap.of((Object)"target", (Object)PlanPrinter.this.anonymizer.anonymize(node.getTarget())), context);
            if (node.getStatisticsAggregation().isPresent()) {
                Verify.verify((boolean)node.getStatisticsAggregationDescriptor().isPresent(), (String)"statisticsAggregationDescriptor is not present", (Object[])new Object[0]);
                this.printStatisticAggregations(nodeOutput, node.getStatisticsAggregation().get(), node.getStatisticsAggregationDescriptor().get());
            }
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        private void printStatisticAggregations(NodeRepresentation nodeOutput, StatisticAggregations aggregations, StatisticAggregationsDescriptor<Symbol> descriptor) {
            nodeOutput.appendDetails("Collected statistics:", new Object[0]);
            this.printStatisticAggregationsInfo(nodeOutput, descriptor.getTableStatistics(), descriptor.getColumnStatistics(), aggregations.getAggregations());
            nodeOutput.appendDetails("%sgrouped by => [%s]", TextRenderer.indentString(1), this.getStatisticGroupingSetsInfo(descriptor.getGrouping()));
        }

        private String getStatisticGroupingSetsInfo(Map<String, Symbol> columnMappings) {
            return columnMappings.entrySet().stream().map(entry -> String.format("%s := %s", PlanPrinter.this.anonymizer.anonymize((Symbol)entry.getValue()), PlanPrinter.this.anonymizer.anonymizeColumn((String)entry.getKey()))).collect(Collectors.joining(", "));
        }

        private void printStatisticAggregationsInfo(NodeRepresentation nodeOutput, Map<TableStatisticType, Symbol> tableStatistics, Map<ColumnStatisticMetadata, Symbol> columnStatistics, Map<Symbol, AggregationNode.Aggregation> aggregations) {
            nodeOutput.appendDetails("aggregations =>", new Object[0]);
            for (Map.Entry<TableStatisticType, Symbol> entry : tableStatistics.entrySet()) {
                nodeOutput.appendDetails("%s%s => [%s := %s]", TextRenderer.indentString(1), PlanPrinter.this.anonymizer.anonymize(entry.getValue()), entry.getKey(), PlanPrinter.formatAggregation(PlanPrinter.this.anonymizer, aggregations.get(entry.getValue())));
            }
            for (Map.Entry<TableStatisticType, Symbol> entry : columnStatistics.entrySet()) {
                FunctionName aggregation;
                Object aggregationName = ((ColumnStatisticMetadata)entry.getKey()).getStatisticTypeIfPresent().isPresent() ? ((ColumnStatisticMetadata)entry.getKey()).getStatisticType().name() : ((aggregation = ((ColumnStatisticMetadata)entry.getKey()).getAggregation()).getCatalogSchema().isPresent() ? String.valueOf(aggregation.getCatalogSchema().get()) + "." + aggregation.getName() : aggregation.getName());
                nodeOutput.appendDetails("%s%s[%s] => [%s := %s]", TextRenderer.indentString(1), aggregationName, PlanPrinter.this.anonymizer.anonymizeColumn(((ColumnStatisticMetadata)entry.getKey()).getColumnName()), PlanPrinter.this.anonymizer.anonymize(entry.getValue()), PlanPrinter.formatAggregation(PlanPrinter.this.anonymizer, aggregations.get(entry.getValue())));
            }
        }

        @Override
        public Void visitSample(SampleNode node, Context context) {
            this.addNode(node, "Sample", (Map<String, String>)ImmutableMap.of((Object)"type", (Object)node.getSampleType().name(), (Object)"ratio", (Object)String.valueOf(node.getSampleRatio())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitExchange(ExchangeNode node, Context context) {
            if (node.getOrderingScheme().isPresent()) {
                this.addNode(node, String.format("%sMerge", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, node.getScope().toString())), (Map<String, String>)ImmutableMap.of((Object)"orderBy", (Object)this.formatOrderingScheme(node.getOrderingScheme().get())), context);
            } else if (node.getScope() == ExchangeNode.Scope.LOCAL) {
                this.addNode(node, "LocalExchange", (Map<String, String>)ImmutableMap.of((Object)"partitioning", (Object)PlanPrinter.this.anonymizer.anonymize(node.getPartitioningScheme().getPartitioning().getHandle()), (Object)"isReplicateNullsAndAny", (Object)this.formatBoolean(node.getPartitioningScheme().isReplicateNullsAndAny()), (Object)"hashColumn", (Object)this.formatHash(node.getPartitioningScheme().getHashColumn()), (Object)"arguments", (Object)PlanPrinter.formatCollection(node.getPartitioningScheme().getPartitioning().getArguments(), PlanPrinter.this.anonymizer::anonymize)), context);
            } else {
                this.addNode(node, String.format("%sExchange", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, node.getScope().toString())), (Map<String, String>)ImmutableMap.of((Object)"partitionCount", (Object)node.getPartitioningScheme().getPartitionCount().map(String::valueOf).orElse(""), (Object)"scaleWriters", (Object)this.formatBoolean(node.getPartitioningScheme().getPartitioning().getHandle().isScaleWriters()), (Object)"type", (Object)node.getType().name(), (Object)"isReplicateNullsAndAny", (Object)this.formatBoolean(node.getPartitioningScheme().isReplicateNullsAndAny()), (Object)"hashColumn", (Object)this.formatHash(node.getPartitioningScheme().getHashColumn())), context);
            }
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitAdaptivePlanNode(AdaptivePlanNode node, Context context) {
            this.addNode(node, "AdaptivePlan", (Map<String, String>)ImmutableMap.of(), (List<PlanNodeId>)ImmutableList.of((Object)node.getId()), (List<PlanNode>)ImmutableList.of((Object)node.getCurrentPlan()), (List<PlanNode>)ImmutableList.of((Object)node.getInitialPlan()), Optional.empty(), context);
            node.getInitialPlan().accept(this, new Context("Initial Plan", true));
            node.getCurrentPlan().accept(this, new Context("Current Plan", false));
            return null;
        }

        @Override
        public Void visitTableExecute(TableExecuteNode node, Context context) {
            NodeRepresentation nodeOutput = this.addNode(node, "TableExecute", context);
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                String name = node.getColumnNames().get(i);
                Symbol symbol = node.getColumns().get(i);
                nodeOutput.appendDetails("%s := %s", PlanPrinter.this.anonymizer.anonymizeColumn(name), PlanPrinter.this.anonymizer.anonymize(symbol));
            }
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitSimpleTableExecuteNode(SimpleTableExecuteNode node, Context context) {
            this.addNode(node, "SimpleTableExecute", (Map<String, String>)ImmutableMap.of((Object)"table", (Object)PlanPrinter.this.anonymizer.anonymize(node.getExecuteHandle())), context);
            return null;
        }

        @Override
        public Void visitMergeWriter(MergeWriterNode node, Context context) {
            this.addNode(node, "MergeWriter", (Map<String, String>)ImmutableMap.of((Object)"table", (Object)PlanPrinter.this.anonymizer.anonymize(node.getTarget())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitMergeProcessor(MergeProcessorNode node, Context context) {
            NodeRepresentation nodeOutput = this.addNode(node, "MergeProcessor", context);
            nodeOutput.appendDetails("target: %s", PlanPrinter.this.anonymizer.anonymize(node.getTarget()));
            nodeOutput.appendDetails("merge row column: %s", PlanPrinter.this.anonymizer.anonymize(node.getMergeRowSymbol()));
            nodeOutput.appendDetails("row id column: %s", PlanPrinter.this.anonymizer.anonymize(node.getRowIdSymbol()));
            nodeOutput.appendDetails("redistribution columns: %s", this.anonymize(node.getRedistributionColumnSymbols()));
            nodeOutput.appendDetails("data columns: %s", this.anonymize(node.getDataColumnSymbols()));
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitTableDelete(TableDeleteNode node, Context context) {
            this.addNode(node, "TableDelete", (Map<String, String>)ImmutableMap.of((Object)"target", (Object)PlanPrinter.this.anonymizer.anonymize(node.getTarget())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitTableUpdate(TableUpdateNode node, Context context) {
            this.addNode(node, "TableUpdate", (Map<String, String>)ImmutableMap.of((Object)"target", (Object)PlanPrinter.this.anonymizer.anonymize(node.getTarget())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitEnforceSingleRow(EnforceSingleRowNode node, Context context) {
            this.addNode(node, "EnforceSingleRow", context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitAssignUniqueId(AssignUniqueId node, Context context) {
            this.addNode(node, "AssignUniqueId", context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitGroupReference(GroupReference node, Context context) {
            this.addNode(node, "GroupReference", (Map<String, String>)ImmutableMap.of((Object)"groupId", (Object)String.valueOf(node.getGroupId())), (List<PlanNode>)ImmutableList.of(), Optional.empty(), context);
            return null;
        }

        @Override
        public Void visitApply(ApplyNode node, Context context) {
            NodeRepresentation nodeOutput = this.addNode(node, "Apply", (Map<String, String>)ImmutableMap.of((Object)"correlation", (Object)this.formatSymbols(node.getCorrelation())), context);
            this.printAssignments(nodeOutput, node.getSubqueryAssignments());
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitCorrelatedJoin(CorrelatedJoinNode node, Context context) {
            this.addNode(node, "CorrelatedJoin", (Map<String, String>)ImmutableMap.of((Object)"correlation", (Object)this.formatSymbols(node.getCorrelation()), (Object)"filter", (Object)this.formatFilter(node.getFilter())), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        public Void visitTableFunction(TableFunctionNode node, Context context) {
            NodeRepresentation nodeOutput = this.addNode(node, "TableFunction", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)node.getName()), context);
            if (!node.getArguments().isEmpty()) {
                nodeOutput.appendDetails("Arguments:", new Object[0]);
                Map tableArguments = (Map)node.getTableArgumentProperties().stream().collect(ImmutableMap.toImmutableMap(TableFunctionNode.TableArgumentProperties::argumentName, Function.identity()));
                node.getArguments().entrySet().forEach(entry -> nodeOutput.appendDetails("%s", this.formatArgument((String)entry.getKey(), (Argument)entry.getValue(), tableArguments)));
                if (!node.getCopartitioningLists().isEmpty()) {
                    nodeOutput.appendDetails("%s", node.getCopartitioningLists().stream().map(list -> list.stream().collect(Collectors.joining(", ", "(", ")"))).collect(Collectors.joining(", ", "Co-partition: [", "]")));
                }
            }
            for (int i = 0; i < node.getSources().size(); ++i) {
                node.getSources().get(i).accept(this, new Context(node.getTableArgumentProperties().get(i).argumentName(), context.isInitialPlan()));
            }
            return null;
        }

        private String formatArgument(String argumentName, Argument argument, Map<String, TableFunctionNode.TableArgumentProperties> tableArguments) {
            if (argument instanceof ScalarArgument) {
                ScalarArgument scalarArgument = (ScalarArgument)argument;
                return this.formatScalarArgument(argumentName, scalarArgument);
            }
            if (argument instanceof DescriptorArgument) {
                DescriptorArgument descriptorArgument = (DescriptorArgument)argument;
                return this.formatDescriptorArgument(argumentName, descriptorArgument);
            }
            TableFunctionNode.TableArgumentProperties argumentProperties = tableArguments.get(argumentName);
            return this.formatTableArgument(argumentName, argumentProperties);
        }

        private String formatScalarArgument(String argumentName, ScalarArgument argument) {
            return String.format("%s => ScalarArgument{type=%s, value=%s}", argumentName, argument.getType().getDisplayName(), PlanPrinter.this.anonymizer.anonymize(argument.getType(), PlanPrinter.this.valuePrinter.castToVarchar(argument.getType(), argument.getValue())));
        }

        private String formatDescriptorArgument(String argumentName, DescriptorArgument argument) {
            String descriptor = argument.equals((Object)DescriptorArgument.NULL_DESCRIPTOR) ? "NULL" : ((Descriptor)argument.getDescriptor().orElseThrow()).getFields().stream().map(field -> PlanPrinter.this.anonymizer.anonymizeColumn((String)field.getName().orElseThrow()) + field.getType().map(type -> " " + type.getDisplayName()).orElse("")).collect(Collectors.joining(", ", "(", ")"));
            return String.format("%s => DescriptorArgument{%s}", argumentName, descriptor);
        }

        private String formatTableArgument(String argumentName, TableFunctionNode.TableArgumentProperties argumentProperties) {
            StringBuilder properties = new StringBuilder();
            if (argumentProperties.rowSemantics()) {
                properties.append("row semantics");
            }
            argumentProperties.specification().ifPresent(specification -> {
                properties.append("partition by: [").append(Joiner.on((String)", ").join(this.anonymize(specification.partitionBy()))).append("]");
                specification.orderingScheme().ifPresent(orderingScheme -> properties.append(", order by: ").append(this.formatOrderingScheme((OrderingScheme)orderingScheme)));
            });
            properties.append("required columns: [").append(Joiner.on((String)", ").join(this.anonymize(argumentProperties.requiredColumns()))).append("]");
            if (argumentProperties.pruneWhenEmpty()) {
                properties.append(", prune when empty");
            }
            if (argumentProperties.passThroughSpecification().declaredAsPassThrough()) {
                properties.append(", pass through columns");
            }
            return String.format("%s => TableArgument{%s}", argumentName, properties);
        }

        @Override
        public Void visitTableFunctionProcessor(TableFunctionProcessorNode node, Context context) {
            ImmutableMap.Builder descriptor = ImmutableMap.builder();
            descriptor.put((Object)"name", (Object)node.getName());
            descriptor.put((Object)"properOutputs", (Object)String.format("[%s]", Joiner.on((String)", ").join(this.anonymize(node.getProperOutputs()))));
            node.getSpecification().ifPresent(specification -> {
                if (!specification.partitionBy().isEmpty()) {
                    List prePartitioned = (List)specification.partitionBy().stream().filter(node.getPrePartitioned()::contains).collect(ImmutableList.toImmutableList());
                    List notPrePartitioned = (List)specification.partitionBy().stream().filter(column -> !node.getPrePartitioned().contains(column)).collect(ImmutableList.toImmutableList());
                    StringBuilder builder = new StringBuilder();
                    if (!prePartitioned.isEmpty()) {
                        builder.append(this.anonymize(prePartitioned).stream().collect(Collectors.joining(", ", "<", ">")));
                        if (!notPrePartitioned.isEmpty()) {
                            builder.append(", ");
                        }
                    }
                    if (!notPrePartitioned.isEmpty()) {
                        builder.append(Joiner.on((String)", ").join(this.anonymize(notPrePartitioned)));
                    }
                    descriptor.put((Object)"partitionBy", (Object)String.format("[%s]", builder));
                }
                specification.orderingScheme().ifPresent(orderingScheme -> descriptor.put((Object)"orderBy", (Object)this.formatOrderingScheme((OrderingScheme)orderingScheme, node.getPreSorted())));
            });
            this.addNode(node, "TableFunctionProcessor", (Map<String, String>)descriptor.put((Object)"hash", (Object)this.formatHash(node.getHashSymbol())).buildOrThrow(), context);
            return this.processChildren(node, new Context(context.isInitialPlan()));
        }

        @Override
        protected Void visitPlan(PlanNode node, Context context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        private Void processChildren(PlanNode node, Context context) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, context);
            }
            return null;
        }

        private void printAssignments(NodeRepresentation nodeOutput, Assignments assignments) {
            for (Map.Entry<Symbol, Expression> entry : assignments.getMap().entrySet()) {
                if (entry.getValue() instanceof Reference && ((Reference)entry.getValue()).name().equals(entry.getKey().name())) continue;
                nodeOutput.appendDetails("%s := %s", PlanPrinter.this.anonymizer.anonymize(entry.getKey()), PlanPrinter.this.anonymizer.anonymize(entry.getValue()));
            }
        }

        private void printAssignments(NodeRepresentation nodeOutput, Map<Symbol, ApplyNode.SetExpression> assignments) {
            for (Map.Entry<Symbol, ApplyNode.SetExpression> entry : assignments.entrySet()) {
                ApplyNode.SetExpression setExpression;
                Objects.requireNonNull(entry.getValue());
                int n = 0;
                String assignment = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ApplyNode.In.class, ApplyNode.Exists.class, ApplyNode.QuantifiedComparison.class}, (ApplyNode.SetExpression)setExpression, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        ApplyNode.In in = (ApplyNode.In)setExpression;
                        yield "%s IN %s".formatted(PlanPrinter.this.anonymizer.anonymize(in.value()), PlanPrinter.this.anonymizer.anonymize(in.reference()));
                    }
                    case 1 -> {
                        ApplyNode.Exists unused = (ApplyNode.Exists)setExpression;
                        yield "EXISTS";
                    }
                    case 2 -> {
                        ApplyNode.QuantifiedComparison comparison = (ApplyNode.QuantifiedComparison)setExpression;
                        Object[] v1 = new Object[4];
                        v1[0] = PlanPrinter.this.anonymizer.anonymize(comparison.value());
                        String v2 = switch (comparison.operator()) {
                            default -> throw new MatchException(null, null);
                            case ApplyNode.Operator.EQUAL -> "=";
                            case ApplyNode.Operator.NOT_EQUAL -> "<>";
                            case ApplyNode.Operator.LESS_THAN -> "<";
                            case ApplyNode.Operator.LESS_THAN_OR_EQUAL -> "<=";
                            case ApplyNode.Operator.GREATER_THAN -> ">";
                            case ApplyNode.Operator.GREATER_THAN_OR_EQUAL -> ">=";
                        };
                        v1[1] = v2;
                        v1[2] = comparison.quantifier();
                        v1[3] = PlanPrinter.this.anonymizer.anonymize(comparison.reference());
                        yield "%s %s %s %s".formatted(v1);
                    }
                };
                nodeOutput.appendDetails("%s := %s", PlanPrinter.this.anonymizer.anonymize(entry.getKey()), assignment);
            }
        }

        private void printConstraint(NodeRepresentation nodeOutput, ColumnHandle column, TupleDomain<ColumnHandle> constraint) {
            Preconditions.checkArgument((!constraint.isNone() ? 1 : 0) != 0);
            Map domains = (Map)constraint.getDomains().get();
            if (domains.containsKey(column)) {
                nodeOutput.appendDetails("    :: %s", this.formatDomain(((Domain)domains.get(column)).simplify()));
            }
        }

        private String formatDomain(Domain domain) {
            ImmutableList.Builder parts = ImmutableList.builder();
            if (domain.isNullAllowed()) {
                parts.add((Object)"NULL");
            }
            Type type = domain.getType();
            domain.getValues().getValuesProcessor().consume(ranges -> {
                for (Range range : ranges.getOrderedRanges()) {
                    StringBuilder builder = new StringBuilder();
                    if (range.isSingleValue()) {
                        String value = PlanPrinter.this.anonymizer.anonymize(type, PlanPrinter.this.valuePrinter.castToVarchar(type, range.getSingleValue()));
                        builder.append('[').append(value).append(']');
                    } else {
                        builder.append(range.isLowInclusive() ? (char)'[' : (char)'(');
                        if (range.isLowUnbounded()) {
                            builder.append("<min>");
                        } else {
                            builder.append(PlanPrinter.this.anonymizer.anonymize(type, PlanPrinter.this.valuePrinter.castToVarchar(type, range.getLowBoundedValue())));
                        }
                        builder.append(", ");
                        if (range.isHighUnbounded()) {
                            builder.append("<max>");
                        } else {
                            builder.append(PlanPrinter.this.anonymizer.anonymize(type, PlanPrinter.this.valuePrinter.castToVarchar(type, range.getHighBoundedValue())));
                        }
                        builder.append(range.isHighInclusive() ? (char)']' : (char)')');
                    }
                    parts.add((Object)builder.toString());
                }
            }, discreteValues -> discreteValues.getValues().stream().map(value -> PlanPrinter.this.anonymizer.anonymize(type, PlanPrinter.this.valuePrinter.castToVarchar(type, value))).sorted().forEach(arg_0 -> ((ImmutableList.Builder)parts).add(arg_0)), allOrNone -> {
                if (allOrNone.isAll()) {
                    parts.add((Object)"ALL VALUES");
                }
            });
            return "[" + Joiner.on((String)", ").join((Iterable)parts.build()) + "]";
        }

        private String formatFilter(Expression filter) {
            return filter.equals(Booleans.TRUE) ? "" : PlanPrinter.this.anonymizer.anonymize(filter);
        }

        private String formatBoolean(boolean value) {
            return value ? "true" : "";
        }

        private String formatOrderingScheme(OrderingScheme orderingScheme, int preSortedOrderPrefix) {
            List orderBy = (List)Stream.concat(orderingScheme.orderBy().stream().limit(preSortedOrderPrefix).map(symbol -> "<" + PlanPrinter.this.anonymizer.anonymize((Symbol)symbol) + " " + String.valueOf(orderingScheme.ordering((Symbol)symbol)) + ">"), orderingScheme.orderBy().stream().skip(preSortedOrderPrefix).map(symbol -> PlanPrinter.this.anonymizer.anonymize((Symbol)symbol) + " " + String.valueOf(orderingScheme.ordering((Symbol)symbol)))).collect(ImmutableList.toImmutableList());
            return PlanPrinter.formatCollection(orderBy, Objects::toString);
        }

        private String formatOrderingScheme(OrderingScheme orderingScheme) {
            return PlanPrinter.formatOrderingScheme(PlanPrinter.this.anonymizer, orderingScheme);
        }

        @SafeVarargs
        private String formatHash(Optional<Symbol> ... hashes) {
            List symbols = (List)Arrays.stream(hashes).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
            return this.formatSymbols(symbols);
        }

        private String formatSymbols(Collection<Symbol> symbols) {
            return PlanPrinter.formatCollection(symbols, PlanPrinter.this.anonymizer::anonymize);
        }

        private List<String> anonymize(Collection<Symbol> symbols) {
            return (List)symbols.stream().map(PlanPrinter.this.anonymizer::anonymize).collect(ImmutableList.toImmutableList());
        }

        private List<String> anonymizeExpressions(List<Expression> expressions) {
            return (List)expressions.stream().map(PlanPrinter.this.anonymizer::anonymize).collect(ImmutableList.toImmutableList());
        }

        private String formatOutputs(Iterable<Symbol> outputs) {
            return Streams.stream(outputs).map(input -> PlanPrinter.this.anonymizer.anonymize((Symbol)input) + ":" + input.type().getDisplayName()).collect(Collectors.joining(", ", "[", "]"));
        }

        public NodeRepresentation addNode(PlanNode node, String name, Context context) {
            return this.addNode(node, name, (Map<String, String>)ImmutableMap.of(), context);
        }

        public NodeRepresentation addNode(PlanNode node, String name, Map<String, String> descriptor, Context context) {
            return this.addNode(node, name, descriptor, node.getSources(), Optional.empty(), context);
        }

        public NodeRepresentation addNode(PlanNode node, String name, Map<String, String> descriptor, Optional<PlanNodeStatsAndCostSummary> reorderJoinStatsAndCost, Context context) {
            return this.addNode(node, name, descriptor, node.getSources(), reorderJoinStatsAndCost, context);
        }

        public NodeRepresentation addNode(PlanNode node, String name, Map<String, String> descriptor, List<PlanNode> children, Optional<PlanNodeStatsAndCostSummary> reorderJoinStatsAndCost, Context context) {
            return this.addNode(node, name, descriptor, (List<PlanNodeId>)ImmutableList.of((Object)node.getId()), children, (List<PlanNode>)ImmutableList.of(), reorderJoinStatsAndCost, context);
        }

        public NodeRepresentation addNode(PlanNode rootNode, String name, Map<String, String> descriptor, List<PlanNodeId> allNodes, List<PlanNode> children, List<PlanNode> initialChildren, Optional<PlanNodeStatsAndCostSummary> reorderJoinStatsAndCost, Context context) {
            List childrenIds = (List)children.stream().map(PlanNode::getId).collect(ImmutableList.toImmutableList());
            List initialChildrenIds = (List)initialChildren.stream().map(PlanNode::getId).collect(ImmutableList.toImmutableList());
            List<PlanNodeStatsEstimate> estimatedStats = allNodes.stream().map(nodeId -> this.estimatedStatsAndCosts.getStats().getOrDefault(nodeId, PlanNodeStatsEstimate.unknown())).collect(Collectors.toList());
            List<PlanCostEstimate> estimatedCosts = allNodes.stream().map(nodeId -> this.estimatedStatsAndCosts.getCosts().getOrDefault(nodeId, PlanCostEstimate.unknown())).collect(Collectors.toList());
            name = context.tag().map(tagName -> String.format("[%s] ", tagName)).orElse("") + (String)name;
            NodeRepresentation nodeOutput = new NodeRepresentation(rootNode.getId(), (String)name, rootNode.getClass().getSimpleName(), descriptor, (List)rootNode.getOutputSymbols().stream().map(s -> new Symbol(s.type(), PlanPrinter.this.anonymizer.anonymize((Symbol)s))).collect(ImmutableList.toImmutableList()), this.stats.map(s -> (PlanNodeStats)s.get(rootNode.getId())), estimatedStats, estimatedCosts, reorderJoinStatsAndCost, childrenIds, initialChildrenIds);
            if (context.isInitialPlan()) {
                PlanPrinter.this.representation.addInitialNode(nodeOutput);
            } else {
                PlanPrinter.this.representation.addNode(nodeOutput);
            }
            return nodeOutput;
        }

        private static /* synthetic */ boolean lambda$printTableScanInfo$20(Set outputs, Map.Entry entry) {
            return !outputs.contains(entry.getKey());
        }
    }

    private record Context(Optional<String> tag, boolean isInitialPlan) {
        public Context(boolean isInitialPlan) {
            this(Optional.empty(), isInitialPlan);
        }

        public Context(String tag, boolean isInitialPlan) {
            this(Optional.of(tag), isInitialPlan);
        }

        private Context {
            Objects.requireNonNull(tag, "tag is null");
        }
    }
}

