/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.cost.FilterStatsCalculator;
import io.trino.cost.PlanNodeStatsAssertion;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.StatsNormalizer;
import io.trino.cost.SymbolStatsAssertion;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Test;

public class TestComparisonStatsCalculator {
    private final FilterStatsCalculator filterStatsCalculator = new FilterStatsCalculator(TestingPlannerContext.PLANNER_CONTEXT, new ScalarStatsCalculator(TestingPlannerContext.PLANNER_CONTEXT), new StatsNormalizer());
    private final Session session = TestingSession.testSessionBuilder().build();
    private final SymbolStatsEstimate uStats = SymbolStatsEstimate.builder().setAverageRowSize(8.0).setDistinctValuesCount(300.0).setLowValue(0.0).setHighValue(20.0).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate wStats = SymbolStatsEstimate.builder().setAverageRowSize(8.0).setDistinctValuesCount(30.0).setLowValue(0.0).setHighValue(20.0).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate xStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(40.0).setLowValue(-10.0).setHighValue(10.0).setNullsFraction(0.25).build();
    private final SymbolStatsEstimate yStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(20.0).setLowValue(0.0).setHighValue(5.0).setNullsFraction(0.5).build();
    private final SymbolStatsEstimate zStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(5.0).setLowValue(-100.0).setHighValue(100.0).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate leftOpenStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(15.0).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate rightOpenStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(-15.0).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate unknownRangeStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate emptyRangeStats = SymbolStatsEstimate.builder().setAverageRowSize(0.0).setDistinctValuesCount(0.0).setLowValue(Double.NaN).setHighValue(Double.NaN).setNullsFraction(1.0).build();
    private final SymbolStatsEstimate unknownNdvRangeStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(Double.NaN).setLowValue(0.0).setHighValue(10.0).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate varcharStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
    private final PlanNodeStatsEstimate standardInputStatistics = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "u"), this.uStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "w"), this.wStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "z"), this.zStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "leftOpen"), this.leftOpenStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "rightOpen"), this.rightOpenStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "unknownRange"), this.unknownRangeStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "emptyRange"), this.emptyRangeStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "unknownNdvRange"), this.unknownNdvRangeStats).addSymbolStatistics(new Symbol((Type)VarcharType.createVarcharType((int)10), "varchar"), this.varcharStats).setOutputRowCount(1000.0).build();

    private Consumer<SymbolStatsAssertion> equalTo(SymbolStatsEstimate estimate) {
        return symbolAssert -> symbolAssert.lowValue(estimate.getLowValue()).highValue(estimate.getHighValue()).distinctValuesCount(estimate.getDistinctValuesCount()).nullsFraction(estimate.getNullsFraction());
    }

    private SymbolStatsEstimate updateNDV(SymbolStatsEstimate symbolStats, double delta) {
        return symbolStats.mapDistinctValuesCount(ndv -> ndv + delta);
    }

    private SymbolStatsEstimate capNDV(SymbolStatsEstimate symbolStats, double rowCount) {
        double ndv = symbolStats.getDistinctValuesCount();
        double nulls = symbolStats.getNullsFraction();
        if (Double.isNaN(ndv) || Double.isNaN(rowCount) || Double.isNaN(nulls)) {
            return symbolStats;
        }
        if (ndv <= rowCount * (1.0 - nulls)) {
            return symbolStats;
        }
        return symbolStats.mapDistinctValuesCount(n -> (Math.min(ndv, rowCount) + rowCount * (1.0 - nulls)) / 2.0).mapNullsFraction(n -> nulls / 2.0);
    }

    private SymbolStatsEstimate zeroNullsFraction(SymbolStatsEstimate symbolStats) {
        return symbolStats.mapNullsFraction(fraction -> 0.0);
    }

    private PlanNodeStatsAssertion assertCalculate(Expression comparisonExpression) {
        return PlanNodeStatsAssertion.assertThat(this.filterStatsCalculator.filterStats(this.standardInputStatistics, comparisonExpression, this.session));
    }

    @Test
    public void verifyTestInputConsistent() {
        TestComparisonStatsCalculator.checkConsistent(new StatsNormalizer(), "standardInputStatistics", this.standardInputStatistics, this.standardInputStatistics.getSymbolsWithKnownStatistics());
    }

    @Test
    public void symbolToLiteralEqualStats() {
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)2.5))).outputRowsCount(25.0).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(2.5).highValue(2.5).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)10.0))).outputRowsCount(18.75).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(10.0).highValue(10.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)10.0))).outputRowsCount(0.0).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(0.0).distinctValuesCount(0.0).emptyRange().nullsFraction(1.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "leftOpen"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)2.5))).outputRowsCount(18.0).symbolStats("leftOpen", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(2.5).highValue(2.5).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "rightOpen"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-2.5))).outputRowsCount(18.0).symbolStats("rightOpen", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(-2.5).highValue(-2.5).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "unknownRange"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))).outputRowsCount(18.0).symbolStats("unknownRange", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(0.0).highValue(0.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "emptyRange"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))).outputRowsCount(0.0).symbolStats("emptyRange", this.equalTo(this.emptyRangeStats));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)VarcharType.createVarcharType((int)10), "varchar"), (Expression)new Constant((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"blah")))).outputRowsCount(18.0).symbolStats("varchar", (Type)VarcharType.createVarcharType((int)10), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY).nullsFraction(0.0));
    }

    @Test
    public void symbolToLiteralNotEqualStats() {
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)2.5))).outputRowsCount(475.0).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(19.0).lowValue(0.0).highValue(5.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)10.0))).outputRowsCount(731.25).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(39.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)10.0))).outputRowsCount(500.0).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(19.0).lowValue(0.0).highValue(5.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "leftOpen"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)2.5))).outputRowsCount(882.0).symbolStats("leftOpen", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(49.0).lowValueUnknown().highValue(15.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "rightOpen"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-2.5))).outputRowsCount(882.0).symbolStats("rightOpen", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(49.0).lowValue(-15.0).highValueUnknown().nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "unknownRange"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))).outputRowsCount(882.0).symbolStats("unknownRange", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(49.0).lowValueUnknown().highValueUnknown().nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "emptyRange"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))).outputRowsCount(0.0).symbolStats("emptyRange", this.equalTo(this.emptyRangeStats));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)VarcharType.createVarcharType((int)10), "varchar"), (Expression)new Constant((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"blah")))).outputRowsCount(882.0).symbolStats("varchar", (Type)VarcharType.createVarcharType((int)10), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(49.0).lowValueUnknown().highValueUnknown().nullsFraction(0.0));
    }

    @Test
    public void symbolToLiteralLessThanStats() {
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)2.5))).outputRowsCount(250.0).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(10.0).lowValue(0.0).highValue(2.5).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)10.0))).outputRowsCount(750.0).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(40.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-10.0))).outputRowsCount(18.75).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(-10.0).highValue(-10.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-10.0))).outputRowsCount(0.0).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(0.0).distinctValuesCount(0.0).emptyRange().nullsFraction(1.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "leftOpen"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))).outputRowsCount(450.0).symbolStats("leftOpen", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(25.0).lowValueUnknown().highValue(0.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "rightOpen"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))).outputRowsCount(225.0).symbolStats("rightOpen", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(12.5).lowValue(-15.0).highValue(0.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "unknownRange"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))).outputRowsCount(450.0).symbolStats("unknownRange", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(25.0).lowValueUnknown().highValue(0.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "emptyRange"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))).outputRowsCount(0.0).symbolStats("emptyRange", this.equalTo(this.emptyRangeStats));
    }

    @Test
    public void symbolToLiteralGreaterThanStats() {
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)2.5))).outputRowsCount(250.0).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(10.0).lowValue(2.5).highValue(5.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-10.0))).outputRowsCount(750.0).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(40.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)10.0))).outputRowsCount(18.75).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(10.0).highValue(10.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)10.0))).outputRowsCount(0.0).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(0.0).distinctValuesCount(0.0).emptyRange().nullsFraction(1.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "leftOpen"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))).outputRowsCount(225.0).symbolStats("leftOpen", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(12.5).lowValue(0.0).highValue(15.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "rightOpen"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))).outputRowsCount(450.0).symbolStats("rightOpen", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(25.0).lowValue(0.0).highValueUnknown().nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "unknownRange"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))).outputRowsCount(450.0).symbolStats("unknownRange", symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(25.0).lowValue(0.0).highValueUnknown().nullsFraction(0.0));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "emptyRange"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))).outputRowsCount(0.0).symbolStats("emptyRange", this.equalTo(this.emptyRangeStats));
    }

    @Test
    public void symbolToSymbolEqualStats() {
        double rowCount = 2.7;
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "u"), (Expression)new Reference((Type)DoubleType.DOUBLE, "w"))).outputRowsCount(rowCount).symbolStats("u", (Type)DoubleType.DOUBLE, this.equalTo(this.capNDV(this.zeroNullsFraction(this.uStats), rowCount))).symbolStats("w", (Type)DoubleType.DOUBLE, this.equalTo(this.capNDV(this.zeroNullsFraction(this.wStats), rowCount))).symbolStats("z", (Type)DoubleType.DOUBLE, this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 9.375;
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "y"))).outputRowsCount(rowCount).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(9.375).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(9.375).nullsFraction(0.0)).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 16.875;
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "w"))).outputRowsCount(rowCount).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(6.0).lowValue(0.0).highValue(10.0).distinctValuesCount(16.875).nullsFraction(0.0)).symbolStats("w", symbolAssert -> symbolAssert.averageRowSize(6.0).lowValue(0.0).highValue(10.0).distinctValuesCount(16.875).nullsFraction(0.0)).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 2.25;
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "u"))).outputRowsCount(rowCount).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(6.0).lowValue(0.0).highValue(10.0).distinctValuesCount(2.25).nullsFraction(0.0)).symbolStats("u", symbolAssert -> symbolAssert.averageRowSize(6.0).lowValue(0.0).highValue(10.0).distinctValuesCount(2.25).nullsFraction(0.0)).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
    }

    @Test
    public void symbolToSymbolNotEqual() {
        double rowCount = 807.3;
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "u"), (Expression)new Reference((Type)DoubleType.DOUBLE, "w"))).outputRowsCount(rowCount).symbolStats("u", this.equalTo(this.capNDV(this.zeroNullsFraction(this.uStats), rowCount))).symbolStats("w", this.equalTo(this.capNDV(this.zeroNullsFraction(this.wStats), rowCount))).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 365.625;
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "y"))).outputRowsCount(rowCount).symbolStats("x", this.equalTo(this.capNDV(this.zeroNullsFraction(this.xStats), rowCount))).symbolStats("y", this.equalTo(this.capNDV(this.zeroNullsFraction(this.yStats), rowCount))).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 658.125;
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "w"))).outputRowsCount(rowCount).symbolStats("x", this.equalTo(this.capNDV(this.zeroNullsFraction(this.xStats), rowCount))).symbolStats("w", this.equalTo(this.capNDV(this.zeroNullsFraction(this.wStats), rowCount))).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 672.75;
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "u"))).outputRowsCount(rowCount).symbolStats("x", this.equalTo(this.capNDV(this.zeroNullsFraction(this.xStats), rowCount))).symbolStats("u", this.equalTo(this.capNDV(this.zeroNullsFraction(this.uStats), rowCount))).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
    }

    @Test
    public void symbolToCastExpressionNotEqual() {
        double rowCount = 897.0;
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "u"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)10.0))).outputRowsCount(rowCount).symbolStats("u", this.equalTo(this.capNDV(this.updateNDV(this.zeroNullsFraction(this.uStats), -1.0), rowCount))).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
    }

    @Test
    public void symbolToSymbolInequalityStats() {
        double inputRowCount = this.standardInputStatistics.getOutputRowCount();
        double nullsFractionX = 0.25;
        double rowCount = inputRowCount * (1.0 - nullsFractionX);
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "x"))).outputRowsCount(rowCount).symbolStats("x", this.equalTo(this.capNDV(this.zeroNullsFraction(this.xStats), rowCount)));
        double nullsFractionU = 0.1;
        double nonNullRowCount = inputRowCount * (1.0 - nullsFractionU);
        rowCount = nonNullRowCount * 0.5;
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "u"), (Expression)new Reference((Type)DoubleType.DOUBLE, "w"))).outputRowsCount(rowCount).symbolStats("u", this.equalTo(this.capNDV(this.zeroNullsFraction(this.uStats), rowCount))).symbolStats("w", this.equalTo(this.capNDV(this.zeroNullsFraction(this.wStats), rowCount))).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        double overlappingFractionX = 0.25;
        double alwaysLesserFractionX = 0.5;
        double nullsFractionY = 0.5;
        nonNullRowCount = inputRowCount * (1.0 - nullsFractionY);
        rowCount = nonNullRowCount * (alwaysLesserFractionX + overlappingFractionX * 0.5);
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "y"))).outputRowsCount(rowCount).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(5.0).distinctValuesCount(30.0).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "y"))).outputRowsCount(rowCount).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(5.0).distinctValuesCount(30.0).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "y"), (Expression)new Reference((Type)DoubleType.DOUBLE, "x"))).outputRowsCount(rowCount).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(5.0).distinctValuesCount(30.0).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        double alwaysGreaterFractionX = 0.25;
        rowCount = nonNullRowCount * (alwaysGreaterFractionX + overlappingFractionX * 0.5);
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "y"))).outputRowsCount(rowCount).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "y"))).outputRowsCount(rowCount).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "y"), (Expression)new Reference((Type)DoubleType.DOUBLE, "x"))).outputRowsCount(rowCount).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        overlappingFractionX = 0.5;
        nonNullRowCount = inputRowCount * (1.0 - nullsFractionX);
        double overlappingFractionW = 0.5;
        double alwaysGreaterFractionW = 0.5;
        rowCount = nonNullRowCount * (alwaysLesserFractionX + overlappingFractionX * (overlappingFractionW * 0.5 + alwaysGreaterFractionW));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "w"))).outputRowsCount(rowCount).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(10.0).distinctValuesCount(40.0).nullsFraction(0.0)).symbolStats("w", symbolAssert -> symbolAssert.averageRowSize(8.0).lowValue(0.0).highValue(20.0).distinctValuesCount(30.0).nullsFraction(0.0)).symbolStats("z", this.equalTo(this.capNDV(this.zStats, rowCount)));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "w"), (Expression)new Reference((Type)DoubleType.DOUBLE, "x"))).outputRowsCount(rowCount).symbolStats("x", (Type)DoubleType.DOUBLE, symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(10.0).distinctValuesCount(40.0).nullsFraction(0.0)).symbolStats("w", symbolAssert -> symbolAssert.averageRowSize(8.0).lowValue(0.0).highValue(20.0).distinctValuesCount(30.0).nullsFraction(0.0)).symbolStats("z", (Type)DoubleType.DOUBLE, this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = nonNullRowCount * (overlappingFractionX * overlappingFractionW * 0.5);
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (Expression)new Reference((Type)DoubleType.DOUBLE, "w"))).outputRowsCount(rowCount).symbolStats("x", (Type)DoubleType.DOUBLE, symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("w", (Type)DoubleType.DOUBLE, symbolAssert -> symbolAssert.averageRowSize(8.0).lowValue(0.0).highValue(10.0).distinctValuesCount(15.0).nullsFraction(0.0)).symbolStats("z", (Type)DoubleType.DOUBLE, this.equalTo(this.capNDV(this.zStats, rowCount)));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "w"), (Expression)new Reference((Type)DoubleType.DOUBLE, "x"))).outputRowsCount(rowCount).symbolStats("x", (Type)DoubleType.DOUBLE, symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("w", (Type)DoubleType.DOUBLE, symbolAssert -> symbolAssert.averageRowSize(8.0).lowValue(0.0).highValue(10.0).distinctValuesCount(15.0).nullsFraction(0.0)).symbolStats("z", (Type)DoubleType.DOUBLE, this.equalTo(this.capNDV(this.zStats, rowCount)));
        double nullsFractionLeft = 0.1;
        nonNullRowCount = inputRowCount * (1.0 - nullsFractionLeft);
        double overlappingFractionLeft = 0.25;
        double alwaysLesserFractionLeft = 0.5;
        double overlappingFractionRight = 0.25;
        double alwaysGreaterFractionRight = 0.5;
        rowCount = nonNullRowCount * (alwaysLesserFractionLeft + overlappingFractionLeft * (overlappingFractionRight * 0.5 + alwaysGreaterFractionRight));
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "leftOpen"), (Expression)new Reference((Type)DoubleType.DOUBLE, "rightOpen"))).outputRowsCount(rowCount).symbolStats("leftOpen", (Type)DoubleType.DOUBLE, symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(Double.NEGATIVE_INFINITY).highValue(15.0).distinctValuesCount(37.5).nullsFraction(0.0)).symbolStats("rightOpen", (Type)DoubleType.DOUBLE, symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-15.0).highValue(Double.POSITIVE_INFINITY).distinctValuesCount(37.5).nullsFraction(0.0)).symbolStats("z", (Type)DoubleType.DOUBLE, this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = nonNullRowCount * (alwaysLesserFractionLeft + overlappingFractionLeft * 0.5);
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "leftOpen"), (Expression)new Reference((Type)DoubleType.DOUBLE, "unknownNdvRange"))).outputRowsCount(rowCount).symbolStats("leftOpen", (Type)DoubleType.DOUBLE, symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(Double.NEGATIVE_INFINITY).highValue(10.0).distinctValuesCount(37.5).nullsFraction(0.0)).symbolStats("unknownNdvRange", (Type)DoubleType.DOUBLE, symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(10.0).distinctValuesCount(Double.NaN).nullsFraction(0.0)).symbolStats("z", (Type)DoubleType.DOUBLE, this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = nonNullRowCount * 0.5;
        this.assertCalculate((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "leftOpen"), (Expression)new Reference((Type)DoubleType.DOUBLE, "unknownRange"))).outputRowsCount(rowCount).symbolStats("leftOpen", (Type)DoubleType.DOUBLE, symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(Double.NEGATIVE_INFINITY).highValue(15.0).distinctValuesCount(50.0).nullsFraction(0.0)).symbolStats("unknownRange", (Type)DoubleType.DOUBLE, symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY).distinctValuesCount(50.0).nullsFraction(0.0)).symbolStats("z", (Type)DoubleType.DOUBLE, this.equalTo(this.capNDV(this.zStats, rowCount)));
    }

    private static void checkConsistent(StatsNormalizer normalizer, String source, PlanNodeStatsEstimate stats, Collection<Symbol> outputSymbols) {
        PlanNodeStatsEstimate normalized = normalizer.normalize(stats, outputSymbols);
        if (Objects.equals(stats, normalized)) {
            return;
        }
        ArrayList<String> problems = new ArrayList<String>();
        if (Double.compare(stats.getOutputRowCount(), normalized.getOutputRowCount()) != 0) {
            problems.add(String.format("Output row count is %s, should be normalized to %s", stats.getOutputRowCount(), normalized.getOutputRowCount()));
        }
        for (Symbol symbol : stats.getSymbolsWithKnownStatistics()) {
            if (Objects.equals(stats.getSymbolStatistics(symbol), normalized.getSymbolStatistics(symbol))) continue;
            problems.add(String.format("Symbol stats for '%s' are \n\t\t\t\t\t%s, should be normalized to \n\t\t\t\t\t%s", symbol, stats.getSymbolStatistics(symbol), normalized.getSymbolStatistics(symbol)));
        }
        if (problems.isEmpty()) {
            problems.add(stats.toString());
        }
        throw new IllegalStateException(String.format("Rule %s returned inconsistent stats: %s", source, problems.stream().collect(Collectors.joining("\n\t\t\t", "\n\t\t\t", ""))));
    }
}

