/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.block.BlockAssertions;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.PageDeserializer;
import io.trino.execution.buffer.PageSerializer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.execution.buffer.PipelinedBufferInfo;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.buffer.TestingPagesSerdeFactory;
import io.trino.operator.PageAssertions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public final class BufferTestUtils {
    private static final PagesSerdeFactory PAGES_SERDE_FACTORY = new TestingPagesSerdeFactory();
    static final Duration NO_WAIT = new Duration(0.0, TimeUnit.MILLISECONDS);
    static final Duration MAX_WAIT = new Duration(1.0, TimeUnit.SECONDS);
    private static final DataSize BUFFERED_PAGE_SIZE = DataSize.ofBytes((long)BufferTestUtils.serializePage(BufferTestUtils.createPage(42)).getRetainedSize());

    private BufferTestUtils() {
    }

    static BufferResult getFuture(ListenableFuture<BufferResult> future, Duration maxWait) {
        Optional bufferResult = MoreFutures.tryGetFutureValue(future, (int)((int)maxWait.toMillis()), (TimeUnit)TimeUnit.MILLISECONDS);
        Preconditions.checkArgument((boolean)bufferResult.isPresent(), (Object)"bufferResult is empty");
        return (BufferResult)bufferResult.get();
    }

    static void assertBufferResultEquals(List<? extends Type> types, BufferResult actual, BufferResult expected) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)actual.getSerializedPages().size()).describedAs("page count", new Object[0])).isEqualTo(expected.getSerializedPages().size());
        ((AbstractLongAssert)Assertions.assertThat((long)actual.getToken()).describedAs("token", new Object[0])).isEqualTo(expected.getToken());
        PageDeserializer deserializer = PAGES_SERDE_FACTORY.createDeserializer(Optional.empty());
        for (int i = 0; i < actual.getSerializedPages().size(); ++i) {
            Page actualPage = deserializer.deserialize((Slice)actual.getSerializedPages().get(i));
            Page expectedPage = deserializer.deserialize((Slice)expected.getSerializedPages().get(i));
            Assertions.assertThat((int)actualPage.getChannelCount()).isEqualTo(expectedPage.getChannelCount());
            PageAssertions.assertPageEquals(types, actualPage, expectedPage);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual.isBufferComplete()).describedAs("buffer complete", new Object[0])).isEqualTo(expected.isBufferComplete());
    }

    static BufferResult createBufferResult(String bufferId, long token, List<Page> pages) {
        Preconditions.checkArgument((!pages.isEmpty() ? 1 : 0) != 0, (Object)"pages is empty");
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)pages.size());
        PageSerializer serializer = PAGES_SERDE_FACTORY.createSerializer(Optional.empty());
        for (Page p : pages) {
            builder.add((Object)serializer.serialize(p));
        }
        return new BufferResult(bufferId, token, token + (long)pages.size(), false, (List)builder.build());
    }

    public static Page createPage(int i) {
        return new Page(new Block[]{BlockAssertions.createLongsBlock(i)});
    }

    static Slice serializePage(Page page) {
        return PAGES_SERDE_FACTORY.createSerializer(Optional.empty()).serialize(page);
    }

    static DataSize sizeOfPages(int count) {
        return DataSize.ofBytes((long)(BUFFERED_PAGE_SIZE.toBytes() * (long)count));
    }

    static BufferResult getBufferResult(OutputBuffer buffer, PipelinedOutputBuffers.OutputBufferId bufferId, long sequenceId, DataSize maxSize, Duration maxWait) {
        ListenableFuture future = buffer.get(bufferId, sequenceId, maxSize);
        return BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, maxWait);
    }

    static void acknowledgeBufferResult(OutputBuffer buffer, PipelinedOutputBuffers.OutputBufferId bufferId, long sequenceId) {
        buffer.acknowledge(bufferId, sequenceId);
    }

    static ListenableFuture<Void> enqueuePage(OutputBuffer buffer, Page page) {
        buffer.enqueue((List)ImmutableList.of((Object)BufferTestUtils.serializePage(page)));
        ListenableFuture future = buffer.isFull();
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        return future;
    }

    static ListenableFuture<Void> enqueuePage(OutputBuffer buffer, Page page, int partition) {
        buffer.enqueue(partition, (List)ImmutableList.of((Object)BufferTestUtils.serializePage(page)));
        ListenableFuture future = buffer.isFull();
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        return future;
    }

    public static void addPage(OutputBuffer buffer, Page page) {
        buffer.enqueue((List)ImmutableList.of((Object)BufferTestUtils.serializePage(page)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)buffer.isFull().isDone()).describedAs("Expected add page to not block", new Object[0])).isTrue();
    }

    public static void addPage(OutputBuffer buffer, Page page, int partition) {
        buffer.enqueue(partition, (List)ImmutableList.of((Object)BufferTestUtils.serializePage(page)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)buffer.isFull().isDone()).describedAs("Expected add page to not block", new Object[0])).isTrue();
    }

    static void assertQueueState(OutputBuffer buffer, PipelinedOutputBuffers.OutputBufferId bufferId, int bufferedPages, int pagesSent) {
        Assertions.assertThat((Object)BufferTestUtils.getBufferInfo(buffer, bufferId)).isEqualTo((Object)new PipelinedBufferInfo(bufferId, (long)(bufferedPages + pagesSent), (long)(bufferedPages + pagesSent), bufferedPages, BufferTestUtils.sizeOfPages(bufferedPages).toBytes(), (long)pagesSent, false));
    }

    static void assertQueueState(OutputBuffer buffer, int unassignedPages, PipelinedOutputBuffers.OutputBufferId bufferId, int bufferedPages, int pagesSent) {
        OutputBufferInfo outputBufferInfo = buffer.getInfo();
        long assignedPages = ((List)outputBufferInfo.getPipelinedBufferStates().orElse(ImmutableList.of())).stream().mapToInt(PipelinedBufferInfo::getBufferedPages).sum();
        ((AbstractLongAssert)Assertions.assertThat((long)(outputBufferInfo.getTotalBufferedPages() - assignedPages)).describedAs("unassignedPages", new Object[0])).isEqualTo((long)unassignedPages);
        PipelinedBufferInfo bufferInfo = ((List)outputBufferInfo.getPipelinedBufferStates().orElse(ImmutableList.of())).stream().filter(info -> info.getBufferId().equals((Object)bufferId)).findAny().orElse(null);
        Assertions.assertThat((Object)bufferInfo).isEqualTo((Object)new PipelinedBufferInfo(bufferId, (long)(bufferedPages + pagesSent), (long)(bufferedPages + pagesSent), bufferedPages, BufferTestUtils.sizeOfPages(bufferedPages).toBytes(), (long)pagesSent, false));
    }

    static void assertQueueClosed(OutputBuffer buffer, PipelinedOutputBuffers.OutputBufferId bufferId, int pagesSent) {
        PipelinedBufferInfo bufferInfo = BufferTestUtils.getBufferInfo(buffer, bufferId);
        Assertions.assertThat((int)bufferInfo.getBufferedPages()).isEqualTo(0);
        Assertions.assertThat((long)bufferInfo.getPagesSent()).isEqualTo((long)pagesSent);
        Assertions.assertThat((boolean)bufferInfo.isFinished()).isEqualTo(true);
    }

    static void assertQueueClosed(OutputBuffer buffer, int unassignedPages, PipelinedOutputBuffers.OutputBufferId bufferId, int pagesSent) {
        OutputBufferInfo outputBufferInfo = buffer.getInfo();
        long assignedPages = ((List)outputBufferInfo.getPipelinedBufferStates().orElse(ImmutableList.of())).stream().mapToInt(PipelinedBufferInfo::getBufferedPages).sum();
        ((AbstractLongAssert)Assertions.assertThat((long)(outputBufferInfo.getTotalBufferedPages() - assignedPages)).describedAs("unassignedPages", new Object[0])).isEqualTo((long)unassignedPages);
        PipelinedBufferInfo bufferInfo = ((List)outputBufferInfo.getPipelinedBufferStates().orElse(ImmutableList.of())).stream().filter(info -> info.getBufferId().equals((Object)bufferId)).findAny().orElse(null);
        Assertions.assertThat((int)bufferInfo.getBufferedPages()).isEqualTo(0);
        Assertions.assertThat((long)bufferInfo.getPagesSent()).isEqualTo((long)pagesSent);
        Assertions.assertThat((boolean)bufferInfo.isFinished()).isEqualTo(true);
    }

    static void assertFinished(OutputBuffer buffer) {
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.FINISHED);
        for (PipelinedBufferInfo bufferInfo : (List)buffer.getInfo().getPipelinedBufferStates().orElse(ImmutableList.of())) {
            Assertions.assertThat((boolean)bufferInfo.isFinished()).isTrue();
            Assertions.assertThat((int)bufferInfo.getBufferedPages()).isEqualTo(0);
        }
    }

    static void assertFutureIsDone(Future<?> future) {
        MoreFutures.tryGetFutureValue(future, (int)5, (TimeUnit)TimeUnit.SECONDS);
        Assertions.assertThat((boolean)future.isDone()).isTrue();
    }

    private static PipelinedBufferInfo getBufferInfo(OutputBuffer buffer, PipelinedOutputBuffers.OutputBufferId bufferId) {
        for (PipelinedBufferInfo bufferInfo : (List)buffer.getInfo().getPipelinedBufferStates().orElse(ImmutableList.of())) {
            if (!bufferInfo.getBufferId().equals((Object)bufferId)) continue;
            return bufferInfo;
        }
        return null;
    }
}

