/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.buffer.ArbitraryOutputBuffer;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.BufferTestUtils;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.OutputBufferMemoryManager;
import io.trino.execution.buffer.OutputBufferStateMachine;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PipelinedBufferInfo;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.spi.Page;
import io.trino.spi.QueryId;
import io.trino.spi.type.BigintType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestArbitraryOutputBuffer {
    private static final String TASK_INSTANCE_ID = "task-instance-id";
    private static final ImmutableList<BigintType> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private static final PipelinedOutputBuffers.OutputBufferId FIRST = new PipelinedOutputBuffers.OutputBufferId(0);
    private static final PipelinedOutputBuffers.OutputBufferId SECOND = new PipelinedOutputBuffers.OutputBufferId(1);
    private ScheduledExecutorService stateNotificationExecutor;

    @BeforeAll
    public void setUp() {
        this.stateNotificationExecutor = Executors.newScheduledThreadPool(5, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    }

    @AfterAll
    public void tearDown() {
        if (this.stateNotificationExecutor != null) {
            this.stateNotificationExecutor.shutdownNow();
            this.stateNotificationExecutor = null;
        }
    }

    @Test
    public void testInvalidConstructorArg() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), DataSize.ofBytes((long)0L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("maxBufferSize must be at least 1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), DataSize.ofBytes((long)0L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("maxBufferSize must be at least 1");
    }

    @Test
    public void testSimple() {
        int i;
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY);
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)outputBuffers, BufferTestUtils.sizeOfPages(10));
        for (i = 0; i < 3; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0);
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 3, FIRST, 0, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 3, 0);
        buffer.get(FIRST, 3L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 0, 3);
        for (i = 3; i < 13; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 9, FIRST, 1, 3);
        ListenableFuture<Void> future = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(13));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 10, FIRST, 1, 3);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 3L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(3L, BufferTestUtils.createPage(3), new Page[0]));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 10, FIRST, 1, 3);
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        outputBuffers = outputBuffers.withBuffer(SECOND, 0);
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 10, SECOND, 0, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(4), BufferTestUtils.createPage(5), BufferTestUtils.createPage(6), BufferTestUtils.createPage(7), BufferTestUtils.createPage(8), BufferTestUtils.createPage(9), BufferTestUtils.createPage(10), BufferTestUtils.createPage(11), BufferTestUtils.createPage(12), BufferTestUtils.createPage(13)));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 10, 0);
        buffer.get(SECOND, 10L, BufferTestUtils.sizeOfPages(10)).cancel(true);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 0, 10);
        outputBuffers = outputBuffers.withNoMoreBufferIds();
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 1, 3);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 0, 10);
        BufferTestUtils.assertFutureIsDone(future);
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(14));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(15));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(16));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 2, FIRST, 1, 3);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 2, SECOND, 1, 10);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 10L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(10L, BufferTestUtils.createPage(14), new Page[0]));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 2, FIRST, 1, 3);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 2, SECOND, 1, 10);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 4L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(4L, BufferTestUtils.createPage(15), BufferTestUtils.createPage(16)));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 2, 4);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 1, 10);
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_BUFFERS);
        buffer.setNoMorePages();
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 2, 4);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 1, 10);
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.FLUSHING);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 6L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)6L, (boolean)true));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 0, 6);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 1, 10);
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.FLUSHING);
        buffer.destroy(FIRST);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 6);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 1, 10);
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.FLUSHING);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 11L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)11L, (boolean)true));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 0, 11);
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.FLUSHING);
        buffer.destroy(SECOND);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 6);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, SECOND, 11);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 6L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)6L, (boolean)true));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 11L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)11L, (boolean)true));
    }

    @Test
    public void testAcknowledge() {
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY);
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)outputBuffers, BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 3; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0);
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 3, FIRST, 0, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, FIRST, 2L);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 1, 2);
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, FIRST, 3L);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 0, 3);
        try {
            BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, FIRST, 4L);
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("Invalid sequence id");
        }
        for (int i = 3; i < 6; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 3, FIRST, 0, 3);
        buffer.get(FIRST, 3L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 2, FIRST, 1, 3);
    }

    @Test
    public void testBufferFull() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(2));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(2));
        TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(3));
    }

    @Test
    public void testDuplicateRequests() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 3; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 3, FIRST, 0, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 3, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 3, 0);
        buffer.get(FIRST, 3L, BufferTestUtils.sizeOfPages(10)).cancel(true);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)false));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 0, 3);
    }

    @Test
    public void testAddQueueAfterCreation() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_BUFFERS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected buffer to not change after no more buffers is set");
    }

    @Test
    public void testAddAfterFinish() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        buffer.setNoMorePages();
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        Assertions.assertThat((long)buffer.getInfo().getTotalPagesSent()).isEqualTo(0L);
    }

    @Test
    public void testAddQueueAfterNoMoreQueues() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.OPEN);
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withNoMoreBufferIds());
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_BUFFERS);
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withNoMoreBufferIds());
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_BUFFERS);
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withNoMoreBufferIds());
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_BUFFERS);
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestArbitraryOutputBuffer.lambda$testAddQueueAfterNoMoreQueues$3(buffer, (OutputBuffers)outputBuffers)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected buffer to not change after no more buffers is set");
    }

    @Test
    public void testAddAfterDestroy() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        buffer.destroy();
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        Assertions.assertThat((long)buffer.getInfo().getTotalPagesSent()).isEqualTo(0L);
    }

    @Test
    public void testGetBeforeCreate() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.OPEN);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(1));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(33));
        Assertions.assertThat((boolean)future.isDone()).isTrue();
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(33), new Page[0]));
    }

    @Test
    public void testResumeFromPreviousPosition() {
        int i;
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY);
        PipelinedOutputBuffers.OutputBufferId[] ids = new PipelinedOutputBuffers.OutputBufferId[5];
        for (int i2 = 0; i2 < ids.length; ++i2) {
            ids[i2] = new PipelinedOutputBuffers.OutputBufferId(i2);
            outputBuffers = outputBuffers.withBuffer(ids[i2], i2);
        }
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)outputBuffers, BufferTestUtils.sizeOfPages(5));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.OPEN);
        HashMap<PipelinedOutputBuffers.OutputBufferId, ListenableFuture> firstReads = new HashMap<PipelinedOutputBuffers.OutputBufferId, ListenableFuture>();
        for (PipelinedOutputBuffers.OutputBufferId id : ids) {
            firstReads.put(id, buffer.get(id, 0L, BufferTestUtils.sizeOfPages(1)));
        }
        Assertions.assertThat(firstReads.values()).noneMatch(Future::isDone);
        ArrayList<ListenableFuture> secondReads = new ArrayList<ListenableFuture>();
        for (i = 0; i < ids.length; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(33));
            Assertions.assertThat(secondReads).allMatch(future -> !future.isDone(), "No secondary reads should complete until after all first reads");
            List completedIds = firstReads.entrySet().stream().filter(entry -> ((ListenableFuture)entry.getValue()).isDone()).map(Map.Entry::getKey).collect(Collectors.toList());
            ((AbstractIntegerAssert)Assertions.assertThat((int)completedIds.size()).describedAs("One completed buffer read per page addition", new Object[0])).isEqualTo(1);
            PipelinedOutputBuffers.OutputBufferId completed = (PipelinedOutputBuffers.OutputBufferId)completedIds.get(0);
            BufferResult result = BufferTestUtils.getFuture((ListenableFuture<BufferResult>)((ListenableFuture)firstReads.remove(completed)), BufferTestUtils.NO_WAIT);
            secondReads.add(buffer.get(completed, result.getNextToken(), BufferTestUtils.sizeOfPages(1)));
        }
        Assertions.assertThat(secondReads).hasSize(ids.length);
        for (i = 0; i < ids.length; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(33));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ListenableFuture)secondReads.get(i)).isDone()).describedAs("Invalid second read completion order at index: " + i, new Object[0])).isTrue();
        }
    }

    @Test
    public void testUseUndeclaredBufferAfterFinalBuffersSet() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_BUFFERS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> buffer.get(SECOND, 0L, BufferTestUtils.sizeOfPages(1))).isInstanceOf(IllegalStateException.class)).hasMessage("No more buffers already set");
    }

    @Test
    public void testAbortBeforeCreate() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.OPEN);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(1));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        buffer.destroy(FIRST);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)false));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(33));
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
    }

    @Test
    public void testFullBufferBlocksWriter() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(2));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(2));
        TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(3));
    }

    @Test
    public void testAbort() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 10; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        buffer.setNoMorePages();
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0);
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.destroy(FIRST);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 9, FIRST, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 1L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
        outputBuffers = outputBuffers.withBuffer(SECOND, 0).withNoMoreBufferIds();
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(1), new Page[0]));
        buffer.destroy(SECOND);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, SECOND, 0);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 1L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
    }

    @Test
    public void testFinishClosesEmptyQueues() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        buffer.setNoMorePages();
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 0, 0);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 0, 0);
        buffer.destroy(FIRST);
        buffer.destroy(SECOND);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 0);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, SECOND, 0);
    }

    @Test
    public void testAbortFreesReader() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.OPEN);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        buffer.destroy(FIRST);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 1);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)false));
    }

    @Test
    public void testFinishFreesReader() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.OPEN);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 0, 1);
        buffer.destroy(FIRST);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 1);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)false));
    }

    @Test
    public void testFinishFreesWriter() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(5));
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds());
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_BUFFERS);
        for (int i = 0; i < 5; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        ListenableFuture<Void> firstEnqueuePage = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(5));
        ListenableFuture<Void> secondEnqueuePage = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(6));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(100)).cancel(true);
        Assertions.assertThat((boolean)firstEnqueuePage.isDone()).isFalse();
        Assertions.assertThat((boolean)secondEnqueuePage.isDone()).isFalse();
        buffer.setNoMorePages();
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.FLUSHING);
        BufferTestUtils.assertFutureIsDone(firstEnqueuePage);
        BufferTestUtils.assertFutureIsDone(secondEnqueuePage);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 1L, BufferTestUtils.sizeOfPages(100), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(1L, BufferTestUtils.createPage(1), BufferTestUtils.createPage(2), BufferTestUtils.createPage(3), BufferTestUtils.createPage(4), BufferTestUtils.createPage(5), BufferTestUtils.createPage(6)));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 7L, BufferTestUtils.sizeOfPages(100), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)7L, (boolean)true));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.FLUSHING);
        buffer.destroy(FIRST);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
    }

    @Test
    public void testDestroyFreesReader() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(5));
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds());
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_BUFFERS);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        buffer.destroy();
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 1);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)false));
    }

    @Test
    public void testDestroyFreesWriter() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(5));
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds());
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_BUFFERS);
        for (int i = 0; i < 5; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        ListenableFuture<Void> firstEnqueuePage = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(5));
        ListenableFuture<Void> secondEnqueuePage = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(6));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        Assertions.assertThat((boolean)firstEnqueuePage.isDone()).isFalse();
        Assertions.assertThat((boolean)secondEnqueuePage.isDone()).isFalse();
        buffer.destroy();
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
        BufferTestUtils.assertFutureIsDone(firstEnqueuePage);
        BufferTestUtils.assertFutureIsDone(secondEnqueuePage);
    }

    @Test
    public void testFailDoesNotFreeReader() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_BUFFERS);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        buffer.abort();
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
    }

    @Test
    public void testFailFreesWriter() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_BUFFERS);
        for (int i = 0; i < 5; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        ListenableFuture<Void> firstEnqueuePage = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(5));
        ListenableFuture<Void> secondEnqueuePage = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(6));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        Assertions.assertThat((boolean)firstEnqueuePage.isDone()).isFalse();
        Assertions.assertThat((boolean)secondEnqueuePage.isDone()).isFalse();
        buffer.abort();
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.ABORTED);
        BufferTestUtils.assertFutureIsDone(firstEnqueuePage);
        BufferTestUtils.assertFutureIsDone(secondEnqueuePage);
    }

    @Test
    public void testAddBufferAfterFail() {
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0);
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)outputBuffers, BufferTestUtils.sizeOfPages(5));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.OPEN);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.abort();
        outputBuffers = outputBuffers.withBuffer(SECOND, 0);
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        future = buffer.get(SECOND, 0L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        outputBuffers = outputBuffers.withNoMoreBufferIds();
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        future = buffer.get(SECOND, 0L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
    }

    @Test
    public void testBufferCompletion() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(5));
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds());
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_BUFFERS);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (int i = 0; i < 5; ++i) {
            Page page = BufferTestUtils.createPage(i);
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, page);
            pages.add(page);
        }
        buffer.setNoMorePages();
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(5), BufferTestUtils.MAX_WAIT), BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, 0L, pages));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.FLUSHING);
        buffer.destroy(FIRST);
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.FINISHED);
    }

    @Test
    public void testNoMorePagesFreesReader() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.OPEN);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        buffer.setNoMorePages();
        Assertions.assertThat((boolean)future.isDone()).isTrue();
        Assertions.assertThat((boolean)buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10)).isDone()).isTrue();
    }

    @Test
    public void testFinishBeforeNoMoreBuffers() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 3; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        buffer.setNoMorePages();
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_PAGES);
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0);
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_PAGES);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_PAGES);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 1L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(1L, BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 3L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)3L, (boolean)true));
        Assertions.assertThat((Comparable)buffer.getState()).isEqualTo((Object)BufferState.NO_MORE_PAGES);
        buffer.destroy(FIRST);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 3);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
        outputBuffers = outputBuffers.withBuffer(SECOND, 0);
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
    }

    @Test
    public void testForceFreeMemory() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 3; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        OutputBufferMemoryManager memoryManager = buffer.getMemoryManager();
        Assertions.assertThat((memoryManager.getBufferedBytes() > 0L ? 1 : 0) != 0).isTrue();
        buffer.forceFreeMemory();
        Assertions.assertThat((long)memoryManager.getBufferedBytes()).isEqualTo(0L);
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        Assertions.assertThat((long)memoryManager.getBufferedBytes()).isEqualTo(0L);
    }

    private static BufferResult getBufferResult(OutputBuffer buffer, PipelinedOutputBuffers.OutputBufferId bufferId, long sequenceId, DataSize maxSize, Duration maxWait) {
        ListenableFuture future = buffer.get(bufferId, sequenceId, maxSize);
        return BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, maxWait);
    }

    private static ListenableFuture<Void> enqueuePage(OutputBuffer buffer, Page page) {
        buffer.enqueue((List)ImmutableList.of((Object)BufferTestUtils.serializePage(page)));
        ListenableFuture future = buffer.isFull();
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        return future;
    }

    private static void addPage(OutputBuffer buffer, Page page) {
        buffer.enqueue((List)ImmutableList.of((Object)BufferTestUtils.serializePage(page)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)buffer.isFull().isDone()).describedAs("Expected add page to not block", new Object[0])).isTrue();
    }

    private static void assertQueueState(OutputBuffer buffer, int unassignedPages, PipelinedOutputBuffers.OutputBufferId bufferId, int bufferedPages, int pagesSent) {
        OutputBufferInfo outputBufferInfo = buffer.getInfo();
        long assignedPages = ((List)outputBufferInfo.getPipelinedBufferStates().orElse(ImmutableList.of())).stream().mapToInt(PipelinedBufferInfo::getBufferedPages).sum();
        ((AbstractLongAssert)Assertions.assertThat((long)(outputBufferInfo.getTotalBufferedPages() - assignedPages)).describedAs("unassignedPages", new Object[0])).isEqualTo((long)unassignedPages);
        PipelinedBufferInfo bufferInfo = ((List)outputBufferInfo.getPipelinedBufferStates().orElse(ImmutableList.of())).stream().filter(info -> info.getBufferId().equals((Object)bufferId)).findAny().orElse(null);
        Assertions.assertThat((Object)bufferInfo).isEqualTo((Object)new PipelinedBufferInfo(bufferId, (long)(bufferedPages + pagesSent), (long)(bufferedPages + pagesSent), bufferedPages, BufferTestUtils.sizeOfPages(bufferedPages).toBytes(), (long)pagesSent, false));
    }

    private static void assertQueueClosed(OutputBuffer buffer, int unassignedPages, PipelinedOutputBuffers.OutputBufferId bufferId, int pagesSent) {
        OutputBufferInfo outputBufferInfo = buffer.getInfo();
        long assignedPages = ((List)outputBufferInfo.getPipelinedBufferStates().orElse(ImmutableList.of())).stream().mapToInt(PipelinedBufferInfo::getBufferedPages).sum();
        ((AbstractLongAssert)Assertions.assertThat((long)(outputBufferInfo.getTotalBufferedPages() - assignedPages)).describedAs("unassignedPages", new Object[0])).isEqualTo((long)unassignedPages);
        PipelinedBufferInfo bufferInfo = ((List)outputBufferInfo.getPipelinedBufferStates().orElse(ImmutableList.of())).stream().filter(info -> info.getBufferId().equals((Object)bufferId)).findAny().orElse(null);
        Assertions.assertThat((int)bufferInfo.getBufferedPages()).isEqualTo(0);
        Assertions.assertThat((long)bufferInfo.getPagesSent()).isEqualTo((long)pagesSent);
        Assertions.assertThat((boolean)bufferInfo.isFinished()).isTrue();
    }

    private ArbitraryOutputBuffer createArbitraryBuffer(OutputBuffers buffers, DataSize dataSize) {
        ArbitraryOutputBuffer buffer = new ArbitraryOutputBuffer(TASK_INSTANCE_ID, new OutputBufferStateMachine(new TaskId(new StageId(new QueryId("query"), 0), 0, 0), (Executor)this.stateNotificationExecutor), dataSize, () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), (Executor)this.stateNotificationExecutor);
        buffer.setOutputBuffers(buffers);
        return buffer;
    }

    private static BufferResult bufferResult(long token, Page firstPage, Page ... otherPages) {
        ImmutableList pages = ImmutableList.builder().add((Object)firstPage).add((Object[])otherPages).build();
        return BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, token, (List<Page>)pages);
    }

    private static /* synthetic */ void lambda$testAddQueueAfterNoMoreQueues$3(ArbitraryOutputBuffer buffer, OutputBuffers outputBuffers) throws Throwable {
        buffer.setOutputBuffers(outputBuffers);
    }
}

