/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import io.airlift.units.DataSize;
import io.trino.execution.ManagedQueryExecution;
import io.trino.execution.MockManagedQueryExecution;
import io.trino.execution.resourcegroups.InternalResourceGroup;
import io.trino.jmh.Benchmarks;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=1)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkResourceGroup {
    @Benchmark
    public Object benchmark(BenchmarkData data) {
        data.getRoot().updateGroupsAndProcessQueuedQueries();
        return data.getRoot();
    }

    public static void main(String[] args) throws Exception {
        Benchmarks.benchmark(BenchmarkResourceGroup.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"1000", "10000", "100000"})
        private int children = 1000;
        @Param(value={"100", "1000", "10000"})
        private int queries = 100;
        private final ExecutorService executor = Executors.newSingleThreadExecutor();
        private InternalResourceGroup root;

        @Setup
        public void setup() {
            int i;
            this.root = new InternalResourceGroup("root", (internalResourceGroup, bl) -> {}, (Executor)this.executor);
            this.root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
            this.root.setMaxQueuedQueries(this.queries);
            this.root.setHardConcurrencyLimit(this.queries);
            InternalResourceGroup group = this.root;
            for (i = 0; i < this.children; ++i) {
                group = this.root.getOrCreateSubGroup(String.valueOf(i));
                group.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
                group.setMaxQueuedQueries(this.queries);
                group.setHardConcurrencyLimit(this.queries);
            }
            for (i = 0; i < this.queries; ++i) {
                MockManagedQueryExecution query = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withInitialMemoryUsage(DataSize.ofBytes((long)10L)).build();
                group.run((ManagedQueryExecution)query);
            }
        }

        @TearDown
        public void tearDown() {
            this.executor.shutdownNow();
        }

        public InternalResourceGroup getRoot() {
            return this.root;
        }
    }
}

