/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import io.trino.client.NodeVersion;
import io.trino.execution.MockRemoteTaskFactory;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.RemoteTask;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.scheduler.FixedCountScheduler;
import io.trino.execution.scheduler.ScheduleResult;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestFixedCountScheduler {
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "executor-%s")));
    private ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "scheduledExecutor-%s")));
    private final MockRemoteTaskFactory taskFactory = new MockRemoteTaskFactory(this.executor, this.scheduledExecutor);

    @AfterAll
    public void destroyExecutor() {
        this.executor.shutdownNow();
        this.executor = null;
        this.scheduledExecutor.shutdown();
        this.scheduledExecutor = null;
    }

    @Test
    public void testSingleNode() {
        FixedCountScheduler nodeScheduler = new FixedCountScheduler((node, partition) -> Optional.of(this.taskFactory.createTableScanTask(new TaskId(new StageId("test", 1), 1, 0), node, (List<Split>)ImmutableList.of(), new NodeTaskMap.PartitionedSplitCountTracker(delta -> {}))), TestFixedCountScheduler.generateRandomNodes(1));
        ScheduleResult result = nodeScheduler.schedule();
        Assertions.assertThat((boolean)result.isFinished()).isTrue();
        Assertions.assertThat((boolean)result.getBlocked().isDone()).isTrue();
        Assertions.assertThat((Collection)result.getNewTasks()).hasSize(1);
        Assertions.assertThat((String)((RemoteTask)result.getNewTasks().iterator().next()).getNodeId()).isEqualTo("other 0");
    }

    @Test
    public void testMultipleNodes() {
        FixedCountScheduler nodeScheduler = new FixedCountScheduler((node, partition) -> Optional.of(this.taskFactory.createTableScanTask(new TaskId(new StageId("test", 1), 1, 0), node, (List<Split>)ImmutableList.of(), new NodeTaskMap.PartitionedSplitCountTracker(delta -> {}))), TestFixedCountScheduler.generateRandomNodes(5));
        ScheduleResult result = nodeScheduler.schedule();
        Assertions.assertThat((boolean)result.isFinished()).isTrue();
        Assertions.assertThat((boolean)result.getBlocked().isDone()).isTrue();
        Assertions.assertThat((Collection)result.getNewTasks()).hasSize(5);
        Assertions.assertThat((Collection)((Collection)result.getNewTasks().stream().map(RemoteTask::getNodeId).collect(ImmutableSet.toImmutableSet()))).hasSize(5);
    }

    private static List<InternalNode> generateRandomNodes(int count) {
        return (List)IntStream.range(0, count).mapToObj(i -> new InternalNode("other " + i, URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false)).collect(ImmutableList.toImmutableList());
    }
}

