/*
 * Decompiled with CFR 0.152.
 */
package io.trino.failuredetector;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceTypes;
import io.airlift.discovery.client.testing.TestingDiscoveryModule;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.testing.TestingJmxModule;
import io.airlift.json.JsonModule;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.node.testing.TestingNodeModule;
import io.trino.execution.QueryManagerConfig;
import io.trino.failuredetector.FailureDetectorModule;
import io.trino.failuredetector.HeartbeatFailureDetector;
import io.trino.server.InternalCommunicationConfig;
import io.trino.server.security.SecurityConfig;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.lang.annotation.Annotation;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHeartbeatFailureDetector {
    @Test
    public void testExcludesCurrentNode() {
        Bootstrap app = new Bootstrap(new Module[]{new TestingNodeModule(), new TestingJmxModule(), new TestingDiscoveryModule(), new TestingHttpServerModule(), new JsonModule(), new JaxrsModule(), new FailureDetectorModule(), binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(SecurityConfig.class);
            ConfigBinder.configBinder((Binder)binder).bindConfig(InternalCommunicationConfig.class);
            ConfigBinder.configBinder((Binder)binder).bindConfig(QueryManagerConfig.class);
            DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector("trino");
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("trino");
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(FooResource.class);
        }});
        Injector injector = app.doNotInitializeLogging().quiet().initialize();
        ServiceSelector selector = (ServiceSelector)injector.getInstance(Key.get(ServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"trino")));
        Assertions.assertThat((List)selector.selectAllServices()).hasSize(1);
        HeartbeatFailureDetector detector = (HeartbeatFailureDetector)injector.getInstance(HeartbeatFailureDetector.class);
        detector.updateMonitoredServices();
        Assertions.assertThat((int)detector.getTotalCount()).isEqualTo(0);
        Assertions.assertThat((int)detector.getActiveCount()).isEqualTo(0);
        Assertions.assertThat((int)detector.getFailedCount()).isEqualTo(0);
        Assertions.assertThat((Collection)detector.getFailed()).isEmpty();
    }

    @Test
    public void testHeartbeatStatsSerialization() throws Exception {
        ObjectMapper objectMapper = new ObjectMapperProvider().get();
        HeartbeatFailureDetector.Stats stats = new HeartbeatFailureDetector.Stats(new URI("http://example.com"));
        String serialized = objectMapper.writeValueAsString((Object)stats);
        JsonNode deserialized = objectMapper.readTree(serialized);
        Assertions.assertThat((boolean)deserialized.has("lastFailureInfo")).isFalse();
        stats.recordFailure((Exception)new SocketTimeoutException("timeout"));
        serialized = objectMapper.writeValueAsString((Object)stats);
        deserialized = objectMapper.readTree(serialized);
        Assertions.assertThat((boolean)deserialized.get("lastFailureInfo").isNull()).isFalse();
        Assertions.assertThat((String)deserialized.get("lastFailureInfo").get("type").asText()).isEqualTo(SocketTimeoutException.class.getName());
    }

    @Path(value="/foo")
    public static final class FooResource {
        @GET
        public static String hello() {
            return "hello";
        }
    }
}

