/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.airlift.slice.Slices;
import io.trino.json.ir.JsonLiteralConversionException;
import io.trino.json.ir.SqlJsonLiteralConverter;
import io.trino.json.ir.TypedValue;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.Reals;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.junit.jupiter.api.Test;

public class TestSqlJsonLiteralConverter {
    private static final RecursiveComparisonConfiguration COMPARISON_CONFIGURATION = RecursiveComparisonConfiguration.builder().withStrictTypeChecking(true).build();

    @Test
    public void testNumberToJson() {
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)TinyintType.TINYINT, 1L))).isEqualTo((Object)ShortNode.valueOf((short)1));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)SmallintType.SMALLINT, 1L))).isEqualTo((Object)ShortNode.valueOf((short)1));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)IntegerType.INTEGER, 1L))).isEqualTo((Object)IntNode.valueOf((int)1));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)BigintType.BIGINT, 1L))).isEqualTo((Object)LongNode.valueOf((long)1L));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)DoubleType.DOUBLE, 1.0))).isEqualTo((Object)DoubleNode.valueOf((double)1.0));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)DoubleType.DOUBLE, Double.NaN))).isEqualTo((Object)DoubleNode.valueOf((double)Double.NaN));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY))).isEqualTo((Object)DoubleNode.valueOf((double)Double.NEGATIVE_INFINITY));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY))).isEqualTo((Object)DoubleNode.valueOf((double)Double.POSITIVE_INFINITY));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)RealType.REAL, Reals.toReal((float)1.0f)))).isEqualTo((Object)FloatNode.valueOf((float)1.0f));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)RealType.REAL, Reals.toReal((float)Float.NaN)))).isEqualTo((Object)FloatNode.valueOf((float)Float.NaN));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)RealType.REAL, Reals.toReal((float)Float.NEGATIVE_INFINITY)))).isEqualTo((Object)FloatNode.valueOf((float)Float.NEGATIVE_INFINITY));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)RealType.REAL, Reals.toReal((float)Float.POSITIVE_INFINITY)))).isEqualTo((Object)FloatNode.valueOf((float)Float.POSITIVE_INFINITY));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)DecimalType.createDecimalType((int)2, (int)1), 1L))).isEqualTo((Object)DecimalNode.valueOf((BigDecimal)new BigDecimal(BigInteger.ONE, 1)));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)DecimalType.createDecimalType((int)30, (int)20), (Object)Int128.valueOf((BigInteger)BigInteger.ONE)))).isEqualTo((Object)DecimalNode.valueOf((BigDecimal)new BigDecimal(BigInteger.ONE, 20)));
    }

    @Test
    public void testCharacterStringToJson() {
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc")))).isEqualTo((Object)TextNode.valueOf((String)"abc"));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"abc")))).isEqualTo((Object)TextNode.valueOf((String)"abc"));
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)CharType.createCharType((int)10), (Object)Slices.utf8Slice((String)"abc")))).isEqualTo((Object)TextNode.valueOf((String)"abc       "));
    }

    @Test
    public void testBooleanToJson() {
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)BooleanType.BOOLEAN, true))).isEqualTo((Object)BooleanNode.TRUE);
        Assertions.assertThat((Iterable)TestSqlJsonLiteralConverter.json(new TypedValue((Type)BooleanType.BOOLEAN, false))).isEqualTo((Object)BooleanNode.FALSE);
    }

    @Test
    public void testNoConversionToJson() {
        Assertions.assertThat((Optional)SqlJsonLiteralConverter.getJsonNode((TypedValue)new TypedValue((Type)DateType.DATE, 1L))).isEqualTo(Optional.empty());
    }

    @Test
    public void testJsonToNumber() {
        BigInteger bigValue = BigInteger.valueOf(1000000000000000000L).multiply(BigInteger.valueOf(1000000000000000000L));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)BigIntegerNode.valueOf((BigInteger)BigInteger.ONE)))).isEqualTo((Object)new TypedValue((Type)IntegerType.INTEGER, 1L));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)BigIntegerNode.valueOf((BigInteger)BigInteger.valueOf(1000000000000000000L))))).isEqualTo((Object)new TypedValue((Type)BigintType.BIGINT, 1000000000000000000L));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlJsonLiteralConverter.getTypedValue((JsonNode)BigIntegerNode.valueOf((BigInteger)bigValue))).isInstanceOf(JsonLiteralConversionException.class)).hasMessage("cannot convert 1000000000000000000000000000000000000 to Trino value (value too big)");
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)DecimalNode.valueOf((BigDecimal)BigDecimal.ONE)))).isEqualTo((Object)new TypedValue((Type)DecimalType.createDecimalType((int)1, (int)0), 1L));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)DecimalNode.valueOf((BigDecimal)new BigDecimal(bigValue, 20))))).isEqualTo((Object)new TypedValue((Type)DecimalType.createDecimalType((int)37, (int)20), (Object)Int128.valueOf((BigInteger)bigValue)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlJsonLiteralConverter.getTypedValue((JsonNode)BigIntegerNode.valueOf((BigInteger)bigValue.multiply(bigValue)))).isInstanceOf(JsonLiteralConversionException.class)).hasMessage("cannot convert 1000000000000000000000000000000000000000000000000000000000000000000000000 to Trino value (value too big)");
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)DoubleNode.valueOf((double)1.0)))).isEqualTo((Object)new TypedValue((Type)DoubleType.DOUBLE, 1.0));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)DoubleNode.valueOf((double)Double.NEGATIVE_INFINITY)))).isEqualTo((Object)new TypedValue((Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)DoubleNode.valueOf((double)Double.POSITIVE_INFINITY)))).isEqualTo((Object)new TypedValue((Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)FloatNode.valueOf((float)1.0f)))).isEqualTo((Object)new TypedValue((Type)RealType.REAL, Reals.toReal((float)1.0f)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)FloatNode.valueOf((float)Float.NEGATIVE_INFINITY)))).isEqualTo((Object)new TypedValue((Type)RealType.REAL, Reals.toReal((float)Float.NEGATIVE_INFINITY)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)FloatNode.valueOf((float)Float.POSITIVE_INFINITY)))).isEqualTo((Object)new TypedValue((Type)RealType.REAL, Reals.toReal((float)Float.POSITIVE_INFINITY)));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)IntNode.valueOf((int)1)))).isEqualTo((Object)new TypedValue((Type)IntegerType.INTEGER, 1L));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)LongNode.valueOf((long)1L)))).isEqualTo((Object)new TypedValue((Type)BigintType.BIGINT, 1L));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)ShortNode.valueOf((short)1)))).isEqualTo((Object)new TypedValue((Type)SmallintType.SMALLINT, 1L));
    }

    @Test
    public void testJsonToCharacterString() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)TextNode.valueOf((String)"abc   ")))).isEqualTo((Object)new TypedValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc   ")));
    }

    @Test
    public void testJsonToBoolean() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)BooleanNode.TRUE))).isEqualTo((Object)new TypedValue((Type)BooleanType.BOOLEAN, true));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestSqlJsonLiteralConverter.typedValueResult((JsonNode)BooleanNode.FALSE))).isEqualTo((Object)new TypedValue((Type)BooleanType.BOOLEAN, false));
    }

    @Test
    public void testJsonToIncompatibleType() {
        Assertions.assertThat((Optional)SqlJsonLiteralConverter.getNumericTypedValue((JsonNode)TextNode.valueOf((String)"abc"))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)SqlJsonLiteralConverter.getTextTypedValue((JsonNode)NullNode.instance)).isEqualTo(Optional.empty());
    }

    @Test
    public void testNoConversionFromJson() {
        Assertions.assertThat((Optional)SqlJsonLiteralConverter.getTextTypedValue((JsonNode)BinaryNode.valueOf((byte[])new byte[0]))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)SqlJsonLiteralConverter.getTextTypedValue((JsonNode)MissingNode.getInstance())).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)SqlJsonLiteralConverter.getTextTypedValue((JsonNode)new ObjectNode(JsonNodeFactory.instance))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)SqlJsonLiteralConverter.getTextTypedValue((JsonNode)new ArrayNode(JsonNodeFactory.instance))).isEqualTo(Optional.empty());
    }

    private static JsonNode json(TypedValue value) {
        return (JsonNode)SqlJsonLiteralConverter.getJsonNode((TypedValue)value).orElseThrow();
    }

    private static AssertProvider<? extends RecursiveComparisonAssert<?>> typedValueResult(JsonNode node) {
        return () -> new RecursiveComparisonAssert(SqlJsonLiteralConverter.getTypedValue((JsonNode)node).orElseThrow(), COMPARISON_CONFIGURATION);
    }
}

