/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.SequencePageBuilder;
import io.trino.SessionTestUtils;
import io.trino.operator.HashArraySizeSupplier;
import io.trino.operator.PagesIndex;
import io.trino.operator.join.LookupSource;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.junit.jupiter.api.Test;

public class TestPagesIndex {
    @Test
    public void testEstimatedSize() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR);
        PagesIndex pagesIndex = TestPagesIndex.newPagesIndex((List<Type>)types, 30, false);
        long initialEstimatedSize = pagesIndex.getEstimatedSize().toBytes();
        ((AbstractBooleanAssert)Assertions.assertThat((initialEstimatedSize > 0L ? 1 : 0) != 0).describedAs(String.format("Initial estimated size must be positive, got %s", initialEstimatedSize), new Object[0])).isTrue();
        pagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
        long estimatedSizeWithOnePage = pagesIndex.getEstimatedSize().toBytes();
        ((AbstractBooleanAssert)Assertions.assertThat((estimatedSizeWithOnePage > initialEstimatedSize ? 1 : 0) != 0).describedAs("Estimated size should grow after adding a page", new Object[0])).isTrue();
        pagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
        long estimatedSizeWithTwoPages = pagesIndex.getEstimatedSize().toBytes();
        ((AbstractLongAssert)Assertions.assertThat((long)estimatedSizeWithTwoPages).describedAs("Estimated size should grow linearly as long as we don't pass expectedPositions", new Object[0])).isEqualTo(initialEstimatedSize + (estimatedSizeWithOnePage - initialEstimatedSize) * 2L);
        pagesIndex.compact();
        long estimatedSizeAfterCompact = pagesIndex.getEstimatedSize().toBytes();
        ((AbstractBooleanAssert)Assertions.assertThat((estimatedSizeAfterCompact < estimatedSizeWithTwoPages ? 1 : 0) != 0).describedAs(String.format("Compact should reduce (or retain) size, but changed from %s to %s", estimatedSizeWithTwoPages, estimatedSizeAfterCompact), new Object[0])).isTrue();
    }

    @Test
    public void testEagerCompact() {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR);
        PagesIndex lazyCompactPagesIndex = TestPagesIndex.newPagesIndex((List<Type>)types, 50, false);
        PagesIndex eagerCompactPagesIndex = TestPagesIndex.newPagesIndex((List<Type>)types, 50, true);
        for (int i = 0; i < 5; ++i) {
            lazyCompactPagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
            eagerCompactPagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
            ((AbstractBooleanAssert)Assertions.assertThat((eagerCompactPagesIndex.getEstimatedSize().toBytes() < lazyCompactPagesIndex.getEstimatedSize().toBytes() ? 1 : 0) != 0).describedAs("Expect eagerCompactPagesIndex retained less data than lazyCompactPagesIndex after adding the page, because the pages used in the test are compactable.", new Object[0])).isTrue();
        }
        lazyCompactPagesIndex.compact();
        Assertions.assertThat((Comparable)lazyCompactPagesIndex.getEstimatedSize()).isEqualTo((Object)eagerCompactPagesIndex.getEstimatedSize());
    }

    @Test
    public void testCompactWithNoColumns() {
        PagesIndex index = TestPagesIndex.newPagesIndex((List<Type>)ImmutableList.of(), 50, false);
        index.addPage(new Page(10));
        index.addPage(new Page(20));
        index.compact();
        Assertions.assertThat((int)index.getPositionCount()).isEqualTo(30);
    }

    @Test
    public void testGetPagesWithNoColumns() {
        PagesIndex index = TestPagesIndex.newPagesIndex((List<Type>)ImmutableList.of(), 50, false);
        index.addPage(new Page(10));
        index.addPage(new Page(20));
        Iterator pages = index.getPages();
        Assertions.assertThat((int)((Page)pages.next()).getPositionCount()).isEqualTo(10);
        Assertions.assertThat((int)((Page)pages.next()).getPositionCount()).isEqualTo(20);
        Assertions.assertThat((boolean)pages.hasNext()).isFalse();
    }

    @Test
    public void testGetEstimatedLookupSourceSizeInBytes() {
        for (Optional sortChannel : Arrays.asList(Optional.empty(), Optional.of(0), Optional.of(1))) {
            for (int joinChannel : Arrays.asList(0, 1)) {
                ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR);
                PagesIndex pagesIndex = TestPagesIndex.newPagesIndex((List<Type>)types, 50, false);
                int pageCount = 100;
                for (int i = 0; i < pageCount; ++i) {
                    pagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
                }
                long pageIndexSize = pagesIndex.getEstimatedSize().toBytes();
                long estimatedMemoryRequiredToCreateLookupSource = pagesIndex.getEstimatedMemoryRequiredToCreateLookupSource(HashArraySizeSupplier.defaultHashArraySizeSupplier(), sortChannel, (List)ImmutableList.of((Object)joinChannel));
                Assertions.assertThat((long)estimatedMemoryRequiredToCreateLookupSource).isGreaterThan(pageIndexSize);
                long estimatedLookupSourceSize = estimatedMemoryRequiredToCreateLookupSource - SizeOf.sizeOfIntArray((int)pageCount);
                long estimatedAdditionalSize = estimatedMemoryRequiredToCreateLookupSource - pageIndexSize;
                JoinFilterFunctionCompiler.JoinFilterFunctionFactory filterFunctionFactory = (session, addresses, pages) -> (leftPosition, rightPosition, rightPage) -> false;
                LookupSource lookupSource = (LookupSource)pagesIndex.createLookupSourceSupplier(SessionTestUtils.TEST_SESSION, (List)ImmutableList.of((Object)joinChannel), OptionalInt.empty(), sortChannel.map(channel -> filterFunctionFactory), sortChannel, (List)ImmutableList.of((Object)filterFunctionFactory), Optional.of(ImmutableList.of((Object)0, (Object)1)), HashArraySizeSupplier.defaultHashArraySizeSupplier()).get();
                long actualLookupSourceSize = lookupSource.getInMemorySizeInBytes();
                Assertions.assertThat((long)estimatedLookupSourceSize).isGreaterThanOrEqualTo(actualLookupSourceSize);
                Assertions.assertThat((long)estimatedLookupSourceSize).isCloseTo(actualLookupSourceSize, Percentage.withPercentage((double)1.0));
                long addressesSize = SizeOf.sizeOf((long[])pagesIndex.getValueAddresses().elements());
                long channelsArraySize = SizeOf.sizeOf((Object[])pagesIndex.getChannel(0).elements()) * (long)types.size();
                long blocksSize = 0L;
                for (int channel2 = 0; channel2 < 2; ++channel2) {
                    blocksSize += pagesIndex.getChannel(channel2).stream().mapToLong(Block::getRetainedSizeInBytes).sum();
                }
                long actualAdditionalSize = actualLookupSourceSize - (addressesSize + channelsArraySize + blocksSize);
                Assertions.assertThat((long)estimatedAdditionalSize).isCloseTo(actualAdditionalSize, Percentage.withPercentage((double)1.0));
            }
        }
    }

    private static PagesIndex newPagesIndex(List<Type> types, int expectedPositions, boolean eagerCompact) {
        return new PagesIndex.TestingFactory(eagerCompact).newPagesIndex(types, expectedPositions);
    }

    private static Page somePage(List<Type> types) {
        int[] initialValues = new int[types.size()];
        Arrays.setAll(initialValues, i -> 100 * i);
        return SequencePageBuilder.createSequencePage(types, 7, initialValues);
    }
}

