/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.NamedTypeSignature;
import io.trino.spi.type.RowFieldName;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.parser.ParsingException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTypeSignature {
    @Test
    public void parseSignatureWithLiterals() {
        TypeSignature result = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"X"), TypeSignatureParameter.numericParameter((long)42L)});
        Assertions.assertThat((List)result.getParameters()).hasSize(2);
        Assertions.assertThat((boolean)((TypeSignatureParameter)result.getParameters().get(0)).isVariable()).isEqualTo(true);
        Assertions.assertThat((boolean)((TypeSignatureParameter)result.getParameters().get(1)).isLongLiteral()).isEqualTo(true);
    }

    @Test
    public void parseRowSignature() {
        TestTypeSignature.assertRowSignature("row(a bigint,b varchar)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint")), TestTypeSignature.namedParameter("b", this.varchar())));
        TestTypeSignature.assertRowSignature("row(a bigint,b array(bigint),c row(a bigint))", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint")), TestTypeSignature.namedParameter("b", TestTypeSignature.array(this.signature("bigint"))), TestTypeSignature.namedParameter("c", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint"))))));
        TestTypeSignature.assertRowSignature("row(a varchar(10),b row(a bigint))", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.varchar(10L)), TestTypeSignature.namedParameter("b", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint"))))));
        TestTypeSignature.assertRowSignature("array(row(col0 bigint,col1 double))", TestTypeSignature.array(TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", this.signature("bigint")), TestTypeSignature.namedParameter("col1", this.signature("double")))));
        TestTypeSignature.assertRowSignature("row(col0 array(row(col0 bigint,col1 double)))", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", TestTypeSignature.array(TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", this.signature("bigint")), TestTypeSignature.namedParameter("col1", this.signature("double")))))));
        TestTypeSignature.assertRowSignature("row(a decimal(p1,s1),b decimal(p2,s2))", (Set<String>)ImmutableSet.of((Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2"), TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.decimal("p1", "s1")), TestTypeSignature.namedParameter("b", this.decimal("p2", "s2"))));
        TestTypeSignature.assertRowSignature("row(bigint,varchar)", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("bigint")), TestTypeSignature.unnamedParameter(this.varchar())));
        TestTypeSignature.assertRowSignature("row(bigint,array(bigint),row(a bigint))", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("bigint")), TestTypeSignature.unnamedParameter(TestTypeSignature.array(this.signature("bigint"))), TestTypeSignature.unnamedParameter(TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint"))))));
        TestTypeSignature.assertRowSignature("row(varchar(10),b row(bigint))", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.varchar(10L)), TestTypeSignature.namedParameter("b", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("bigint"))))));
        TestTypeSignature.assertRowSignature("array(row(col0 bigint,double))", TestTypeSignature.array(TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", this.signature("bigint")), TestTypeSignature.unnamedParameter(this.signature("double")))));
        TestTypeSignature.assertRowSignature("row(col0 array(row(bigint,double)))", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", TestTypeSignature.array(TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("bigint")), TestTypeSignature.unnamedParameter(this.signature("double")))))));
        TestTypeSignature.assertRowSignature("row(a decimal(p1,s1),decimal(p2,s2))", (Set<String>)ImmutableSet.of((Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2"), TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.decimal("p1", "s1")), TestTypeSignature.unnamedParameter(this.decimal("p2", "s2"))));
        TestTypeSignature.assertRowSignature("row(time time with time zone)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("time", this.signature("time with time zone"))));
        TestTypeSignature.assertRowSignature("row(time timestamp with time zone)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("time", this.signature("timestamp with time zone"))));
        TestTypeSignature.assertRowSignature("row(interval interval day to second)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("interval", this.signature("interval day to second"))));
        TestTypeSignature.assertRowSignature("row(interval interval year to month)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("interval", this.signature("interval year to month"))));
        TestTypeSignature.assertRowSignature("row(double double precision)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("double", this.signature("double"))));
        TestTypeSignature.assertRowSignature("row(time with time zone)", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("time with time zone"))));
        TestTypeSignature.assertRowSignature("row(timestamp with time zone)", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("timestamp with time zone"))));
        TestTypeSignature.assertRowSignature("row(interval day to second)", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("interval day to second"))));
        TestTypeSignature.assertRowSignature("row(interval year to month)", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("interval year to month"))));
        TestTypeSignature.assertRowSignature("row(double precision)", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(this.signature("double"))));
        TestTypeSignature.assertRowSignature("row(array(time with time zone))", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(TestTypeSignature.array(this.signature("time with time zone")))));
        TestTypeSignature.assertRowSignature("row(map(timestamp with time zone,interval day to second))", TestTypeSignature.rowSignature(TestTypeSignature.unnamedParameter(TestTypeSignature.map(this.signature("timestamp with time zone"), this.signature("interval day to second")))));
        TestTypeSignature.assertRowSignature("row(\"time with time zone\" time with time zone,\"double\" double)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("time with time zone", this.signature("time with time zone")), TestTypeSignature.namedParameter("double", this.signature("double"))));
        TestTypeSignature.assertSignature("row( time  time with time zone, array( interval day to second ) )", "row", (List<String>)ImmutableList.of((Object)"\"time\" time with time zone", (Object)"array(interval day to second)"), "row(\"time\" time with time zone,array(interval day to second))");
        TestTypeSignature.assertRowSignature("RoW(a bigint,b varchar)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint")), TestTypeSignature.namedParameter("b", this.varchar())));
    }

    private TypeSignature varchar() {
        return new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.numericParameter((long)Integer.MAX_VALUE)});
    }

    private TypeSignature varchar(long length) {
        return new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.numericParameter((long)length)});
    }

    private TypeSignature decimal(String precisionVariable, String scaleVariable) {
        return new TypeSignature("decimal", (List)ImmutableList.of((Object)TypeSignatureParameter.typeVariable((String)precisionVariable), (Object)TypeSignatureParameter.typeVariable((String)scaleVariable)));
    }

    private static TypeSignature rowSignature(NamedTypeSignature ... columns) {
        return new TypeSignature("row", Lists.transform(Arrays.asList(columns), TypeSignatureParameter::namedTypeParameter));
    }

    private static NamedTypeSignature namedParameter(String name, TypeSignature value) {
        return new NamedTypeSignature(Optional.of(new RowFieldName(name)), value);
    }

    private static NamedTypeSignature unnamedParameter(TypeSignature value) {
        return new NamedTypeSignature(Optional.empty(), value);
    }

    private static TypeSignature array(TypeSignature type) {
        return new TypeSignature("array", new TypeSignatureParameter[]{TypeSignatureParameter.typeParameter((TypeSignature)type)});
    }

    private static TypeSignature map(TypeSignature keyType, TypeSignature valueType) {
        return new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.typeParameter((TypeSignature)keyType), TypeSignatureParameter.typeParameter((TypeSignature)valueType)});
    }

    private TypeSignature signature(String name) {
        return new TypeSignature(name, new TypeSignatureParameter[0]);
    }

    @Test
    public void parseSignature() {
        TestTypeSignature.assertSignature("boolean", "boolean", (List<String>)ImmutableList.of());
        TestTypeSignature.assertSignature("varchar", "varchar", (List<String>)ImmutableList.of((Object)Integer.toString(Integer.MAX_VALUE)));
        TestTypeSignature.assertSignature("array(bigint)", "array", (List<String>)ImmutableList.of((Object)"bigint"));
        TestTypeSignature.assertSignature("array(array(bigint))", "array", (List<String>)ImmutableList.of((Object)"array(bigint)"));
        TestTypeSignature.assertSignature("array(timestamp with time zone)", "array", (List<String>)ImmutableList.of((Object)"timestamp with time zone"));
        TestTypeSignature.assertSignature("map(bigint,bigint)", "map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"bigint"));
        TestTypeSignature.assertSignature("map(bigint,array(bigint))", "map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"array(bigint)"));
        TestTypeSignature.assertSignature("map(bigint,map(bigint,map(varchar,bigint)))", "map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"map(bigint,map(varchar,bigint))"));
        this.assertSignatureFail("blah()");
        this.assertSignatureFail("array()");
        this.assertSignatureFail("map()");
        this.assertSignatureFail("x", (Set<String>)ImmutableSet.of((Object)"x"));
        TestTypeSignature.assertSignature("rowxxx(a)", "rowxxx", (List<String>)ImmutableList.of((Object)"a"));
    }

    @Test
    public void parseWithLiteralParameters() {
        TestTypeSignature.assertSignature("foo(42)", "foo", (List<String>)ImmutableList.of((Object)"42"));
        TestTypeSignature.assertSignature("varchar(10)", "varchar", (List<String>)ImmutableList.of((Object)"10"));
    }

    @Test
    public void testVarchar() {
        Assertions.assertThat((String)VarcharType.VARCHAR.getTypeSignature().toString()).isEqualTo("varchar");
        Assertions.assertThat((String)VarcharType.createVarcharType((int)42).getTypeSignature().toString()).isEqualTo("varchar(42)");
        Assertions.assertThat((Object)VarcharType.VARCHAR.getTypeSignature()).isEqualTo((Object)VarcharType.createUnboundedVarcharType().getTypeSignature());
        Assertions.assertThat((Object)VarcharType.createUnboundedVarcharType().getTypeSignature()).isEqualTo((Object)VarcharType.VARCHAR.getTypeSignature());
        Assertions.assertThat((int)VarcharType.VARCHAR.getTypeSignature().hashCode()).isEqualTo(VarcharType.createUnboundedVarcharType().getTypeSignature().hashCode());
        Assertions.assertThat((Object)VarcharType.createUnboundedVarcharType().getTypeSignature()).isNotEqualTo((Object)VarcharType.createVarcharType((int)10).getTypeSignature());
    }

    @Test
    public void testIsCalculated() {
        Assertions.assertThat((boolean)BigintType.BIGINT.getTypeSignature().isCalculated()).isFalse();
        Assertions.assertThat((boolean)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")}).isCalculated()).isTrue();
        Assertions.assertThat((boolean)DecimalType.createDecimalType((int)2, (int)1).getTypeSignature().isCalculated()).isFalse();
        Assertions.assertThat((boolean)TypeSignature.arrayType((TypeSignature)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")})).isCalculated()).isTrue();
        Assertions.assertThat((boolean)TypeSignature.arrayType((TypeSignature)DecimalType.createDecimalType((int)2, (int)1).getTypeSignature()).isCalculated()).isFalse();
        Assertions.assertThat((boolean)TypeSignature.mapType((TypeSignature)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p1"), TypeSignatureParameter.typeVariable((String)"s1")}), (TypeSignature)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p2"), TypeSignatureParameter.typeVariable((String)"s2")})).isCalculated()).isTrue();
        Assertions.assertThat((boolean)TypeSignature.mapType((TypeSignature)DecimalType.createDecimalType((int)2, (int)1).getTypeSignature(), (TypeSignature)DecimalType.createDecimalType((int)3, (int)1).getTypeSignature()).isCalculated()).isFalse();
        Assertions.assertThat((boolean)TypeSignature.rowType((TypeSignatureParameter[])new TypeSignatureParameter[]{TypeSignatureParameter.namedField((String)"a", (TypeSignature)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p1"), TypeSignatureParameter.typeVariable((String)"s1")})), TypeSignatureParameter.namedField((String)"b", (TypeSignature)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p2"), TypeSignatureParameter.typeVariable((String)"s2")}))}).isCalculated()).isTrue();
    }

    private static void assertRowSignature(String typeName, Set<String> literalParameters, TypeSignature expectedSignature) {
        TypeSignature signature = TypeSignatureTranslator.parseTypeSignature((String)typeName, literalParameters);
        Assertions.assertThat((Object)signature).isEqualTo((Object)expectedSignature);
    }

    private static void assertRowSignature(String typeName, TypeSignature expectedSignature) {
        TestTypeSignature.assertRowSignature(typeName, (Set<String>)ImmutableSet.of(), expectedSignature);
    }

    private static void assertSignature(String typeName, String base, List<String> parameters) {
        TestTypeSignature.assertSignature(typeName, base, parameters, typeName);
    }

    private static void assertSignature(String typeName, String base, List<String> parameters, String expectedTypeName) {
        TypeSignature signature = TypeSignatureTranslator.parseTypeSignature((String)typeName, (Set)ImmutableSet.of());
        Assertions.assertThat((String)signature.getBase()).isEqualTo(base);
        Assertions.assertThat((List)signature.getParameters()).hasSize(parameters.size());
        for (int i = 0; i < signature.getParameters().size(); ++i) {
            Assertions.assertThat((String)((TypeSignatureParameter)signature.getParameters().get(i)).toString()).isEqualTo(parameters.get(i));
        }
        Assertions.assertThat((String)signature.toString()).isEqualTo(expectedTypeName);
    }

    private void assertSignatureFail(String typeName) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeSignatureTranslator.parseTypeSignature((String)typeName, (Set)ImmutableSet.of())).isInstanceOf(ParsingException.class)).hasMessageMatching("line [1-9][0-9]*:[1-9][0-9]*: mismatched input '.*'\\. Expecting: .*");
    }

    private void assertSignatureFail(String typeName, Set<String> literalCalculationParameters) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeSignatureTranslator.parseTypeSignature((String)typeName, (Set)literalCalculationParameters)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Base type name cannot be a type variable");
    }
}

