/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestApproximatePercentileAggregation {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();
    private static final List<TypeSignatureProvider> DOUBLE_APPROXIMATE_PERCENTILE = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE});
    private static final List<TypeSignatureProvider> DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, DoubleType.DOUBLE});
    private static final List<TypeSignatureProvider> DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_WITH_ACCURACY = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, DoubleType.DOUBLE, DoubleType.DOUBLE});
    private static final List<TypeSignatureProvider> LONG_APPROXIMATE_PERCENTILE = TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE});
    private static final List<TypeSignatureProvider> LONG_APPROXIMATE_PERCENTILE_WEIGHTED = TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE});
    private static final List<TypeSignatureProvider> LONG_APPROXIMATE_PERCENTILE_WEIGHTED_WITH_ACCURACY = TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE, DoubleType.DOUBLE});
    private static final List<TypeSignatureProvider> DOUBLE_APPROXIMATE_PERCENTILE_ARRAY = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, new ArrayType((Type)DoubleType.DOUBLE)});
    private static final List<TypeSignatureProvider> DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, new ArrayType((Type)DoubleType.DOUBLE)});
    private static final List<TypeSignatureProvider> LONG_APPROXIMATE_PERCENTILE_ARRAY = TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, new ArrayType((Type)DoubleType.DOUBLE)});
    private static final List<TypeSignatureProvider> LONG_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED = TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, new ArrayType((Type)DoubleType.DOUBLE)});
    private static final List<TypeSignatureProvider> FLOAT_APPROXIMATE_PERCENTILE = TypeSignatureProvider.fromTypes((Type[])new Type[]{RealType.REAL, DoubleType.DOUBLE});
    private static final List<TypeSignatureProvider> FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED = TypeSignatureProvider.fromTypes((Type[])new Type[]{RealType.REAL, BigintType.BIGINT, DoubleType.DOUBLE});
    private static final List<TypeSignatureProvider> FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED_WITH_ACCURACY = TypeSignatureProvider.fromTypes((Type[])new Type[]{RealType.REAL, BigintType.BIGINT, DoubleType.DOUBLE, DoubleType.DOUBLE});
    private static final List<TypeSignatureProvider> FLOAT_APPROXIMATE_PERCENTILE_ARRAY = TypeSignatureProvider.fromTypes((Type[])new Type[]{RealType.REAL, new ArrayType((Type)DoubleType.DOUBLE)});
    private static final List<TypeSignatureProvider> FLOAT_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED = TypeSignatureProvider.fromTypes((Type[])new Type[]{RealType.REAL, BigintType.BIGINT, new ArrayType((Type)DoubleType.DOUBLE)});

    @Test
    public void testLongPartialStep() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE, null, new Block[]{BlockAssertions.createLongsBlock(null, null), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE, (Object)1L, new Block[]{BlockAssertions.createLongsBlock(null, 1L), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE, (Object)2L, new Block[]{BlockAssertions.createLongsBlock(null, 1L, 2L, 3L), TestApproximatePercentileAggregation.createRleBlock(0.5, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE, (Object)2L, new Block[]{BlockAssertions.createLongsBlock(1L, 2L, 3L), TestApproximatePercentileAggregation.createRleBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE, (Object)3L, new Block[]{BlockAssertions.createLongsBlock(1L, null, 2L, 2L, null, 2L, 2L, null, 2L, 2L, null, 3L, 3L, null, 3L, null, 3L, 4L, 5L, 6L, 7L), TestApproximatePercentileAggregation.createRleBlock(0.5, 21)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_ARRAY, null, new Block[]{BlockAssertions.createLongsBlock(null, null), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_ARRAY, null, new Block[]{BlockAssertions.createLongsBlock(null, null), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.99), 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)1L, (Object)1L), new Block[]{BlockAssertions.createLongsBlock(null, 1L), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), new Block[]{BlockAssertions.createLongsBlock(null, 1L, 2L, 3L), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.2, (Object)0.5, (Object)0.8), 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)2L, (Object)3L), new Block[]{BlockAssertions.createLongsBlock(1L, 2L, 3L), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.99), 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)1L, (Object)3L), new Block[]{BlockAssertions.createLongsBlock(1L, null, 2L, 2L, null, 2L, 2L, null, 2L, 2L, null, 3L, 3L, null, 3L, null, 3L, 4L, 5L, 6L, 7L), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.01, (Object)0.5), 21)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)3L, (Object)1L, (Object)2L), new Block[]{BlockAssertions.createLongsBlock(null, 1L, 2L, 3L), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.8, (Object)0.2, (Object)0.5), 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_WEIGHTED, null, new Block[]{BlockAssertions.createLongsBlock(null, null), BlockAssertions.createLongsBlock(1L, 1L), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)1L, new Block[]{BlockAssertions.createLongsBlock(null, 1L), BlockAssertions.createDoublesBlock(1.0, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)2L, new Block[]{BlockAssertions.createLongsBlock(null, 1L, 2L, 3L), BlockAssertions.createDoublesBlock(1.0, 1.0, 1.0, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)2L, new Block[]{BlockAssertions.createLongsBlock(1L, 2L, 3L), BlockAssertions.createDoublesBlock(1.0, 1.0, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)2L, new Block[]{BlockAssertions.createLongsBlock(1L, 2L, 3L), BlockAssertions.createDoublesBlock(23.4, 23.4, 23.4), TestApproximatePercentileAggregation.createRleBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)3L, new Block[]{BlockAssertions.createLongsBlock(1L, null, 2L, null, 2L, null, 2L, null, 3L, null, 3L, null, 3L, 4L, 5L, 6L, 7L), BlockAssertions.createDoublesBlock(1.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 17)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)3L, new Block[]{BlockAssertions.createLongsBlock(1L, null, 2L, null, 2L, null, 2L, null, 3L, null, 3L, null, 3L, 4L, 5L, 6L, 7L), BlockAssertions.createDoublesBlock(1.1, 1.1, 2.2, 1.1, 2.2, 1.1, 2.2, 1.1, 2.2, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1), TestApproximatePercentileAggregation.createRleBlock(0.5, 17)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_WEIGHTED_WITH_ACCURACY, (Object)9900L, new Block[]{BlockAssertions.createLongSequenceBlock(0, 10000), BlockAssertions.createDoubleRepeatBlock(1.0, 10000), TestApproximatePercentileAggregation.createRleBlock(0.99, 10000), TestApproximatePercentileAggregation.createRleBlock(0.001, 10000)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", LONG_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED, (Object)ImmutableList.of((Object)2L, (Object)3L), new Block[]{BlockAssertions.createLongsBlock(1L, 2L, 3L), BlockAssertions.createDoublesBlock(4.0, 2.0, 1.0), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.8), 3)});
    }

    @Test
    public void testFloatPartialStep() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE, null, new Block[]{BlockAssertions.createBlockOfReals(null, null), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE, (Object)Float.valueOf(1.0f), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f)), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE, (Object)Float.valueOf(2.0f), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), TestApproximatePercentileAggregation.createRleBlock(0.5, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE, (Object)Float.valueOf(1.0f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(-1.0f), Float.valueOf(1.0f)), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE, (Object)Float.valueOf(-1.0f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(-2.0f), Float.valueOf(3.0f), Float.valueOf(-1.0f)), TestApproximatePercentileAggregation.createRleBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE, (Object)Float.valueOf(2.0f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), TestApproximatePercentileAggregation.createRleBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE, (Object)Float.valueOf(3.0f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), null, Float.valueOf(2.0f), Float.valueOf(2.0f), null, Float.valueOf(2.0f), Float.valueOf(2.0f), null, Float.valueOf(2.0f), Float.valueOf(2.0f), null, Float.valueOf(3.0f), Float.valueOf(3.0f), null, Float.valueOf(3.0f), null, Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f)), TestApproximatePercentileAggregation.createRleBlock(0.5, 21)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_ARRAY, null, new Block[]{BlockAssertions.createBlockOfReals(null, null), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_ARRAY, null, new Block[]{BlockAssertions.createBlockOfReals(null, null), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f)), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f)), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(3.0f)), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.2, (Object)0.5, (Object)0.8), 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)Float.valueOf(2.0f), (Object)Float.valueOf(3.0f)), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.99), 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(3.0f)), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), null, Float.valueOf(2.0f), Float.valueOf(2.0f), null, Float.valueOf(2.0f), Float.valueOf(2.0f), null, Float.valueOf(2.0f), Float.valueOf(2.0f), null, Float.valueOf(3.0f), Float.valueOf(3.0f), null, Float.valueOf(3.0f), null, Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f)), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.01, (Object)0.5), 21)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)Float.valueOf(3.0f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f)), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.8, (Object)0.2, (Object)0.5), 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED, null, new Block[]{BlockAssertions.createBlockOfReals(null, null), BlockAssertions.createLongsBlock(1L, 1L), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)Float.valueOf(1.0f), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f)), BlockAssertions.createDoublesBlock(1.0, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)Float.valueOf(2.0f), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), BlockAssertions.createDoublesBlock(1.0, 1.0, 1.0, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)Float.valueOf(2.0f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), BlockAssertions.createDoublesBlock(1.0, 1.0, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)Float.valueOf(2.75f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), null, Float.valueOf(2.0f), null, Float.valueOf(2.0f), null, Float.valueOf(2.0f), null, Float.valueOf(3.0f), null, Float.valueOf(3.0f), null, Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f)), BlockAssertions.createDoublesBlock(1.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 17)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)Float.valueOf(2.75f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), null, Float.valueOf(2.0f), null, Float.valueOf(2.0f), null, Float.valueOf(2.0f), null, Float.valueOf(3.0f), null, Float.valueOf(3.0f), null, Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f)), BlockAssertions.createDoublesBlock(1.1, 1.1, 2.2, 1.1, 2.2, 1.1, 2.2, 1.1, 2.2, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1), TestApproximatePercentileAggregation.createRleBlock(0.5, 17)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED_WITH_ACCURACY, (Object)Float.valueOf(9900.0f), new Block[]{BlockAssertions.createSequenceBlockOfReal(0, 10000), BlockAssertions.createDoubleRepeatBlock(1.0, 10000), TestApproximatePercentileAggregation.createRleBlock(0.99, 10000), TestApproximatePercentileAggregation.createRleBlock(0.001, 10000)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED, (Object)ImmutableList.of((Object)Float.valueOf(1.5f), (Object)Float.valueOf(2.6f)), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), BlockAssertions.createDoublesBlock(4.0, 2.0, 1.0), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.8), 3)});
        for (Float invalidValue : List.of(Float.valueOf(Float.NaN), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY))) {
            ((TrinoExceptionAssert)AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE, new Block[]{BlockAssertions.createBlockOfReals(invalidValue), TestApproximatePercentileAggregation.createRleBlock(0.5, 1)}).isInstanceOf(TrinoException.class)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
            ((TrinoExceptionAssert)AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_ARRAY, new Block[]{BlockAssertions.createBlockOfReals(invalidValue), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.75), 1)}).isInstanceOf(TrinoException.class)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
            ((TrinoExceptionAssert)AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED, new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f)), BlockAssertions.createDoublesBlock(new Double[]{invalidValue.floatValue()}), BlockAssertions.createDoublesBlock(0.5)}).isInstanceOf(TrinoException.class)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
            ((TrinoExceptionAssert)AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED, new Block[]{BlockAssertions.createBlockOfReals(invalidValue), BlockAssertions.createDoublesBlock(1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 1)}).isInstanceOf(TrinoException.class)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
            ((TrinoExceptionAssert)AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED, new Block[]{BlockAssertions.createBlockOfReals(invalidValue), BlockAssertions.createDoublesBlock(1.0), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.75), 1)}).isInstanceOf(TrinoException.class)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
            ((TrinoExceptionAssert)AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED, new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f)), BlockAssertions.createDoublesBlock(new Double[]{invalidValue.floatValue()}), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.75), 1)}).isInstanceOf(TrinoException.class)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
            AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED_WITH_ACCURACY, new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f)), BlockAssertions.createDoublesBlock(1.0), BlockAssertions.createDoublesBlock(0.99), BlockAssertions.createDoublesBlock(new Double[]{invalidValue.floatValue()})}).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        }
    }

    @Test
    public void testDoublePartialStep() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE, (Object)1.0, new Block[]{BlockAssertions.createDoublesBlock(null, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE, (Object)2.0, new Block[]{BlockAssertions.createDoublesBlock(null, 1.0, 2.0, 3.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE, (Object)2.0, new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE, (Object)3.0, new Block[]{BlockAssertions.createDoublesBlock(1.0, null, 2.0, 2.0, null, 2.0, 2.0, null, 2.0, 2.0, null, 3.0, 3.0, null, 3.0, null, 3.0, 4.0, 5.0, 6.0, 7.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 21)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_ARRAY, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_ARRAY, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)1.0, (Object)1.0), new Block[]{BlockAssertions.createDoublesBlock(null, 1.0), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0), new Block[]{BlockAssertions.createDoublesBlock(null, 1.0, 2.0, 3.0), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.2, (Object)0.5, (Object)0.8), 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)2.0, (Object)3.0), new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.99), 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)1.0, (Object)3.0), new Block[]{BlockAssertions.createDoublesBlock(1.0, null, 2.0, 2.0, null, 2.0, 2.0, null, 2.0, 2.0, null, 3.0, 3.0, null, 3.0, null, 3.0, 4.0, 5.0, 6.0, 7.0), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.01, (Object)0.5), 21)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_ARRAY, (Object)ImmutableList.of((Object)3.0, (Object)1.0, (Object)2.0), new Block[]{BlockAssertions.createDoublesBlock(null, 1.0, 2.0, 3.0), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.8, (Object)0.2, (Object)0.5), 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createLongsBlock(1L, 1L), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)1.0, new Block[]{BlockAssertions.createDoublesBlock(null, 1.0), BlockAssertions.createDoublesBlock(1.0, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)2.0, new Block[]{BlockAssertions.createDoublesBlock(null, 1.0, 2.0, 3.0), BlockAssertions.createDoublesBlock(1.0, 1.0, 1.0, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)2.0, new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createDoublesBlock(1.0, 1.0, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)2.75, new Block[]{BlockAssertions.createDoublesBlock(1.0, null, 2.0, null, 2.0, null, 2.0, null, 3.0, null, 3.0, null, 3.0, 4.0, 5.0, 6.0, 7.0), BlockAssertions.createDoublesBlock(1.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 17)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED, (Object)2.75, new Block[]{BlockAssertions.createDoublesBlock(1.0, null, 2.0, null, 2.0, null, 2.0, null, 3.0, null, 3.0, null, 3.0, 4.0, 5.0, 6.0, 7.0), BlockAssertions.createDoublesBlock(1.1, 1.1, 2.2, 1.1, 2.2, 1.1, 2.2, 1.1, 2.2, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1), TestApproximatePercentileAggregation.createRleBlock(0.5, 17)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_WITH_ACCURACY, (Object)9900.0, new Block[]{BlockAssertions.createDoubleSequenceBlock(0, 10000), BlockAssertions.createDoubleRepeatBlock(1.0, 10000), TestApproximatePercentileAggregation.createRleBlock(0.99, 10000), TestApproximatePercentileAggregation.createRleBlock(0.001, 10000)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED, (Object)ImmutableList.of((Object)1.5, (Object)2.6000000000000005), new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 2.0, 1.0), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.8), 3)});
        for (Double invalidValue : List.of(Double.valueOf(Double.NaN), Double.valueOf(Double.NEGATIVE_INFINITY), Double.valueOf(Double.POSITIVE_INFINITY))) {
            ((TrinoExceptionAssert)AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE, new Block[]{BlockAssertions.createDoublesBlock(invalidValue), BlockAssertions.createDoublesBlock(0.5)}).isInstanceOf(TrinoException.class)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
            ((TrinoExceptionAssert)AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_ARRAY, new Block[]{BlockAssertions.createDoublesBlock(invalidValue), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.75), 1)}).isInstanceOf(TrinoException.class)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
            ((TrinoExceptionAssert)AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED, new Block[]{BlockAssertions.createDoublesBlock(invalidValue), BlockAssertions.createDoublesBlock(1.0), TestApproximatePercentileAggregation.createRleBlock(0.5, 1)}).isInstanceOf(TrinoException.class)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
            ((TrinoExceptionAssert)AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED, new Block[]{BlockAssertions.createDoublesBlock(1.0), BlockAssertions.createDoublesBlock(invalidValue), TestApproximatePercentileAggregation.createRleBlock(0.5, 1)}).isInstanceOf(TrinoException.class)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
            ((TrinoExceptionAssert)AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED, new Block[]{BlockAssertions.createDoublesBlock(1.0), BlockAssertions.createDoublesBlock(invalidValue), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.75), 1)}).isInstanceOf(TrinoException.class)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
            ((TrinoExceptionAssert)AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED, new Block[]{BlockAssertions.createDoublesBlock(invalidValue), BlockAssertions.createDoublesBlock(1.0), TestApproximatePercentileAggregation.createRleBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.75), 1)}).isInstanceOf(TrinoException.class)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
            AggregationTestUtils.assertAggregationFails(FUNCTION_RESOLUTION, "approx_percentile", DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_WITH_ACCURACY, new Block[]{BlockAssertions.createDoublesBlock(1.0), BlockAssertions.createDoublesBlock(1.0), BlockAssertions.createDoublesBlock(0.99), BlockAssertions.createDoublesBlock(invalidValue)}).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        }
    }

    private static Block createRleBlock(double percentile, int positionCount) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createFixedSizeBlockBuilder(1);
        DoubleType.DOUBLE.writeDouble(blockBuilder, percentile);
        return RunLengthEncodedBlock.create((Block)blockBuilder.build(), (int)positionCount);
    }

    private static Block createRleBlock(Iterable<Double> percentiles, int positionCount) {
        ArrayBlockBuilder arrayBuilder = new ArrayType((Type)DoubleType.DOUBLE).createBlockBuilder(null, 1);
        arrayBuilder.buildEntry(elementBuilder -> {
            Iterator iterator = percentiles.iterator();
            while (iterator.hasNext()) {
                double percentile = (Double)iterator.next();
                DoubleType.DOUBLE.writeDouble(elementBuilder, percentile);
            }
        });
        return RunLengthEncodedBlock.create((Block)arrayBuilder.build(), (int)positionCount);
    }
}

