/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.minmaxn.TypedHeap;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Test;

public class TestTypedHeap {
    private static final int INPUT_SIZE = 1000000;
    private static final int OUTPUT_SIZE = 1000;
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();

    @Test
    public void testAscending() {
        TestTypedHeap.test(IntStream.range(0, 1000000).boxed().toList());
    }

    @Test
    public void testDescending() {
        TestTypedHeap.test(IntStream.range(0, 1000000).map(x -> 999999 - x).boxed().toList());
    }

    @Test
    public void testShuffled() {
        List<Integer> list = IntStream.range(0, 1000000).boxed().collect(Collectors.toList());
        Collections.shuffle(list);
        TestTypedHeap.test(list);
    }

    private static void test(List<Integer> testData) {
        TestTypedHeap.test((Type)BigintType.BIGINT, testData.stream().map(Long::valueOf).toList(), Comparator.naturalOrder());
        List<Slice> sliceData = testData.stream().map(String::valueOf).map(value -> value + " ".repeat(22) + "x").map(Slices::utf8Slice).toList();
        TestTypedHeap.test((Type)VarcharType.VARCHAR, sliceData, Comparator.naturalOrder());
    }

    @Test
    public void testEmptyVariableWidth() {
        TestTypedHeap.test((Type)VarbinaryType.VARBINARY, Collections.nCopies(1000000, Slices.EMPTY_SLICE), Comparator.naturalOrder());
    }

    private static <T> void test(Type type, List<T> testData, Comparator<T> comparator) {
        TestTypedHeap.test(type, true, testData, comparator);
        TestTypedHeap.test(type, false, testData, comparator);
    }

    private static <T> void test(Type type, boolean min, List<T> testData, Comparator<T> comparator) {
        MethodHandle comparisonFlatBlock;
        MethodHandle comparisonFlatFlat;
        MethodHandle readFlat = TYPE_OPERATORS.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT}));
        MethodHandle writeFlat = TYPE_OPERATORS.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}));
        if (min) {
            comparisonFlatFlat = TYPE_OPERATORS.getComparisonUnorderedLastOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.FLAT}));
            comparisonFlatBlock = TYPE_OPERATORS.getComparisonUnorderedLastOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}));
        } else {
            comparisonFlatFlat = TYPE_OPERATORS.getComparisonUnorderedFirstOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.FLAT}));
            comparisonFlatBlock = TYPE_OPERATORS.getComparisonUnorderedFirstOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}));
            comparator = comparator.reversed();
        }
        ValueBlock expected = TestTypedHeap.toBlock(type, testData.stream().sorted(comparator).limit(1000L).toList());
        ValueBlock inputData = TestTypedHeap.toBlock(type, testData);
        TypedHeap heap = new TypedHeap(min, readFlat, writeFlat, comparisonFlatFlat, comparisonFlatBlock, type, 1000);
        TestTypedHeap.addAll(heap, inputData);
        TestTypedHeap.assertEqual(heap, type, expected);
        TestTypedHeap.assertEqual(new TypedHeap(heap), type, expected);
        TypedHeap part1 = new TypedHeap(min, readFlat, writeFlat, comparisonFlatFlat, comparisonFlatBlock, type, 1000);
        TestTypedHeap.addAll(part1, inputData.getRegion(0, inputData.getPositionCount() / 2));
        BlockBuilder part1BlockBuilder = type.createBlockBuilder(null, part1.getCapacity());
        part1.writeAllUnsorted(part1BlockBuilder);
        ValueBlock part1Block = part1BlockBuilder.buildValueBlock();
        TypedHeap part2 = new TypedHeap(min, readFlat, writeFlat, comparisonFlatFlat, comparisonFlatBlock, type, 1000);
        TestTypedHeap.addAll(part2, inputData.getRegion(inputData.getPositionCount() / 2, inputData.getPositionCount() - inputData.getPositionCount() / 2));
        BlockBuilder part2BlockBuilder = type.createBlockBuilder(null, part2.getCapacity());
        part2.writeAllUnsorted(part2BlockBuilder);
        ValueBlock part2Block = part2BlockBuilder.buildValueBlock();
        TypedHeap merged = new TypedHeap(min, readFlat, writeFlat, comparisonFlatFlat, comparisonFlatBlock, type, 1000);
        TestTypedHeap.addAll(merged, part1Block);
        TestTypedHeap.addAll(merged, part2Block);
        TestTypedHeap.assertEqual(merged, type, expected);
    }

    private static void addAll(TypedHeap heap, ValueBlock inputData) {
        for (int i = 0; i < inputData.getPositionCount(); ++i) {
            heap.add(inputData, i);
        }
    }

    private static void assertEqual(TypedHeap heap, Type type, ValueBlock expected) {
        BlockBuilder resultBlockBuilder = type.createBlockBuilder(null, 1000);
        heap.writeAllSorted(resultBlockBuilder);
        ValueBlock actual = resultBlockBuilder.buildValueBlock();
        BlockAssertions.assertBlockEquals(type, (Block)actual, (Block)expected);
    }

    private static <T> ValueBlock toBlock(Type type, List<T> inputStream) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1000000);
        inputStream.forEach(value -> TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)value));
        return blockBuilder.buildValueBlock();
    }
}

