/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.Threads;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.operator.TaskContext;
import io.trino.operator.ValuesOperator;
import io.trino.operator.join.JoinBridge;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.NestedLoopBuildOperator;
import io.trino.operator.join.NestedLoopJoinOperator;
import io.trino.operator.join.NestedLoopJoinPagesSupplier;
import io.trino.spi.Page;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestNestedLoopJoinOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeAll
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    }

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testNestedLoopJoin() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(3, 20, 30, 40);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        List<Page> probeInput = probePages.addSequencePage(2, 0, 1000, 2000).build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages, (List<Integer>)ImmutableList.of((Object)0, (Object)1, (Object)2), (List<Integer>)ImmutableList.of((Object)0, (Object)1, (Object)2));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat(probePages.getTypes(), buildPages.getTypes())).row(new Object[]{"0", 1000L, 2000L, "20", 30L, 40L}).row(new Object[]{"0", 1000L, 2000L, "21", 31L, 41L}).row(new Object[]{"0", 1000L, 2000L, "22", 32L, 42L}).row(new Object[]{"1", 1001L, 2001L, "20", 30L, 40L}).row(new Object[]{"1", 1001L, 2001L, "21", 31L, 41L}).row(new Object[]{"1", 1001L, 2001L, "22", 32L, 42L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
        buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(2, 20, 30, 40);
        joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages, (List<Integer>)ImmutableList.of((Object)0, (Object)1, (Object)2), (List<Integer>)ImmutableList.of((Object)0, (Object)1, (Object)2));
        probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        probeInput = probePages.addSequencePage(3, 0, 1000, 2000).build();
        expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat(probePages.getTypes(), buildPages.getTypes())).row(new Object[]{"0", 1000L, 2000L, "20", 30L, 40L}).row(new Object[]{"1", 1001L, 2001L, "20", 30L, 40L}).row(new Object[]{"2", 1002L, 2002L, "20", 30L, 40L}).row(new Object[]{"0", 1000L, 2000L, "21", 31L, 41L}).row(new Object[]{"1", 1001L, 2001L, "21", 31L, 41L}).row(new Object[]{"2", 1002L, 2002L, "21", 31L, 41L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testColumnReordering() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(3, 20, 30, 40);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        List<Page> probeInput = probePages.addSequencePage(2, 0, 1000, 2000).build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages, (List<Integer>)ImmutableList.of((Object)2, (Object)0, (Object)1), (List<Integer>)ImmutableList.of((Object)1, (Object)2, (Object)0));
        ImmutableList expectedProbeTypes = ImmutableList.of((Object)probePages.getTypes().get(2), (Object)probePages.getTypes().get(0), (Object)probePages.getTypes().get(1));
        ImmutableList expectedBuildTypes = ImmutableList.of((Object)probePages.getTypes().get(1), (Object)probePages.getTypes().get(2), (Object)probePages.getTypes().get(0));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)expectedProbeTypes, (Iterable)expectedBuildTypes)).row(new Object[]{2000L, "0", 1000L, 30L, 40L, "20"}).row(new Object[]{2000L, "0", 1000L, 31L, 41L, "21"}).row(new Object[]{2000L, "0", 1000L, 32L, 42L, "22"}).row(new Object[]{2001L, "1", 1001L, 30L, 40L, "20"}).row(new Object[]{2001L, "1", 1001L, 31L, 41L, "21"}).row(new Object[]{2001L, "1", 1001L, 32L, 42L, "22"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testCrossJoinWithNullProbe() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("a").row("b");
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("A").row(new Object[]{null}).row(new Object[]{null}).row("A").row("B").build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages, (List<Integer>)ImmutableList.of((Object)0), (List<Integer>)ImmutableList.of((Object)0));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).row(new Object[]{"A", "a"}).row(new Object[]{null, "a"}).row(new Object[]{null, "a"}).row(new Object[]{"A", "a"}).row(new Object[]{"B", "a"}).row(new Object[]{"A", "b"}).row(new Object[]{null, "b"}).row(new Object[]{null, "b"}).row(new Object[]{"A", "b"}).row(new Object[]{"B", "b"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testCrossJoinWithNullBuild() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("A").row("B").build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages, (List<Integer>)ImmutableList.of((Object)0), (List<Integer>)ImmutableList.of((Object)0));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).row(new Object[]{"A", "a"}).row(new Object[]{"A", null}).row(new Object[]{"A", null}).row(new Object[]{"A", "a"}).row(new Object[]{"A", "b"}).row(new Object[]{"B", "a"}).row(new Object[]{"B", null}).row(new Object[]{"B", null}).row(new Object[]{"B", "a"}).row(new Object[]{"B", "b"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testCrossJoinWithNullOnBothSides() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("a").row(new Object[]{null}).row("b").row("c").row(new Object[]{null});
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("A").row("B").row(new Object[]{null}).row("C").build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages, (List<Integer>)ImmutableList.of((Object)0), (List<Integer>)ImmutableList.of((Object)0));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).row(new Object[]{"A", "a"}).row(new Object[]{"A", null}).row(new Object[]{"A", "b"}).row(new Object[]{"A", "c"}).row(new Object[]{"A", null}).row(new Object[]{"B", "a"}).row(new Object[]{"B", null}).row(new Object[]{"B", "b"}).row(new Object[]{"B", "c"}).row(new Object[]{"B", null}).row(new Object[]{null, "a"}).row(new Object[]{null, null}).row(new Object[]{null, "b"}).row(new Object[]{null, "c"}).row(new Object[]{null, null}).row(new Object[]{"C", "a"}).row(new Object[]{"C", null}).row(new Object[]{"C", "b"}).row(new Object[]{"C", "c"}).row(new Object[]{"C", null}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testBuildMultiplePages() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("a").pageBreak().row(new Object[]{null}).row("b").row("c").pageBreak().row("d");
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("A").row("B").build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages, (List<Integer>)ImmutableList.of((Object)0), (List<Integer>)ImmutableList.of((Object)0));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).row(new Object[]{"A", "a"}).row(new Object[]{"B", "a"}).row(new Object[]{"A", null}).row(new Object[]{"A", "b"}).row(new Object[]{"A", "c"}).row(new Object[]{"B", null}).row(new Object[]{"B", "b"}).row(new Object[]{"B", "c"}).row(new Object[]{"A", "d"}).row(new Object[]{"B", "d"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testProbeMultiplePages() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("A").row("B");
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").pageBreak().row(new Object[]{null}).row("b").row("c").pageBreak().row("d").build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages, (List<Integer>)ImmutableList.of((Object)0), (List<Integer>)ImmutableList.of((Object)0));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).row(new Object[]{"a", "A"}).row(new Object[]{"a", "B"}).row(new Object[]{null, "A"}).row(new Object[]{"b", "A"}).row(new Object[]{"c", "A"}).row(new Object[]{null, "B"}).row(new Object[]{"b", "B"}).row(new Object[]{"c", "B"}).row(new Object[]{"d", "A"}).row(new Object[]{"d", "B"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testProbeAndBuildMultiplePages() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("A").row("B").pageBreak().row("C");
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").pageBreak().row(new Object[]{null}).row("b").row("c").pageBreak().row("d").build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages, (List<Integer>)ImmutableList.of((Object)0), (List<Integer>)ImmutableList.of((Object)0));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).row(new Object[]{"a", "A"}).row(new Object[]{"a", "B"}).row(new Object[]{"a", "C"}).row(new Object[]{null, "A"}).row(new Object[]{"b", "A"}).row(new Object[]{"c", "A"}).row(new Object[]{null, "B"}).row(new Object[]{"b", "B"}).row(new Object[]{"c", "B"}).row(new Object[]{null, "C"}).row(new Object[]{"b", "C"}).row(new Object[]{"c", "C"}).row(new Object[]{"d", "A"}).row(new Object[]{"d", "B"}).row(new Object[]{"d", "C"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testEmptyProbePage() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("A").row("B").pageBreak().row("C");
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.pageBreak().build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages, (List<Integer>)ImmutableList.of((Object)0), (List<Integer>)ImmutableList.of((Object)0));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testEmptyBuildPage() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).pageBreak();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("A").row("B").pageBreak().build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages, (List<Integer>)ImmutableList.of((Object)0), (List<Integer>)ImmutableList.of((Object)0));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testCount() {
        Page buildPage = new Page(100);
        Page probePage = new Page(45);
        NestedLoopJoinOperator.NestedLoopOutputIterator resultPageBuilder = NestedLoopJoinOperator.createNestedLoopOutputIterator((Page)probePage, (Page)buildPage, (int[])new int[0], (int[])new int[0]);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)resultPageBuilder.hasNext()).describedAs("There should be at least one page.", new Object[0])).isTrue();
        long result = 0L;
        while (resultPageBuilder.hasNext()) {
            result += (long)resultPageBuilder.next().getPositionCount();
        }
        Assertions.assertThat((long)result).isEqualTo(4500L);
        buildPage = new Page(0x7FFFFFF5);
        resultPageBuilder = NestedLoopJoinOperator.createNestedLoopOutputIterator((Page)probePage, (Page)buildPage, (int[])new int[0], (int[])new int[0]);
        result = 0L;
        while (resultPageBuilder.hasNext()) {
            result += (long)resultPageBuilder.next().getPositionCount();
        }
        Assertions.assertThat((long)96636763665L).isEqualTo(result);
    }

    private TaskContext createTaskContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
    }

    private static NestedLoopJoinOperator.NestedLoopJoinOperatorFactory newJoinOperatorFactoryWithCompletedBuild(TaskContext taskContext, RowPagesBuilder buildPages, List<Integer> probeChannels, List<Integer> buildChannels) {
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        ValuesOperator.ValuesOperatorFactory valuesOperatorFactory = new ValuesOperator.ValuesOperatorFactory(0, new PlanNodeId("test"), buildPages.build());
        JoinBridgeManager nestedLoopJoinBridgeManager = new JoinBridgeManager(false, (JoinBridge)new NestedLoopJoinPagesSupplier(), buildPages.getTypes());
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(1, new PlanNodeId("test"), nestedLoopJoinBridgeManager);
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = new NestedLoopJoinOperator.NestedLoopJoinOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinBridgeManager, probeChannels, buildChannels);
        Operator valuesOperator = valuesOperatorFactory.createOperator(driverContext);
        Operator nestedLoopBuildOperator = nestedLoopBuildOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)valuesOperator, (Operator[])new Operator[]{nestedLoopBuildOperator});
        valuesOperatorFactory.noMoreOperators();
        nestedLoopBuildOperatorFactory.noMoreOperators();
        while (nestedLoopBuildOperator.isBlocked().isDone()) {
            driver.processUntilBlocked();
        }
        return joinOperatorFactory;
    }
}

