/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.jmh.Benchmarks;
import io.trino.operator.scalar.MathFunctions;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=30, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=30, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkRoundFunction {
    private double operand0;
    private double operand1;
    private double operand2;
    private double operand3;
    private double operand4;
    private float floatOperand0;
    private float floatOperand1;
    private float floatOperand2;
    private float floatOperand3;
    private float floatOperand4;
    @Param(value={"0", "1", "2", "3", "4"})
    private int numberOfDecimals;

    @Setup
    public void setup() {
        this.operand0 = 0.5;
        this.operand1 = 754.1985;
        this.operand2 = -754.2008;
        this.operand3 = 0.49999999999999994;
        this.operand4 = -0.49999999999999994;
        this.floatOperand0 = 0.5f;
        this.floatOperand1 = 754.1985f;
        this.floatOperand2 = -754.2008f;
        this.floatOperand3 = 0.49999997f;
        this.floatOperand4 = -0.49999997f;
    }

    @Benchmark
    public void doubleActual(Blackhole bh) {
        bh.consume(MathFunctions.round((double)this.operand0, (long)this.numberOfDecimals));
        bh.consume(MathFunctions.round((double)this.operand1, (long)this.numberOfDecimals));
        bh.consume(MathFunctions.round((double)this.operand2, (long)this.numberOfDecimals));
        bh.consume(MathFunctions.round((double)this.operand3, (long)this.numberOfDecimals));
        bh.consume(MathFunctions.round((double)this.operand4, (long)this.numberOfDecimals));
    }

    @Benchmark
    public void doubleBaseline(Blackhole bh) {
        bh.consume(BenchmarkRoundFunction.roundBaseline(this.operand0, this.numberOfDecimals));
        bh.consume(BenchmarkRoundFunction.roundBaseline(this.operand1, this.numberOfDecimals));
        bh.consume(BenchmarkRoundFunction.roundBaseline(this.operand2, this.numberOfDecimals));
        bh.consume(BenchmarkRoundFunction.roundBaseline(this.operand3, this.numberOfDecimals));
        bh.consume(BenchmarkRoundFunction.roundBaseline(this.operand4, this.numberOfDecimals));
    }

    @Benchmark
    public void floatActual(Blackhole bh) {
        bh.consume(MathFunctions.round((double)this.floatOperand0, (long)this.numberOfDecimals));
        bh.consume(MathFunctions.round((double)this.floatOperand1, (long)this.numberOfDecimals));
        bh.consume(MathFunctions.round((double)this.floatOperand2, (long)this.numberOfDecimals));
        bh.consume(MathFunctions.round((double)this.floatOperand3, (long)this.numberOfDecimals));
        bh.consume(MathFunctions.round((double)this.floatOperand4, (long)this.numberOfDecimals));
    }

    @Benchmark
    public void floatBaseline(Blackhole bh) {
        bh.consume(BenchmarkRoundFunction.roundBaseline(this.floatOperand0, this.numberOfDecimals));
        bh.consume(BenchmarkRoundFunction.roundBaseline(this.floatOperand1, this.numberOfDecimals));
        bh.consume(BenchmarkRoundFunction.roundBaseline(this.floatOperand2, this.numberOfDecimals));
        bh.consume(BenchmarkRoundFunction.roundBaseline(this.floatOperand3, this.numberOfDecimals));
        bh.consume(BenchmarkRoundFunction.roundBaseline(this.floatOperand4, this.numberOfDecimals));
    }

    @Description(value="Round to given number of decimal places")
    @ScalarFunction
    @SqlType(value="double")
    public static double roundBaseline(@SqlType(value="double") double num, @SqlType(value="bigint") long decimals) {
        if (num == 0.0) {
            return 0.0;
        }
        if (num < 0.0) {
            return -BenchmarkRoundFunction.roundBaseline(-num, decimals);
        }
        double factor = Math.pow(10.0, decimals);
        return Math.floor(num * factor + 0.5) / factor;
    }

    public static void main(String[] args) throws Exception {
        Benchmarks.benchmark(BenchmarkRoundFunction.class).run();
    }
}

