/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.interval;

import io.trino.sql.query.QueryAssertions;
import io.trino.type.SqlIntervalYearMonth;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestIntervalYearMonth {
    protected QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLiterals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '124-30' YEAR TO MONTH")))).isEqualTo(TestIntervalYearMonth.interval(124, 30));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '124' YEAR TO MONTH")))).isEqualTo(TestIntervalYearMonth.interval(124, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '30' MONTH")))).isEqualTo(TestIntervalYearMonth.interval(0, 30));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '32767' YEAR")))).isEqualTo(TestIntervalYearMonth.interval(Short.MAX_VALUE, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '32767' MONTH")))).isEqualTo(TestIntervalYearMonth.interval(0, Short.MAX_VALUE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '32767-32767' YEAR TO MONTH")))).isEqualTo(TestIntervalYearMonth.interval(Short.MAX_VALUE, Short.MAX_VALUE));
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124X' YEAR")::evaluate).hasMessage("line 1:12: Invalid INTERVAL YEAR value: 124X");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124-30' YEAR")::evaluate).hasMessage("line 1:12: Invalid INTERVAL YEAR value: 124-30");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124-X' YEAR TO MONTH")::evaluate).hasMessage("line 1:12: Invalid INTERVAL YEAR TO MONTH value: 124-X");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124--30' YEAR TO MONTH")::evaluate).hasMessage("line 1:12: Invalid INTERVAL YEAR TO MONTH value: 124--30");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '--124--30' YEAR TO MONTH")::evaluate).hasMessage("line 1:12: Invalid INTERVAL YEAR TO MONTH value: --124--30");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '32767' YEAR TO YEAR")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: YEAR TO YEAR");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124-30' YEAR TO DAY")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: YEAR TO DAY");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124-30' YEAR TO HOUR")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: YEAR TO HOUR");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124-30' YEAR TO MINUTE")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: YEAR TO MINUTE");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124-30' YEAR TO SECOND")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: YEAR TO SECOND");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '30' MONTH TO MONTH")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: MONTH TO MONTH");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124-30' MONTH TO YEAR")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: MONTH TO YEAR");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124-30' MONTH TO DAY")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: MONTH TO DAY");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124-30' MONTH TO HOUR")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: MONTH TO HOUR");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124-30' MONTH TO MINUTE")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: MONTH TO MINUTE");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '124-30' MONTH TO SECOND")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: MONTH TO SECOND");
    }

    private static SqlIntervalYearMonth interval(int year, int month) {
        return new SqlIntervalYearMonth(year, month);
    }
}

