/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;

public final class WindowAssertions {
    private static final String VALUES = "SELECT *\nFROM (\n  VALUES\n    ( 1, 'O', '1996-01-02'),\n    ( 2, 'O', '1996-12-01'),\n    ( 3, 'F', '1993-10-14'),\n    ( 4, 'O', '1995-10-11'),\n    ( 5, 'F', '1994-07-30'),\n    ( 6, 'F', '1992-02-21'),\n    ( 7, 'O', '1996-01-10'),\n    (32, 'O', '1995-07-16'),\n    (33, 'F', '1993-10-27'),\n    (34, 'O', '1998-07-21')\n) AS orders (orderkey, orderstatus, orderdate)\n";
    private static final String VALUES_WITH_NULLS = "SELECT *\nFROM (\n  VALUES\n    ( 1,                   CAST(NULL AS VARCHAR), CAST(NULL AS VARCHAR)),\n    ( 3,                   'F',                   '1993-10-14'),\n    ( 5,                   'F',                   CAST(NULL AS VARCHAR)),\n    ( 7,                   CAST(NULL AS VARCHAR), '1996-01-10'),\n    (34,                   'O',                   '1998-07-21'),\n    ( 6,                   'F',                   '1992-02-21'),\n    (CAST(NULL AS BIGINT), 'F',                   '1993-10-27'),\n    (CAST(NULL AS BIGINT), 'O',                   '1996-12-01'),\n    (CAST(NULL AS BIGINT), CAST(NULL AS VARCHAR), CAST(NULL AS VARCHAR)),\n    (CAST(NULL AS BIGINT), CAST(NULL AS VARCHAR), '1995-07-16')\n) AS orders (orderkey, orderstatus, orderdate)\n";
    private static final String VALUES_WITH_NAN = "SELECT *\nFROM (\n  VALUES\n    ( 1, 'O', '1996-01-02'),\n    ( 2, 'O', '1996-12-01'),\n    ( 3, 'F', '1993-10-14'),\n    ( 4, 'O', '1995-10-11'),\n    ( nan(), 'F', '1994-07-30'),\n    ( 6, 'F', '1992-02-21'),\n    ( 7, 'O', '1996-01-10'),\n    (32, 'O', '1995-07-16'),\n    (33, 'F', '1993-10-27'),\n    (34, 'O', '1998-07-21')\n) AS orders (orderkey, orderstatus, orderdate)\n";
    private static final String VALUES_WITH_INFINITY = "SELECT *\nFROM (\n  VALUES\n    ( 1, 'O', '1996-01-02'),\n    ( 2, 'O', '1996-12-01'),\n    ( 3, 'F', '1993-10-14'),\n    ( 4, 'O', '1995-10-11'),\n    ( infinity(), 'F', '1994-07-30'),\n    ( 6, 'F', '1992-02-21'),\n    ( 7, 'O', '1996-01-10'),\n    (32, 'O', '1995-07-16'),\n    (33, 'F', '1993-10-27'),\n    (34, 'O', '1998-07-21')\n) AS orders (orderkey, orderstatus, orderdate)\n";

    private WindowAssertions() {
    }

    public static void assertWindowQuery(@Language(value="SQL") String sql, MaterializedResult expected, QueryRunner queryRunner) {
        String query = String.format("SELECT orderkey, orderstatus,\n%s\nFROM (%s) x\n", sql, VALUES);
        MaterializedResult actual = queryRunner.execute(query);
        Assertions.assertThat((List)actual.getMaterializedRows()).containsExactlyInAnyOrderElementsOf((Iterable)expected.getMaterializedRows());
    }

    public static void assertWindowQueryWithNulls(@Language(value="SQL") String sql, MaterializedResult expected, QueryRunner queryRunner) {
        MaterializedResult actual = WindowAssertions.executeWindowQueryWithNulls(sql, queryRunner);
        Assertions.assertThat((List)actual.getMaterializedRows()).containsExactlyInAnyOrderElementsOf((Iterable)expected.getMaterializedRows());
    }

    public static MaterializedResult executeWindowQueryWithNulls(@Language(value="SQL") String sql, QueryRunner queryRunner) {
        String query = String.format("SELECT orderkey, orderstatus,\n%s\nFROM (%s) x\n", sql, VALUES_WITH_NULLS);
        return queryRunner.execute(query);
    }

    public static void assertWindowQueryWithNan(@Language(value="SQL") String sql, MaterializedResult expected, QueryRunner queryRunner) {
        String query = String.format("SELECT orderkey, orderstatus,\n%s\nFROM (%s) x\n", sql, VALUES_WITH_NAN);
        MaterializedResult actual = queryRunner.execute(query);
        Assertions.assertThat((List)actual.getMaterializedRows()).containsExactlyInAnyOrderElementsOf((Iterable)expected.getMaterializedRows());
    }

    public static void assertWindowQueryWithInfinity(@Language(value="SQL") String sql, MaterializedResult expected, QueryRunner queryRunner) {
        String query = String.format("SELECT orderkey, orderstatus,\n%s\nFROM (%s) x\n", sql, VALUES_WITH_INFINITY);
        MaterializedResult actual = queryRunner.execute(query);
        Assertions.assertThat((List)actual.getMaterializedRows()).containsExactlyInAnyOrderElementsOf((Iterable)expected.getMaterializedRows());
    }
}

