/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.server.protocol.spooling.QueryDataEncodingConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

class TestQueryDataEncodingConfig {
    TestQueryDataEncodingConfig() {
    }

    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((QueryDataEncodingConfig)ConfigAssertions.recordDefaults(QueryDataEncodingConfig.class)).setJsonEnabled(true).setJsonLz4Enabled(true).setJsonZstdEnabled(true).setCompressionThreshold(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.KILOBYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"protocol.spooling.encoding.json.enabled", (Object)"false").put((Object)"protocol.spooling.encoding.json+lz4.enabled", (Object)"false").put((Object)"protocol.spooling.encoding.json+zstd.enabled", (Object)"false").put((Object)"protocol.spooling.encoding.compression.threshold", (Object)"1MB").buildOrThrow();
        QueryDataEncodingConfig expected = new QueryDataEncodingConfig().setJsonEnabled(false).setJsonLz4Enabled(false).setJsonZstdEnabled(false).setCompressionThreshold(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

