/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.server.security.oauth2.OidcDiscoveryConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestOidcDiscoveryConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((OidcDiscoveryConfig)ConfigAssertions.recordDefaults(OidcDiscoveryConfig.class)).setDiscoveryTimeout(new Duration(30.0, TimeUnit.SECONDS)).setUserinfoEndpointEnabled(true).setAccessTokenIssuer(null).setAuthUrl(null).setTokenUrl(null).setJwksUrl(null).setUserinfoUrl(null));
    }

    @Test
    public void testExplicitPropertyMapping() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"http-server.authentication.oauth2.oidc.discovery.timeout", (Object)"1m").put((Object)"http-server.authentication.oauth2.oidc.use-userinfo-endpoint", (Object)"false").put((Object)"http-server.authentication.oauth2.access-token-issuer", (Object)"https://issuer.com/at").put((Object)"http-server.authentication.oauth2.auth-url", (Object)"https://issuer.com/auth").put((Object)"http-server.authentication.oauth2.token-url", (Object)"https://issuer.com/token").put((Object)"http-server.authentication.oauth2.jwks-url", (Object)"https://issuer.com/jwks.json").put((Object)"http-server.authentication.oauth2.userinfo-url", (Object)"https://issuer.com/user").buildOrThrow();
        OidcDiscoveryConfig expected = new OidcDiscoveryConfig().setDiscoveryTimeout(new Duration(1.0, TimeUnit.MINUTES)).setUserinfoEndpointEnabled(false).setAccessTokenIssuer("https://issuer.com/at").setAuthUrl("https://issuer.com/auth").setTokenUrl("https://issuer.com/token").setJwksUrl("https://issuer.com/jwks.json").setUserinfoUrl("https://issuer.com/user");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

