/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import io.airlift.units.DataSize;
import io.trino.ExceededSpillLimitException;
import io.trino.spiller.SpillSpaceTracker;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSpillSpaceTracker {
    private static final DataSize MAX_DATA_SIZE = DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE);

    @Test
    public void testSpillSpaceTracker() {
        SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(MAX_DATA_SIZE);
        Assertions.assertThat((long)spillSpaceTracker.getCurrentBytes()).isEqualTo(0L);
        Assertions.assertThat((long)spillSpaceTracker.getMaxBytes()).isEqualTo(MAX_DATA_SIZE.toBytes());
        long reservedBytes = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
        spillSpaceTracker.reserve(reservedBytes);
        Assertions.assertThat((long)spillSpaceTracker.getCurrentBytes()).isEqualTo(reservedBytes);
        long otherReservedBytes = DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
        spillSpaceTracker.reserve(otherReservedBytes);
        Assertions.assertThat((long)spillSpaceTracker.getCurrentBytes()).isEqualTo(reservedBytes + otherReservedBytes);
        spillSpaceTracker.reserve(otherReservedBytes);
        Assertions.assertThat((long)spillSpaceTracker.getCurrentBytes()).isEqualTo(reservedBytes + 2L * otherReservedBytes);
        spillSpaceTracker.free(otherReservedBytes);
        spillSpaceTracker.free(otherReservedBytes);
        Assertions.assertThat((long)spillSpaceTracker.getCurrentBytes()).isEqualTo(reservedBytes);
        spillSpaceTracker.free(reservedBytes);
        Assertions.assertThat((long)spillSpaceTracker.getCurrentBytes()).isEqualTo(0L);
    }

    @Test
    public void testSpillOutOfSpace() {
        SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(MAX_DATA_SIZE);
        Assertions.assertThat((long)spillSpaceTracker.getCurrentBytes()).isEqualTo(0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spillSpaceTracker.reserve(MAX_DATA_SIZE.toBytes() + 1L)).isInstanceOf(ExceededSpillLimitException.class)).hasMessageMatching("Query exceeded local spill limit of.*");
    }

    @Test
    public void testFreeToMuch() {
        SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(MAX_DATA_SIZE);
        Assertions.assertThat((long)spillSpaceTracker.getCurrentBytes()).isEqualTo(0L);
        spillSpaceTracker.reserve(1000L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spillSpaceTracker.free(1001L)).isInstanceOf(IllegalArgumentException.class)).hasMessage("tried to free more disk space than is reserved");
    }
}

