/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.rule.EvaluateCase;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestEvaluateCase {
    @Test
    void test() {
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)new Reference((Type)VarcharType.VARCHAR, "a"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "b")))).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Reference((Type)VarcharType.VARCHAR, "a"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "b")))).describedAs("match", new Object[0])).isEqualTo(Optional.of(new Reference((Type)VarcharType.VARCHAR, "a")));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Reference((Type)VarcharType.VARCHAR, "a"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "b")))).describedAs("no match - false", new Object[0])).isEqualTo(Optional.of(new Reference((Type)VarcharType.VARCHAR, "b")));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.NULL_BOOLEAN, (Expression)new Reference((Type)VarcharType.VARCHAR, "a"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "b")))).describedAs("no match - null", new Object[0])).isEqualTo(Optional.of(new Reference((Type)VarcharType.VARCHAR, "b")));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateCase().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

