/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.SimplifyComplementaryLogicalTerms;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

class TestSimplifyComplementaryLogicalTerms {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution(InMemoryTransactionManager.createTestTransactionManager(), TestingPlannerContext.PLANNER_CONTEXT);
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", (List<TypeSignatureProvider>)ImmutableList.of());

    TestSimplifyComplementaryLogicalTerms() {
    }

    @Test
    void testOr() {
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)Booleans.TRUE))))).isEqualTo(Optional.of(new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)new IsNull((Expression)Booleans.TRUE))))));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)new Reference((Type)BooleanType.BOOLEAN, "x"))))).isEqualTo(Optional.empty());
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "b"), (Object)IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)new Reference((Type)BooleanType.BOOLEAN, "a")))))).isEqualTo(Optional.of(new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"))))), (Object)new Reference((Type)BooleanType.BOOLEAN, "b")))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of())), (Object)IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of()))))))).describedAs("Non-deterministic terms", new Object[0])).isEqualTo(Optional.empty());
    }

    @Test
    void testAnd() {
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)Booleans.TRUE))))).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)new IsNull((Expression)Booleans.TRUE)))));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)new Reference((Type)BooleanType.BOOLEAN, "x"))))).isEqualTo(Optional.empty());
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "b"), (Object)IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)new Reference((Type)BooleanType.BOOLEAN, "a")))))).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new IsNull((Expression)new Reference((Type)BooleanType.BOOLEAN, "a")))), (Object)new Reference((Type)BooleanType.BOOLEAN, "b")))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of())), (Object)IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of()))))))).describedAs("Non-deterministic terms", new Object[0])).isEqualTo(Optional.empty());
    }

    private Optional<Expression> optimize(Expression expression) {
        return new SimplifyComplementaryLogicalTerms(TestingPlannerContext.PLANNER_CONTEXT).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

