/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.rule.SimplifyRedundantCase;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSimplifyRedundantCase {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution(InMemoryTransactionManager.createTestTransactionManager(), TestingPlannerContext.PLANNER_CONTEXT);
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", (List<TypeSignatureProvider>)ImmutableList.of());

    @Test
    void test() {
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.TRUE)), (Expression)Booleans.FALSE))).isEqualTo(Optional.of(new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.TRUE)));
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.FALSE)), (Expression)Booleans.TRUE))).isEqualTo(Optional.of(IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.TRUE))));
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.TRUE)), (Expression)Booleans.TRUE))).isEqualTo(Optional.of(IrUtils.or((Expression[])new Expression[]{new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.TRUE), Booleans.TRUE})));
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.FALSE)), (Expression)Booleans.FALSE))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), (Expression)Booleans.TRUE)), (Expression)Booleans.FALSE))).isEqualTo(Optional.of(new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), (Expression)Booleans.TRUE)));
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), (Expression)Booleans.FALSE)), (Expression)Booleans.TRUE))).isEqualTo(Optional.of(IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), (Expression)Booleans.TRUE))));
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "y"), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "z"), (Expression)Booleans.TRUE)), (Expression)Booleans.FALSE))).isEqualTo(Optional.of(IrUtils.or((Expression[])new Expression[]{new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.TRUE), IrUtils.and((Expression[])new Expression[]{IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "y"), (Expression)Booleans.TRUE)), new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "z"), (Expression)Booleans.TRUE)})})));
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "y"), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "z"), (Expression)Booleans.FALSE)), (Expression)Booleans.TRUE))).isEqualTo(Optional.of(IrUtils.or((Expression[])new Expression[]{new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.TRUE), IrUtils.and((Expression[])new Expression[]{IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "y"), (Expression)Booleans.TRUE)), IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "z"), (Expression)Booleans.TRUE))})})));
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a1"), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a2"), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a3"), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a4"), (Expression)Booleans.TRUE)), (Expression)Booleans.TRUE))).isEqualTo(Optional.of(IrUtils.or((Expression[])new Expression[]{new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a1"), (Expression)Booleans.TRUE), IrUtils.and((Expression[])new Expression[]{IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a2"), (Expression)Booleans.TRUE)), IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a3"), (Expression)Booleans.TRUE)), IrUtils.or((Expression[])new Expression[]{new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a4"), (Expression)Booleans.TRUE), Booleans.TRUE})})})));
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a1"), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a2"), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a3"), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a4"), (Expression)Booleans.FALSE)), (Expression)Booleans.TRUE))).isEqualTo(Optional.of(IrUtils.and((Expression[])new Expression[]{IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a1"), (Expression)Booleans.TRUE)), IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a2"), (Expression)Booleans.TRUE)), IrUtils.or((Expression[])new Expression[]{new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a3"), (Expression)Booleans.TRUE), IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a4"), (Expression)Booleans.TRUE))})})));
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a1"), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a2"), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a3"), (Expression)Booleans.FALSE)), (Expression)Booleans.FALSE))).isEqualTo(Optional.of(new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a1"), (Expression)Booleans.TRUE)));
    }

    @Test
    void testNonDeterministic() {
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0)), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "y"), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "z"), (Expression)Booleans.TRUE)), (Expression)Booleans.FALSE))).isEmpty();
    }

    private Optional<Expression> optimize(Expression expression) {
        return new SimplifyRedundantCase(TestingPlannerContext.PLANNER_CONTEXT).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

