/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.AbstractPredicatePushdownTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinType;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPredicatePushdownWithoutDynamicFilter
extends AbstractPredicatePushdownTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction RANDOM_INTEGER = FUNCTIONS.resolveFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER}));

    public TestPredicatePushdownWithoutDynamicFilter() {
        super(false);
    }

    @Override
    @Test
    public void testCoercions() {
        this.assertPlan("WITH     t(k, v) AS (SELECT nationkey, CAST(name AS varchar(4)) FROM nation),    u(k, v) AS (SELECT nationkey, CAST(name AS varchar(4)) FROM nation) SELECT 1 FROM t JOIN u ON t.k = u.k AND t.v = u.v WHERE t.v = 'x'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("t_k", "u_k").left(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"x")), (Expression)new Cast((Expression)new Reference((Type)VarcharType.createVarcharType((int)4), "t_v"), (Type)VarcharType.createVarcharType((int)4))), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"t_k", (Object)"nationkey", (Object)"t_v", (Object)"name"))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"x")), (Expression)new Cast((Expression)new Reference((Type)VarcharType.createVarcharType((int)5), "u_v"), (Type)VarcharType.createVarcharType((int)4))), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"u_k", (Object)"nationkey", (Object)"u_v", (Object)"name")))))))));
        this.assertPlan("WITH     t(k, v) AS (SELECT nationkey, CAST(name AS varchar(4)) FROM nation),    u(k, v) AS (SELECT nationkey, CAST(name AS varchar(5)) FROM nation) SELECT 1 FROM t JOIN u ON t.k = u.k AND t.v = u.v WHERE t.v = 'x'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("t_k", "u_k").left(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"x")), (Expression)new Cast((Expression)new Reference((Type)VarcharType.createVarcharType((int)4), "t_v"), (Type)VarcharType.createVarcharType((int)4))), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"t_k", (Object)"nationkey", (Object)"t_v", (Object)"name"))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.createVarcharType((int)5), (Object)Slices.utf8Slice((String)"x")), (Expression)new Cast((Expression)new Reference((Type)VarcharType.createVarcharType((int)5), "u_v"), (Type)VarcharType.createVarcharType((int)5))), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"u_k", (Object)"nationkey", (Object)"u_v", (Object)"name")))))))));
    }

    @Test
    public void testNormalizeOuterJoinToInner() {
        Session disableJoinReordering = Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("join_reordering_strategy", "NONE").build();
        this.assertPlan("SELECT customer.name, orders.orderdate FROM orders LEFT JOIN customer ON orders.custkey = customer.custkey WHERE customer.name IS NOT NULL", disableJoinReordering, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("o_custkey", "c_custkey").left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderdate", (Object)"orderdate", (Object)"o_custkey", (Object)"custkey"))).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter(IrExpressions.not((Metadata)this.getPlanTester().getPlannerContext().getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)VarcharType.VARCHAR, "c_name"))), PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"c_custkey", (Object)"custkey", (Object)"c_name", (Object)"name"))))))));
        this.assertPlan("SELECT customer.name, lineitem.partkey FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey LEFT JOIN customer ON orders.custkey = customer.custkey WHERE customer.name IS NOT NULL", disableJoinReordering, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("o_custkey", "c_custkey").left(PlanMatchPattern.join(JoinType.LEFT, leftJoinBuilder -> leftJoinBuilder.equiCriteria("l_orderkey", "o_orderkey").left(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey"))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey", (Object)"o_custkey", (Object)"custkey")))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter(IrExpressions.not((Metadata)this.getPlanTester().getPlannerContext().getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)VarcharType.VARCHAR, "c_name"))), PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"c_custkey", (Object)"custkey", (Object)"c_name", (Object)"name"))))))));
    }

    @Test
    public void testNonDeterministicPredicateDoesNotPropagateFromFilteringSideToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey = random(5))", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", false, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_ORDER_KEY"), (Expression)new Cast((Expression)new Call(RANDOM_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Type)BigintType.BIGINT)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testNonStraddlingJoinExpression() {
        this.assertPlan("SELECT * FROM orders JOIN lineitem ON orders.orderkey = lineitem.orderkey AND cast(lineitem.linenumber AS varchar) = '2'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("LINEITEM_OK", "ORDERS_OK").left(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Reference((Type)IntegerType.INTEGER, "LINEITEM_LINENUMBER"), (Type)VarcharType.VARCHAR), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2"))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey", (Object)"LINEITEM_LINENUMBER", (Object)"linenumber")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))))));
    }
}

