/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ImplementLimitWithTies;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestImplementLimitWithTies
extends BaseRuleTest {
    public TestImplementLimitWithTies() {
        super(new Plugin[0]);
    }

    @Test
    public void testReplaceLimitWithTies() {
        this.tester().assertThat((Rule<?>)new ImplementLimitWithTies(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.limit(2L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a, b));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "rank_num"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST))).addFunction("rank_num", PlanMatchPattern.windowFunction("rank", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.values("a", "b")))));
    }
}

