/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.MergeLimitOverProjectWithSort;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestMergeLimitOverProjectWithSort
extends BaseRuleTest {
    public TestMergeLimitOverProjectWithSort() {
        super(new Plugin[0]);
    }

    @Test
    public void testMergeLimitOverProjectWithSort() {
        this.tester().assertThat((Rule<?>)new MergeLimitOverProjectWithSort()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.limit(1L, (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{b}), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a, b))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void doNotMergeLimitWithTies() {
        this.tester().assertThat((Rule<?>)new MergeLimitOverProjectWithSort()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)b), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{b}), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a, b))));
        }).doesNotFire();
    }

    @Test
    public void testLimitWithPreSortedInputs() {
        this.tester().assertThat((Rule<?>)new MergeLimitOverProjectWithSort()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            ImmutableList orderBy = ImmutableList.of((Object)a);
            return p.limit(1L, false, (List<Symbol>)orderBy, (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{b}), (PlanNode)p.sort((List<Symbol>)orderBy, (PlanNode)p.values(a, b))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }
}

