/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.MergeProjectWithValues;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.type.UnknownType;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestMergeProjectWithValues
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction ADD_DOUBLE = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
    private static final ResolvedFunction NEGATION_DOUBLE = FUNCTIONS.resolveOperator(OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE));

    public TestMergeProjectWithValues() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNonRowType() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of(), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new Constant((Type)UnknownType.UNKNOWN, null))), (Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))))))).doesNotFire();
    }

    @Test
    public void testProjectWithoutOutputSymbols() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of(), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Object)Booleans.TRUE)), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"y")), (Object)Booleans.FALSE)))))).matches(PlanMatchPattern.values(2));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of())))).matches(PlanMatchPattern.values(2));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of(), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<List<Expression>>)ImmutableList.of()))).matches(PlanMatchPattern.values(new String[0]));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of()))).matches(PlanMatchPattern.values(new String[0]));
    }

    @Test
    public void testValuesWithoutOutputSymbols() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("a", (Type)CharType.createCharType((int)1)), (Expression)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Symbol)p.symbol("b", (Type)BooleanType.BOOLEAN), (Expression)Booleans.TRUE), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of())))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Object)Booleans.TRUE), (Object)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Object)Booleans.TRUE))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("a", (Type)CharType.createCharType((int)1)), (Expression)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Symbol)p.symbol("b", (Type)BooleanType.BOOLEAN), (Expression)Booleans.TRUE), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of()))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), (List<List<Expression>>)ImmutableList.of()));
    }

    @Test
    public void testNonDeterministicValues() {
        Call randomFunction = new Call(this.tester().getMetadata().resolveBuiltinFunction("random", (List)ImmutableList.of()), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("rand", (Type)DoubleType.DOUBLE), (Expression)new Reference((Type)DoubleType.DOUBLE, "rand")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("rand", (Type)DoubleType.DOUBLE)), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction)))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"rand"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)randomFunction))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("output", (Type)DoubleType.DOUBLE), (Expression)new Reference((Type)DoubleType.DOUBLE, "value")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("value", (Type)DoubleType.DOUBLE)), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, null))), (Object)new Row((List)ImmutableList.of((Object)randomFunction)), (Object)new Row((List)ImmutableList.of((Object)new Call(NEGATION_DOUBLE, (List)ImmutableList.of((Object)randomFunction)))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"output"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, null)), (Object)ImmutableList.of((Object)randomFunction), (Object)ImmutableList.of((Object)new Call(NEGATION_DOUBLE, (List)ImmutableList.of((Object)randomFunction))))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x", (Type)DoubleType.DOUBLE), (Expression)new Call(NEGATION_DOUBLE, (List)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "a"))), (Symbol)p.symbol("y", (Type)DoubleType.DOUBLE), (Expression)new Reference((Type)DoubleType.DOUBLE, "b")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a", (Type)DoubleType.DOUBLE), (Object)p.symbol("b", (Type)DoubleType.DOUBLE)), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.0), (Object)randomFunction)), (Object)new Row((List)ImmutableList.of((Object)randomFunction, (Object)new Constant((Type)DoubleType.DOUBLE, null))), (Object)new Row((List)ImmutableList.of((Object)new Call(NEGATION_DOUBLE, (List)ImmutableList.of((Object)randomFunction)), (Object)new Constant((Type)DoubleType.DOUBLE, null))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x", (Object)"y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Call(NEGATION_DOUBLE, (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.0))), (Object)randomFunction), (Object)ImmutableList.of((Object)new Call(NEGATION_DOUBLE, (List)ImmutableList.of((Object)randomFunction)), (Object)new Constant((Type)DoubleType.DOUBLE, null)), (Object)ImmutableList.of((Object)new Call(NEGATION_DOUBLE, (List)ImmutableList.of((Object)new Call(NEGATION_DOUBLE, (List)ImmutableList.of((Object)randomFunction)))), (Object)new Constant((Type)DoubleType.DOUBLE, null)))));
    }

    @Test
    public void testDoNotFireOnNonDeterministicValues() {
        Call randomFunction = new Call(this.tester().getMetadata().resolveBuiltinFunction("random", (List)ImmutableList.of()), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x", (Type)DoubleType.DOUBLE), (Expression)new Reference((Type)DoubleType.DOUBLE, "rand"), (Symbol)p.symbol("y", (Type)DoubleType.DOUBLE), (Expression)new Reference((Type)DoubleType.DOUBLE, "rand")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("rand", (Type)DoubleType.DOUBLE)), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction)))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x", (Type)DoubleType.DOUBLE), (Expression)new Call(ADD_DOUBLE, (List)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "rand"), (Object)new Reference((Type)DoubleType.DOUBLE, "rand")))), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("rand", (Type)DoubleType.DOUBLE)), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction)))))).doesNotFire();
    }

    @Test
    public void testCorrelation() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Reference((Type)IntegerType.INTEGER, "corr")))), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a", (Type)IntegerType.INTEGER)), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Reference((Type)IntegerType.INTEGER, "corr")))))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "corr"))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "corr")))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x", (Type)IntegerType.INTEGER), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "corr"))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))));
    }

    @Test
    public void testFailingExpression() {
        Call failFunction = LogicalPlanner.failFunction((Metadata)this.tester().getMetadata(), (ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (String)"message");
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x", (Type)UnknownType.UNKNOWN), (Expression)failFunction), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)failFunction))));
    }

    @Test
    public void testMergeProjectWithValues() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> {
            Symbol a = p.symbol("a", (Type)BooleanType.BOOLEAN);
            Symbol b = p.symbol("b", (Type)BooleanType.BOOLEAN);
            Symbol c = p.symbol("c", (Type)BooleanType.BOOLEAN);
            Symbol d = p.symbol("d", (Type)BooleanType.BOOLEAN);
            Symbol e = p.symbol("e", (Type)BooleanType.BOOLEAN);
            Symbol f = p.symbol("f", (Type)IntegerType.INTEGER);
            Assignments.Builder assignments = Assignments.builder();
            assignments.putIdentity(a);
            assignments.put(d, (Expression)b.toSymbolReference());
            assignments.put(e, (Expression)new IsNull((Expression)a.toSymbolReference()));
            assignments.put(f, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
            return p.project(assignments.build(), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)c), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Object)Booleans.TRUE, (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"y")), (Object)Booleans.FALSE, (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"z")), (Object)Booleans.TRUE, (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L))))));
        }).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"d", (Object)"e", (Object)"f"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Object)Booleans.TRUE, (Object)new IsNull((Expression)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x"))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"y")), (Object)Booleans.FALSE, (Object)new IsNull((Expression)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"y"))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"z")), (Object)Booleans.TRUE, (Object)new IsNull((Expression)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"z"))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> {
            Symbol a = p.symbol("a", (Type)BooleanType.BOOLEAN);
            Symbol b = p.symbol("b", (Type)BooleanType.BOOLEAN);
            Symbol c = p.symbol("c", (Type)BooleanType.BOOLEAN);
            Symbol d = p.symbol("d", (Type)BooleanType.BOOLEAN);
            Symbol e = p.symbol("e", (Type)BooleanType.BOOLEAN);
            Symbol f = p.symbol("f", (Type)IntegerType.INTEGER);
            Assignments.Builder assignments = Assignments.builder();
            assignments.putIdentity(a);
            assignments.put(d, (Expression)b.toSymbolReference());
            assignments.put(e, (Expression)new IsNull((Expression)a.toSymbolReference()));
            assignments.put(f, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
            return p.project(assignments.build(), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)c), (List<List<Expression>>)ImmutableList.of()));
        }).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"d", (Object)"e", (Object)"f"), (List<List<Expression>>)ImmutableList.of()));
    }
}

