/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneUnionColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneUnionColumns
extends BaseRuleTest {
    public TestPruneUnionColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneInputColumns() {
        this.tester().assertThat((Rule<?>)new PruneUnionColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.project(Assignments.of(), (PlanNode)p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.of((Object)a, (Object)b, (Object)a, (Object)c), (List<PlanNode>)ImmutableList.of((Object)p.values(b), (Object)p.values(c))));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.union(PlanMatchPattern.values("b"), PlanMatchPattern.values("c")).withExactOutputs(new String[0])));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneUnionColumns()).on(p -> {
            Symbol a = p.symbol("a");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.enforceSingleRow((PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

