/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestTransformUncorrelatedInPredicateSubqueryToSemiJoin
extends BaseRuleTest {
    public TestTransformUncorrelatedInPredicateSubqueryToSemiJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNoCorrelation() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedInPredicateSubqueryToSemiJoin()).on(p -> p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of(), Collections.emptyList(), (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnNonInPredicateSubquery() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedInPredicateSubqueryToSemiJoin()).on(p -> p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)p.symbol("x"), (Object)new ApplyNode.Exists()), Collections.emptyList(), (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }

    @Test
    public void testFiresForInPredicate() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedInPredicateSubqueryToSemiJoin()).on(p -> p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)p.symbol("x"), (Object)new ApplyNode.In(p.symbol("y"), p.symbol("z"))), Collections.emptyList(), (PlanNode)p.values(p.symbol("y")), (PlanNode)p.values(p.symbol("z")))).matches(PlanMatchPattern.node(SemiJoinNode.class, PlanMatchPattern.values("y"), PlanMatchPattern.values("z")));
    }
}

