/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestGroupingSets {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testPredicateOverGroupingKeysWithEmptyGroupingSet() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t AS (    SELECT a    FROM (        VALUES 1, 2    ) AS u(a)    GROUP BY GROUPING SETS ((), (a)))SELECT * FROM t WHERE a IS NOT NULL"))).matches("VALUES 1, 2");
    }

    @Test
    public void testDistinctWithMixedReferences() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a FROM (VALUES 1) t(a) GROUP BY DISTINCT ROLLUP(a, t.a)"))).matches("VALUES (1), (NULL)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a FROM (VALUES 1) t(a) GROUP BY DISTINCT GROUPING SETS ((a), (t.a))"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a FROM (VALUES 1) t(a) GROUP BY DISTINCT a, GROUPING SETS ((), (t.a))"))).matches("VALUES 1");
    }

    @Test
    public void testRollupAggregationWithOrderedLimit() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a FROM (VALUES 3, 2, 1) t(a) GROUP BY ROLLUP (a) ORDER BY a LIMIT 2"))).matches("VALUES 1, 2");
    }

    @Test
    public void testComplexCube() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, b, c, count(*)\nFROM (VALUES (1, 1, 1), (1, 2, 2), (1, 2, 2)) t(a, b, c)\nGROUP BY CUBE (a, (b, c))\n"))).matches("VALUES\n    (   1,    1,    1, BIGINT '1'),\n    (   1,    2,    2, 2),\n    (   1, NULL, NULL, 3),\n    (NULL, NULL, NULL, 3),\n    (NULL,    1,    1, 1),\n    (NULL,    2,    2, 2)\n");
    }

    @Test
    public void testComplexRollup() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, b, c, count(*)\nFROM (VALUES (1, 1, 1), (1, 2, 2), (1, 2, 2)) t(a, b, c)\nGROUP BY ROLLUP (a, (b, c))\n"))).matches(" VALUES\n (   1,    1,    1, BIGINT '1'),\n (NULL, NULL, NULL, 3),\n (   1, NULL, NULL, 3),\n (   1,    2,    2, 2)\n");
    }
}

