/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.io.BaseEncoding;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJsonExistsFunction {
    private static final String INPUT = "[\"a\", \"b\", \"c\"]";
    private static final String INCORRECT_INPUT = "[...";
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testJsonExists() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $[1]')"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'strict $[1]')"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $[100]')"))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'strict $[100]')"))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'strict $[100]' TRUE ON ERROR)"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'strict $[100]' FALSE ON ERROR)"))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'strict $[100]' UNKNOWN ON ERROR)"))).matches("VALUES cast(null AS boolean)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'strict $[100]' ERROR ON ERROR)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PATH_EVALUATION_ERROR}).hasMessage("path evaluation failed: structural error: invalid array subscript: [100, 100] for array of size 3");
    }

    @Test
    public void testInputFormat() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $[1]')"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]' FORMAT JSON, 'lax $[1]')"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]' FORMAT JSON ENCODING UTF8, 'lax $[1]')"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:20: Cannot read input of type varchar(15) as JSON using formatting JSON ENCODING UTF8");
        byte[] bytes = INPUT.getBytes(StandardCharsets.UTF_8);
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists(" + varbinaryLiteral + ", 'lax $[1]')"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists(" + varbinaryLiteral + " FORMAT JSON, 'lax $[1]')"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF8, 'lax $[1]')"))).matches("VALUES true");
        bytes = INPUT.getBytes(StandardCharsets.UTF_16LE);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF16, 'lax $[1]')"))).matches("VALUES true");
        bytes = INPUT.getBytes(Charset.forName("UTF-32LE"));
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF32, 'lax $[1]')"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF8, 'lax $[1]' ERROR ON ERROR)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
    }

    @Test
    public void testInputConversionError() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[...', 'lax $[1]')"))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[...', 'strict $[1]' TRUE ON ERROR)"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[...', 'strict $[1]' FALSE ON ERROR)"))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[...', 'strict $[1]' UNKNOWN ON ERROR)"))).matches("VALUES cast(null AS boolean)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[...', 'strict $[1]' ERROR ON ERROR)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
    }

    @Test
    public void testPassingClause() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $number + 1' PASSING 2 AS number)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATH}).hasMessage("line 1:39: no value passed for parameter number. Try quoting \"number\" in the PASSING clause to match case");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $number + 1' PASSING 5 AS \"number\")"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $array[0]' PASSING '[1, 2, 3]' FORMAT JSON AS \"array\")"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $array[0]' PASSING '[...' FORMAT JSON AS \"array\")"))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $array[0]' PASSING '[...' FORMAT JSON AS \"array\" ERROR ON ERROR)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $[$number]' PASSING 5 AS \"number\")"))).matches("VALUES false");
    }

    @Test
    public void testIncorrectPath() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'certainly not a valid path')"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:40: mismatched input 'certainly' expecting {'lax', 'strict'}");
    }

    @Test
    public void testNullInput() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists(null, 'lax $')"))).matches("VALUES cast(null AS boolean)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $var' PASSING null AS \"var\")"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $var' PASSING null FORMAT JSON AS \"var\")"))).matches("VALUES false");
    }
}

