/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestPreAggregateCaseAggregations {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testCastExpression() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT MAX(CASE WHEN c1 = 1 THEN CAST(c2 AS int) END) AS m1, MAX(CASE WHEN c1 = 2 THEN c2 END) AS m2, MAX(CASE WHEN c1 = 3 THEN c2 END) AS m3, MAX(CASE WHEN c1 = 4 THEN c2 END) AS m4 FROM (VALUES (1, '1'), (2, '2'), (3, '3'), (4, 'd')) t(c1, c2)"))).matches("VALUES (1, '2', '3', 'd')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT MAX(CAST(CASE WHEN c1 = 1 THEN C2 END AS INT)) AS m1, MAX(CASE WHEN c1 = 2 THEN c2 END) AS m2, MAX(CASE WHEN c1 = 3 THEN c2 END) AS m3, MAX(CASE WHEN c1 = 4 THEN c2 END) AS m4 FROM (VALUES (1, '1'), (2, '2'), (3, '3'), (4, 'd')) t(c1, c2)"))).matches("VALUES (1, '2', '3', 'd')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT CAST(MAX(CASE WHEN c1 = 1 THEN C2 END) AS INT) AS m1, MAX(CASE WHEN c1 = 2 THEN c2 END) AS m2, MAX(CASE WHEN c1 = 3 THEN c2 END) AS m3, MAX(CASE WHEN c1 = 4 THEN c2 END) AS m4 FROM (VALUES (1, '1'), (2, '2'), (3, '3'), (4, 'd')) t(c1, c2)"))).matches("VALUES (1, '2', '3', 'd')");
    }

    @Test
    public void testDivisionByZero() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT MAX(CASE WHEN c1 = '1' THEN 10 / c2 END) AS m1, MAX(CASE WHEN c1 = '2' THEN 10 / c2 END) AS m2, MAX(CASE WHEN c1 = '3' THEN c2 END) AS m3, MAX(CASE WHEN c1 = '4' THEN c2 END) AS m4 FROM (VALUES ('1', 1), ('2', 2), ('3', 3), ('4', 0)) t(c1, c2)"))).matches("VALUES (10, 5, 3, 0)");
    }
}

