/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.execution.ScheduledSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;

public class SplitAssignment {
    private final PlanNodeId planNodeId;
    private final Set<ScheduledSplit> splits;
    private final boolean noMoreSplits;

    @JsonCreator
    public SplitAssignment(@JsonProperty(value="planNodeId") PlanNodeId planNodeId, @JsonProperty(value="splits") Set<ScheduledSplit> splits, @JsonProperty(value="noMoreSplits") boolean noMoreSplits) {
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.splits = (Set)Objects.requireNonNull(splits, "splits is null").stream().sorted(Comparator.comparingLong(ScheduledSplit::getSequenceId)).collect(ImmutableSet.toImmutableSet());
        this.noMoreSplits = noMoreSplits;
    }

    @JsonProperty
    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    @JsonProperty
    public Set<ScheduledSplit> getSplits() {
        return this.splits;
    }

    @JsonProperty
    public boolean isNoMoreSplits() {
        return this.noMoreSplits;
    }

    public SplitAssignment update(SplitAssignment assignment) {
        Preconditions.checkArgument((boolean)this.planNodeId.equals(assignment.getPlanNodeId()), (String)"Expected assignment for node %s, but got assignment for node %s", (Object)this.planNodeId, (Object)assignment.getPlanNodeId());
        if (this.isNewer(assignment)) {
            Preconditions.checkArgument((!this.noMoreSplits || this.splits.containsAll(assignment.getSplits()) ? 1 : 0) != 0, (String)"Assignment %s has new splits, but no more splits already set", (Object)this.planNodeId);
            ImmutableSet newSplits = ImmutableSet.builder().addAll(this.splits).addAll(assignment.getSplits()).build();
            return new SplitAssignment(this.planNodeId, (Set<ScheduledSplit>)newSplits, assignment.isNoMoreSplits());
        }
        return this;
    }

    private boolean isNewer(SplitAssignment assignment) {
        return !this.noMoreSplits && assignment.isNoMoreSplits() || !this.splits.containsAll(assignment.getSplits());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("planNodeId", (Object)this.planNodeId).add("splits", this.splits).add("noMoreSplits", this.noMoreSplits).toString();
    }
}

