/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import io.trino.execution.resourcegroups.UpdateablePriorityQueue;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public final class IndexedPriorityQueue<E>
implements UpdateablePriorityQueue<E> {
    private final Map<E, Entry<E>> index = new HashMap<E, Entry<E>>();
    private final Set<Entry<E>> queue;
    private long generation;

    public IndexedPriorityQueue() {
        this(PriorityOrdering.HIGH_TO_LOW);
    }

    public IndexedPriorityQueue(PriorityOrdering priorityOrdering) {
        this.queue = switch (priorityOrdering.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new TreeSet<Entry>(Comparator.comparingLong(entry -> entry.getPriority()).thenComparingLong(Entry::getGeneration));
            case 1 -> new TreeSet((entry1, entry2) -> {
                int priorityComparison = Long.compare(entry2.getPriority(), entry1.getPriority());
                if (priorityComparison != 0) {
                    return priorityComparison;
                }
                return Long.compare(entry1.getGeneration(), entry2.getGeneration());
            });
        };
    }

    @Override
    public boolean addOrUpdate(E element, long priority) {
        Entry<E> entry = this.index.get(element);
        if (entry != null) {
            if (entry.getPriority() == priority) {
                return false;
            }
            this.queue.remove(entry);
            Entry<E> newEntry = new Entry<E>(element, priority, entry.getGeneration());
            this.queue.add(newEntry);
            this.index.put(element, newEntry);
            return false;
        }
        Entry<E> newEntry = new Entry<E>(element, priority, this.generation);
        ++this.generation;
        this.queue.add(newEntry);
        this.index.put(element, newEntry);
        return true;
    }

    @Override
    public boolean contains(E element) {
        return this.index.containsKey(element);
    }

    @Override
    public boolean remove(E element) {
        Entry<E> entry = this.index.remove(element);
        if (entry != null) {
            this.queue.remove(entry);
            return true;
        }
        return false;
    }

    @Override
    public E poll() {
        Entry<E> entry = this.pollEntry();
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Prioritized<E> getPrioritized(E element) {
        Entry<E> entry = this.index.get(element);
        if (entry == null) {
            return null;
        }
        return new Prioritized<E>(entry.getValue(), entry.getPriority());
    }

    public Prioritized<E> pollPrioritized() {
        Entry<E> entry = this.pollEntry();
        if (entry == null) {
            return null;
        }
        return new Prioritized<E>(entry.getValue(), entry.getPriority());
    }

    private Entry<E> pollEntry() {
        Iterator<Entry<E>> iterator = this.queue.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Entry<E> entry = iterator.next();
        iterator.remove();
        Preconditions.checkState((this.index.remove(entry.getValue()) != null ? 1 : 0) != 0, (Object)"Failed to remove entry from index");
        return entry;
    }

    @Override
    public E peek() {
        Entry<E> entry = this.peekEntry();
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Prioritized<E> peekPrioritized() {
        Entry<E> entry = this.peekEntry();
        if (entry == null) {
            return null;
        }
        return new Prioritized<E>(entry.getValue(), entry.getPriority());
    }

    public Entry<E> peekEntry() {
        Iterator<Entry<E>> iterator = this.queue.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(this.queue.iterator(), Entry::getValue);
    }

    public static enum PriorityOrdering {
        LOW_TO_HIGH,
        HIGH_TO_LOW;

    }

    private static final class Entry<E> {
        private final E value;
        private final long priority;
        private final long generation;

        private Entry(E value, long priority, long generation) {
            this.value = Objects.requireNonNull(value, "value is null");
            this.priority = priority;
            this.generation = generation;
        }

        public E getValue() {
            return this.value;
        }

        public long getPriority() {
            return this.priority;
        }

        public long getGeneration() {
            return this.generation;
        }
    }

    public record Prioritized<V>(V value, long priority) {
        public Prioritized {
            Objects.requireNonNull(value, "value is null");
        }
    }
}

