/*
 * Decompiled with CFR 0.152.
 */
package io.trino.likematcher;

import io.trino.likematcher.DenseDfaMatcher;
import io.trino.likematcher.FjsMatcher;
import io.trino.likematcher.Matcher;
import io.trino.likematcher.NfaMatcher;
import io.trino.likematcher.Pattern;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class LikeMatcher {
    private final int minSize;
    private final OptionalInt maxSize;
    private final byte[] prefix;
    private final byte[] suffix;
    private final Optional<Matcher> matcher;

    private LikeMatcher(int minSize, OptionalInt maxSize, byte[] prefix, byte[] suffix, Optional<Matcher> matcher) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.prefix = prefix;
        this.suffix = suffix;
        this.matcher = matcher;
    }

    public static LikeMatcher compile(String pattern) {
        return LikeMatcher.compile(pattern, Optional.empty(), true);
    }

    public static LikeMatcher compile(String pattern, Optional<Character> escape) {
        return LikeMatcher.compile(pattern, escape, true);
    }

    public static LikeMatcher compile(String pattern, Optional<Character> escape, boolean optimize) {
        Pattern zeroOrMore22;
        Pattern zeroOrMore22;
        Pattern.Literal literal;
        List<Pattern> parsed = LikeMatcher.parse(pattern, escape);
        int minSize = 0;
        int maxSize = 0;
        boolean unbounded = false;
        block5: for (Pattern expression : parsed) {
            Pattern pattern2;
            Objects.requireNonNull(expression);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Literal.class, Pattern.ZeroOrMore.class, Pattern.Any.class}, (Pattern)pattern2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    literal = (Pattern.Literal)pattern2;
                    int length = literal.value().getBytes(StandardCharsets.UTF_8).length;
                    minSize += length;
                    maxSize += length;
                    continue block5;
                }
                case 1: {
                    Pattern.ZeroOrMore zeroOrMore22 = (Pattern.ZeroOrMore)pattern2;
                    unbounded = true;
                    continue block5;
                }
                case 2: 
            }
            Pattern.Any any = (Pattern.Any)pattern2;
            int length = any.length();
            minSize += length;
            maxSize += length * 4;
        }
        byte[] prefix = new byte[]{};
        byte[] suffix = new byte[]{};
        int patternStart = 0;
        int patternEnd = parsed.size() - 1;
        if (parsed.size() > 0 && (zeroOrMore22 = parsed.getFirst()) instanceof Pattern.Literal) {
            literal = (Pattern.Literal)zeroOrMore22;
            prefix = literal.value().getBytes(StandardCharsets.UTF_8);
            ++patternStart;
        }
        if (parsed.size() > 1 && (zeroOrMore22 = parsed.getLast()) instanceof Pattern.Literal) {
            literal = (Pattern.Literal)zeroOrMore22;
            suffix = literal.value().getBytes(StandardCharsets.UTF_8);
            --patternEnd;
        }
        boolean exact = true;
        if (patternStart <= patternEnd && parsed.get(patternEnd) instanceof Pattern.ZeroOrMore) {
            exact = false;
            --patternEnd;
        }
        Optional<Matcher> matcher = Optional.empty();
        if (patternStart <= patternEnd) {
            boolean hasAny = false;
            boolean hasAnyAfterZeroOrMore = false;
            boolean foundZeroOrMore = false;
            for (int i = patternStart; i <= patternEnd; ++i) {
                Pattern item = parsed.get(i);
                if (item instanceof Pattern.Any) {
                    if (foundZeroOrMore) {
                        hasAnyAfterZeroOrMore = true;
                    }
                    hasAny = true;
                    break;
                }
                if (!(item instanceof Pattern.ZeroOrMore)) continue;
                foundZeroOrMore = true;
            }
            matcher = hasAny ? (optimize && !hasAnyAfterZeroOrMore ? Optional.of(new DenseDfaMatcher(parsed, patternStart, patternEnd, exact)) : Optional.of(new NfaMatcher(parsed, patternStart, patternEnd, exact))) : Optional.of(new FjsMatcher(parsed, patternStart, patternEnd, exact));
        }
        return new LikeMatcher(minSize, unbounded ? OptionalInt.empty() : OptionalInt.of(maxSize), prefix, suffix, matcher);
    }

    public boolean match(byte[] input) {
        return this.match(input, 0, input.length);
    }

    public boolean match(byte[] input, int offset, int length) {
        if (length < this.minSize) {
            return false;
        }
        if (this.maxSize.isPresent() && length > this.maxSize.getAsInt()) {
            return false;
        }
        if (!this.startsWith(this.prefix, input, offset)) {
            return false;
        }
        if (!this.startsWith(this.suffix, input, offset + length - this.suffix.length)) {
            return false;
        }
        if (this.matcher.isPresent()) {
            return this.matcher.get().match(input, offset + this.prefix.length, length - this.suffix.length - this.prefix.length);
        }
        return true;
    }

    private boolean startsWith(byte[] pattern, byte[] input, int offset) {
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == input[offset + i]) continue;
            return false;
        }
        return true;
    }

    static List<Pattern> parse(String pattern, Optional<Character> escape) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        StringBuilder literal = new StringBuilder();
        int anyCount = 0;
        boolean anyUnbounded = false;
        boolean inEscape = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char character = pattern.charAt(i);
            if (inEscape) {
                if (character != '%' && character != '_' && character != escape.get().charValue()) {
                    throw new IllegalArgumentException("Escape character must be followed by '%', '_' or the escape character itself");
                }
                literal.append(character);
                inEscape = false;
                continue;
            }
            if (escape.isPresent() && character == escape.get().charValue()) {
                inEscape = true;
                if (anyCount != 0) {
                    result.add(new Pattern.Any(anyCount));
                    anyCount = 0;
                }
                if (!anyUnbounded) continue;
                result.add(new Pattern.ZeroOrMore());
                anyUnbounded = false;
                continue;
            }
            if (character == '%' || character == '_') {
                if (literal.length() != 0) {
                    result.add(new Pattern.Literal(literal.toString()));
                    literal.setLength(0);
                }
                if (character == '%') {
                    anyUnbounded = true;
                    continue;
                }
                ++anyCount;
                continue;
            }
            if (anyCount != 0) {
                result.add(new Pattern.Any(anyCount));
                anyCount = 0;
            }
            if (anyUnbounded) {
                result.add(new Pattern.ZeroOrMore());
                anyUnbounded = false;
            }
            literal.append(character);
        }
        if (inEscape) {
            throw new IllegalArgumentException("Escape character must be followed by '%', '_' or the escape character itself");
        }
        if (literal.length() != 0) {
            result.add(new Pattern.Literal(literal.toString()));
        } else {
            if (anyCount != 0) {
                result.add(new Pattern.Any(anyCount));
            }
            if (anyUnbounded) {
                result.add(new Pattern.ZeroOrMore());
            }
        }
        return result;
    }
}

