/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.trino.plugin.base.metrics.DurationTiming;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.spi.metrics.Metrics;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AggregationMetrics {
    @VisibleForTesting
    static final String INPUT_ROWS_WITH_PARTIAL_AGGREGATION_DISABLED_METRIC_NAME = "Input rows processed without partial aggregation enabled";
    private static final String ACCUMULATOR_TIME_METRIC_NAME = "Accumulator update CPU time";
    private static final String GROUP_BY_HASH_TIME_METRIC_NAME = "Group by hash update CPU time";
    private long accumulatorTimeNanos;
    private long groupByHashTimeNanos;
    private long inputRowsProcessedWithPartialAggregationDisabled;

    public void recordAccumulatorUpdateTimeSince(long startNanos) {
        this.accumulatorTimeNanos += System.nanoTime() - startNanos;
    }

    public void recordGroupByHashUpdateTimeSince(long startNanos) {
        this.groupByHashTimeNanos += System.nanoTime() - startNanos;
    }

    public void recordInputRowsProcessedWithPartialAggregationDisabled(long rows) {
        this.inputRowsProcessedWithPartialAggregationDisabled += rows;
    }

    public Metrics getMetrics() {
        return new Metrics((Map)ImmutableMap.of((Object)INPUT_ROWS_WITH_PARTIAL_AGGREGATION_DISABLED_METRIC_NAME, (Object)new LongCount(this.inputRowsProcessedWithPartialAggregationDisabled), (Object)ACCUMULATOR_TIME_METRIC_NAME, (Object)new DurationTiming(new Duration((double)this.accumulatorTimeNanos, TimeUnit.NANOSECONDS)), (Object)GROUP_BY_HASH_TIME_METRIC_NAME, (Object)new DurationTiming(new Duration((double)this.groupByHashTimeNanos, TimeUnit.NANOSECONDS))));
    }
}

