/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;

public class TableMutationOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private final OperatorContext operatorContext;
    private final Operation operation;
    private boolean finished;

    public TableMutationOperator(OperatorContext operatorContext, Operation operation) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.operation = Objects.requireNonNull(operation, "operation is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        this.finished = true;
        OptionalLong rowsUpdatedCount = this.operation.execute();
        return this.buildUpdatedCountPage(rowsUpdatedCount);
    }

    private Page buildUpdatedCountPage(OptionalLong count) {
        PageBuilder page = new PageBuilder(1, TYPES);
        BlockBuilder rowsBuilder = page.getBlockBuilder(0);
        page.declarePosition();
        if (count.isPresent()) {
            BigintType.BIGINT.writeLong(rowsBuilder, count.getAsLong());
        } else {
            rowsBuilder.appendNull();
        }
        return page.build();
    }

    public static interface Operation {
        public OptionalLong execute();
    }

    public static class TableMutationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Operation operation;
        private boolean closed;

        public TableMutationOperatorFactory(int operatorId, PlanNodeId planNodeId, Operation operation) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.operation = Objects.requireNonNull(operation, "operation is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TableMutationOperator.class.getSimpleName());
            return new TableMutationOperator(context, this.operation);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TableMutationOperatorFactory(this.operatorId, this.planNodeId, this.operation);
        }
    }
}

