/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ArrayFlattenFunction
extends SqlScalarFunction {
    public static final ArrayFlattenFunction ARRAY_FLATTEN_FUNCTION = new ArrayFlattenFunction();
    private static final String FUNCTION_NAME = "flatten";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayFlattenFunction.class, "flatten", Type.class, Type.class, Block.class);

    private ArrayFlattenFunction() {
        super(FunctionMetadata.scalarBuilder((String)FUNCTION_NAME).signature(Signature.builder().typeVariable("E").returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0])))).build()).description("Flattens the given array").build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        ArrayType arrayType = (ArrayType)boundSignature.getReturnType();
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(arrayType.getElementType()).bindTo(arrayType);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    public static Block flatten(Type type, Type arrayType, Block array) {
        if (array.getPositionCount() == 0) {
            return type.createBlockBuilder(null, 0).build();
        }
        BlockBuilder builder = type.createBlockBuilder(null, array.getPositionCount(), Math.toIntExact(array.getSizeInBytes() / (long)array.getPositionCount()));
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (array.isNull(i)) continue;
            Block subArray = (Block)arrayType.getObject(array, i);
            for (int j = 0; j < subArray.getPositionCount(); ++j) {
                type.appendTo(subArray, j, builder);
            }
        }
        return builder.build();
    }
}

