/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlRow;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.function.TypeVariableConstraint;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.JsonType;
import io.trino.util.Failures;
import io.trino.util.JsonUtil;
import io.trino.util.Reflection;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;

public class RowToJsonCast
extends SqlScalarFunction {
    public static final RowToJsonCast ROW_TO_JSON = new RowToJsonCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowToJsonCast.class, "toJsonObject", List.class, List.class, SqlRow.class);
    private static final JsonFactory JSON_FACTORY = JsonUtil.createJsonFactory();

    private RowToJsonCast() {
        super(FunctionMetadata.operatorBuilder((OperatorType)OperatorType.CAST).signature(Signature.builder().typeVariableConstraint(TypeVariableConstraint.builder((String)"T").variadicBound("row").castableTo((Type)JsonType.JSON).build()).returnType((Type)JsonType.JSON).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).build()).build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        Type type = boundSignature.getArgumentType(0);
        Failures.checkCondition(JsonUtil.canCastToJson(type), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast %s to JSON", type);
        List fieldTypes = type.getTypeParameters();
        ArrayList<JsonUtil.JsonGeneratorWriter> fieldWriters = new ArrayList<JsonUtil.JsonGeneratorWriter>(fieldTypes.size());
        List typeSignatureParameters = type.getTypeSignature().getParameters();
        ArrayList<String> fieldNames = new ArrayList<String>(fieldTypes.size());
        for (int i = 0; i < fieldTypes.size(); ++i) {
            fieldNames.add(((TypeSignatureParameter)typeSignatureParameters.get(i)).getNamedTypeSignature().getName().orElse(""));
            fieldWriters.add(JsonUtil.JsonGeneratorWriter.createJsonGeneratorWriter((Type)fieldTypes.get(i)));
        }
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(fieldNames).bindTo(fieldWriters);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static Slice toJsonObject(List<String> fieldNames, List<JsonUtil.JsonGeneratorWriter> fieldWriters, SqlRow sqlRow) {
        try {
            int rawIndex = sqlRow.getRawIndex();
            DynamicSliceOutput output = new DynamicSliceOutput(40);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeStartObject();
                for (int i = 0; i < sqlRow.getFieldCount(); ++i) {
                    jsonGenerator.writeFieldName(fieldNames.get(i));
                    Block fieldBlock = sqlRow.getRawFieldBlock(i);
                    fieldWriters.get(i).writeJsonValue(jsonGenerator, fieldBlock, rawIndex);
                }
                jsonGenerator.writeEndObject();
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

