/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timetz;

import com.google.common.base.Strings;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimeWithTimeZone;

@Description(value="Time zone of the given time")
@ScalarFunction(value="timezone")
public final class TimeZone {
    private TimeZone() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="varchar")
    public static Slice extractTimeZoneFromTime(@SqlType(value="time(p) with time zone") long timeWithTimeZone) {
        long totalOffsetMinutes = DateTimeEncoding.unpackOffsetMinutes((long)timeWithTimeZone);
        char sign = totalOffsetMinutes < 0L ? (char)'-' : '+';
        long absoluteOffsetMinutes = Math.abs(totalOffsetMinutes);
        String hours = Long.toString(absoluteOffsetMinutes / 60L);
        String minutes = Long.toString(absoluteOffsetMinutes % 60L);
        return Slices.utf8Slice((String)(sign + Strings.padStart((String)hours, (int)2, (char)'0') + ":" + Strings.padStart((String)minutes, (int)2, (char)'0')));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="varchar")
    public static Slice extractTimeZoneFromTimestamp(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone timeWithTimeZone) {
        long totalOffsetMinutes = timeWithTimeZone.getOffsetMinutes();
        char sign = totalOffsetMinutes < 0L ? (char)'-' : '+';
        long absoluteOffsetMinutes = Math.abs(totalOffsetMinutes);
        String hours = Long.toString(absoluteOffsetMinutes / 60L);
        String minutes = Long.toString(absoluteOffsetMinutes % 60L);
        return Slices.utf8Slice((String)(sign + Strings.padStart((String)hours, (int)2, (char)'0') + ":" + Strings.padStart((String)minutes, (int)2, (char)'0')));
    }
}

