/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.client.spooling.DataAttributes;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.spool.SpooledLocation;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Symbol;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public record SpooledBlock(Slice identifier, Optional<URI> directUri, Map<String, List<String>> headers, DataAttributes attributes) {
    private static final JsonCodec<Map<String, List<String>>> HEADERS_CODEC = JsonCodec.mapJsonCodec(String.class, (JsonCodec)JsonCodec.listJsonCodec(String.class));
    private static final JsonCodec<DataAttributes> ATTRIBUTES_CODEC = JsonCodec.jsonCodec(DataAttributes.class);
    public static final RowType SPOOLING_METADATA_TYPE = RowType.from(List.of(new RowType.Field(Optional.of("identifier"), (Type)VarcharType.VARCHAR), new RowType.Field(Optional.of("directLocation"), (Type)VarcharType.VARCHAR), new RowType.Field(Optional.of("headers"), (Type)VarcharType.VARCHAR), new RowType.Field(Optional.of("metadata"), (Type)VarcharType.VARCHAR)));
    public static final String SPOOLING_METADATA_COLUMN_NAME = "$spooling:metadata$";
    public static final Symbol SPOOLING_METADATA_SYMBOL = new Symbol((Type)SPOOLING_METADATA_TYPE, "$spooling:metadata$");

    public static SpooledBlock deserialize(Page page) {
        Verify.verify((page.getPositionCount() == 1 ? 1 : 0) != 0, (String)"Spooling metadata block must have a single position", (Object[])new Object[0]);
        Verify.verify((boolean)SpooledBlock.hasMetadataBlock(page), (String)"Spooling metadata block must have all but last channels null", (Object[])new Object[0]);
        SqlRow row = SPOOLING_METADATA_TYPE.getObject(page.getBlock(page.getChannelCount() - 1), 0);
        if (row.getRawFieldBlock(1).isNull(0)) {
            return new SpooledBlock(VarcharType.VARCHAR.getSlice(row.getRawFieldBlock(0), 0), Optional.empty(), (Map)HEADERS_CODEC.fromJson(VarcharType.VARCHAR.getSlice(row.getRawFieldBlock(2), 0).toStringUtf8()), (DataAttributes)ATTRIBUTES_CODEC.fromJson(VarcharType.VARCHAR.getSlice(row.getRawFieldBlock(3), 0).toStringUtf8()));
        }
        return new SpooledBlock(VarcharType.VARCHAR.getSlice(row.getRawFieldBlock(0), 0), Optional.of(URI.create(VarcharType.VARCHAR.getSlice(row.getRawFieldBlock(1), 0).toStringUtf8())), (Map)HEADERS_CODEC.fromJson(VarcharType.VARCHAR.getSlice(row.getRawFieldBlock(2), 0).toStringUtf8()), (DataAttributes)ATTRIBUTES_CODEC.fromJson(VarcharType.VARCHAR.getSlice(row.getRawFieldBlock(3), 0).toStringUtf8()));
    }

    public static SpooledBlock forLocation(SpooledLocation location, DataAttributes attributes) {
        SpooledLocation spooledLocation = location;
        Objects.requireNonNull(spooledLocation);
        SpooledLocation spooledLocation2 = spooledLocation;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SpooledLocation.DirectLocation.class, SpooledLocation.CoordinatorLocation.class}, (SpooledLocation)spooledLocation2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                SpooledLocation.DirectLocation directLocation = (SpooledLocation.DirectLocation)spooledLocation2;
                yield new SpooledBlock(directLocation.identifier(), Optional.of(directLocation.directUri()), directLocation.headers(), attributes);
            }
            case 1 -> {
                SpooledLocation.CoordinatorLocation coordinatorLocation = (SpooledLocation.CoordinatorLocation)spooledLocation2;
                yield new SpooledBlock(coordinatorLocation.identifier(), Optional.empty(), coordinatorLocation.headers(), attributes);
            }
        };
    }

    public Block serialize() {
        RowBlockBuilder rowBlockBuilder = SPOOLING_METADATA_TYPE.createBlockBuilder(null, 1);
        this.serialize(rowBlockBuilder);
        return rowBlockBuilder.build();
    }

    @VisibleForTesting
    void serialize(RowBlockBuilder rowBlockBuilder) {
        rowBlockBuilder.buildEntry(rowEntryBuilder -> {
            VarcharType.VARCHAR.writeSlice((BlockBuilder)rowEntryBuilder.get(0), this.identifier);
            if (this.directUri.isPresent()) {
                VarcharType.VARCHAR.writeSlice((BlockBuilder)rowEntryBuilder.get(1), Slices.utf8Slice((String)this.directUri.orElseThrow().toString()));
            } else {
                ((BlockBuilder)rowEntryBuilder.get(1)).appendNull();
            }
            VarcharType.VARCHAR.writeSlice((BlockBuilder)rowEntryBuilder.get(2), Slices.utf8Slice((String)HEADERS_CODEC.toJson(this.headers)));
            VarcharType.VARCHAR.writeSlice((BlockBuilder)rowEntryBuilder.get(3), Slices.utf8Slice((String)ATTRIBUTES_CODEC.toJson((Object)this.attributes)));
        });
    }

    public static Page createNonSpooledPage(Page page) {
        RowBlockBuilder rowBlockBuilder = SPOOLING_METADATA_TYPE.createBlockBuilder(null, page.getPositionCount());
        for (int i = 0; i < page.getPositionCount(); ++i) {
            rowBlockBuilder.appendNull();
        }
        return page.appendColumn(rowBlockBuilder.build());
    }

    private static boolean hasMetadataBlock(Page page) {
        for (int channel = 0; channel < page.getChannelCount() - 1; ++channel) {
            if (page.getBlock(channel).isNull(0)) continue;
            return false;
        }
        return true;
    }
}

