/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.spi.Message;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.server.ServerConfig;
import io.trino.server.protocol.spooling.SpoolingEnabledConfig;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.spool.SpoolingManager;
import io.trino.spi.spool.SpoolingManagerContext;
import io.trino.spi.spool.SpoolingManagerFactory;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class SpoolingManagerRegistry {
    private final Map<String, SpoolingManagerFactory> spoolingManagerFactories = new ConcurrentHashMap<String, SpoolingManagerFactory>();
    private static final Logger log = Logger.get(SpoolingManagerRegistry.class);
    static final File CONFIG_FILE = new File("etc/spooling-manager.properties");
    private static final String SPOOLING_MANAGER_NAME_PROPERTY = "spooling-manager.name";
    private final boolean enabled;
    private final boolean coordinator;
    private final OpenTelemetry openTelemetry;
    private final Tracer tracer;
    private volatile SpoolingManager spoolingManager;

    @Inject
    public SpoolingManagerRegistry(ServerConfig serverConfig, SpoolingEnabledConfig config, OpenTelemetry openTelemetry, Tracer tracer) {
        this.enabled = config.isEnabled();
        this.coordinator = serverConfig.isCoordinator();
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
    }

    public void addSpoolingManagerFactory(SpoolingManagerFactory factory) {
        Objects.requireNonNull(factory, "factory is null");
        if (this.spoolingManagerFactories.putIfAbsent(factory.getName(), factory) != null) {
            throw new IllegalArgumentException(String.format("Spooling manager factory '%s' is already registered", factory.getName()));
        }
    }

    public void loadSpoolingManager() {
        if (!this.enabled) {
            return;
        }
        if (!CONFIG_FILE.exists()) {
            throw new ConfigurationException(List.of(new Message("Spooling protocol is enabled, but manager configuration file does not exist: " + String.valueOf(CONFIG_FILE))));
        }
        Map<String, String> properties = SpoolingManagerRegistry.loadProperties();
        String name = properties.remove(SPOOLING_MANAGER_NAME_PROPERTY);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"Spooling manager configuration %s does not contain %s", (Object)CONFIG_FILE, (Object)SPOOLING_MANAGER_NAME_PROPERTY);
        this.loadSpoolingManager(name, properties);
    }

    public boolean isLoaded() {
        return this.spoolingManager != null;
    }

    public synchronized void loadSpoolingManager(String name, Map<String, String> properties) {
        SpoolingManagerFactory factory = this.spoolingManagerFactories.get(name);
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (String)"Spooling manager factory '%s' is not registered. Available factories: %s", (Object)name, this.spoolingManagerFactories.keySet());
        this.loadSpoolingManager(factory, properties);
    }

    public synchronized void loadSpoolingManager(SpoolingManagerFactory factory, Map<String, String> properties) {
        SpoolingManager spoolingManager;
        Objects.requireNonNull(factory, "factory is null");
        log.info("-- Loading spooling manager %s --", new Object[]{factory.getName()});
        Preconditions.checkState((this.spoolingManager == null ? 1 : 0) != 0, (Object)"spoolingManager is already loaded");
        SpoolingManagerContext context = new SpoolingManagerContext(){

            public OpenTelemetry getOpenTelemetry() {
                return SpoolingManagerRegistry.this.openTelemetry;
            }

            public Tracer getTracer() {
                return SpoolingManagerRegistry.this.tracer;
            }

            public boolean isCoordinator() {
                return SpoolingManagerRegistry.this.coordinator;
            }
        };
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            spoolingManager = factory.create(properties, context);
        }
        this.spoolingManager = spoolingManager;
        log.info("-- Loaded spooling manager %s --", new Object[]{factory.getName()});
    }

    public Optional<SpoolingManager> getSpoolingManager() {
        return Optional.ofNullable(this.spoolingManager);
    }

    private static Map<String, String> loadProperties() {
        try {
            return new HashMap<String, String>(ConfigurationLoader.loadPropertiesFrom((String)CONFIG_FILE.getPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read spooling manager configuration file: " + String.valueOf(CONFIG_FILE), e);
        }
    }
}

