/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.inject.Inject;
import io.airlift.slice.Slices;
import io.trino.server.security.ResourceSecurity;
import io.trino.spi.spool.SpooledSegmentHandle;
import io.trino.spi.spool.SpoolingManager;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

@Path(value="/v1/spooled/download/{identifier}")
@ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
public class WorkerSegmentResource {
    private final SpoolingManager spoolingManager;

    @Inject
    public WorkerSegmentResource(SpoolingManager spoolingManager) {
        this.spoolingManager = Objects.requireNonNull(spoolingManager, "spoolingManager is null");
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    public Response download(@PathParam(value="identifier") String identifier, @Context HttpHeaders headers) throws IOException {
        SpooledSegmentHandle handle = this.handle(identifier, headers);
        return Response.ok((Object)this.spoolingManager.openInputStream(handle)).build();
    }

    private SpooledSegmentHandle handle(String identifier, HttpHeaders headers) {
        return this.spoolingManager.handle(Slices.wrappedBuffer((byte[])identifier.getBytes(StandardCharsets.UTF_8)), (Map)headers.getRequestHeaders());
    }
}

