/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.airlift.jaxrs.AsyncResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.trino.dispatcher.DispatchExecutor;
import io.trino.server.AsyncResponseUtils;
import io.trino.server.ExternalUriInfo;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.security.oauth2.OAuth2Service;
import io.trino.server.security.oauth2.OAuth2TokenExchange;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@Path(value="/oauth2/token/")
public class OAuth2TokenExchangeResource {
    static final String TOKEN_ENDPOINT = "/oauth2/token/";
    private static final JsonCodec<Map<String, Object>> MAP_CODEC = new JsonCodecFactory().mapJsonCodec(String.class, Object.class);
    private final OAuth2TokenExchange tokenExchange;
    private final OAuth2Service service;
    private final Executor responseExecutor;
    private final ScheduledExecutorService timeoutExecutor;

    @Inject
    public OAuth2TokenExchangeResource(OAuth2TokenExchange tokenExchange, OAuth2Service service, DispatchExecutor executor) {
        this.tokenExchange = Objects.requireNonNull(tokenExchange, "tokenExchange is null");
        this.service = Objects.requireNonNull(service, "service is null");
        this.responseExecutor = executor.getExecutor();
        this.timeoutExecutor = executor.getScheduledExecutor();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @Path(value="initiate/{authIdHash}")
    @GET
    @Produces(value={"application/json"})
    public Response initiateTokenExchange(@PathParam(value="authIdHash") String authIdHash, @BeanParam ExternalUriInfo externalUriInfo) {
        return this.service.startOAuth2Challenge(externalUriInfo.absolutePath("/oauth2/callback"), Optional.ofNullable(authIdHash));
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @Path(value="{authId}")
    @GET
    @Produces(value={"application/json"})
    public void getAuthenticationToken(@PathParam(value="authId") UUID authId, @Suspended AsyncResponse asyncResponse, @Context HttpServletRequest request) {
        if (authId == null) {
            throw new BadRequestException();
        }
        ListenableFuture<OAuth2TokenExchange.TokenPoll> tokenFuture = this.tokenExchange.getTokenPoll(authId);
        ListenableFuture<Response> responseFuture = AsyncResponseUtils.withFallbackAfterTimeout(Futures.transform(tokenFuture, OAuth2TokenExchangeResource::toResponse, (Executor)MoreExecutors.directExecutor()), OAuth2TokenExchange.MAX_POLL_TIME, () -> OAuth2TokenExchangeResource.pendingResponse(request), this.timeoutExecutor);
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, responseFuture, (Executor)this.responseExecutor);
    }

    private static Response toResponse(OAuth2TokenExchange.TokenPoll poll) {
        if (poll.getError().isPresent()) {
            return Response.ok((Object)OAuth2TokenExchangeResource.jsonMap("error", poll.getError().get()), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        if (poll.getToken().isPresent()) {
            return Response.ok((Object)OAuth2TokenExchangeResource.jsonMap("token", poll.getToken().get()), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        throw new VerifyException("invalid TokenPoll state");
    }

    private static Response pendingResponse(HttpServletRequest request) {
        return Response.ok((Object)OAuth2TokenExchangeResource.jsonMap("nextUri", request.getRequestURL()), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @DELETE
    @Path(value="{authId}")
    public Response deleteAuthenticationToken(@PathParam(value="authId") UUID authId) {
        if (authId == null) {
            throw new BadRequestException();
        }
        this.tokenExchange.dropToken(authId);
        return Response.ok().build();
    }

    public static String getTokenUri(UUID authId) {
        return TOKEN_ENDPOINT + String.valueOf(authId);
    }

    public static String getInitiateUri(UUID authId) {
        return "/oauth2/token/initiate/" + OAuth2TokenExchange.hashAuthId(authId);
    }

    private static String jsonMap(String key, Object value) {
        return MAP_CODEC.toJson((Object)ImmutableMap.of((Object)key, (Object)value));
    }
}

