/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;

public class RemoveEmptyUnionBranches
implements Rule<UnionNode> {
    private static final Pattern<UnionNode> PATTERN = Patterns.union();

    @Override
    public Pattern<UnionNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(UnionNode node, Captures captures, Rule.Context context) {
        int emptyBranches = 0;
        ImmutableList.Builder newSourcesBuilder = ImmutableList.builder();
        ImmutableListMultimap.Builder outputsToInputsBuilder = ImmutableListMultimap.builder();
        for (int i = 0; i < node.getSources().size(); ++i) {
            PlanNode source = node.getSources().get(i);
            if (!QueryCardinalityUtil.isEmpty(source, context.getLookup())) {
                newSourcesBuilder.add((Object)source);
                for (Symbol column : node.getOutputSymbols()) {
                    outputsToInputsBuilder.put((Object)column, (Object)((Symbol)node.getSymbolMapping().get((Object)column).get(i)));
                }
                continue;
            }
            ++emptyBranches;
        }
        if (emptyBranches == 0) {
            return Rule.Result.empty();
        }
        if (emptyBranches == node.getSources().size()) {
            return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), node.getOutputSymbols()));
        }
        ImmutableList newSources = newSourcesBuilder.build();
        ImmutableListMultimap outputsToInputs = outputsToInputsBuilder.build();
        if (newSources.size() == 1) {
            Assignments.Builder assignments = Assignments.builder();
            outputsToInputs.entries().forEach(entry -> assignments.put((Symbol)entry.getKey(), ((Symbol)entry.getValue()).toSymbolReference()));
            return Rule.Result.ofPlanNode(new ProjectNode(node.getId(), (PlanNode)newSources.get(0), assignments.build()));
        }
        return Rule.Result.ofPlanNode(new UnionNode(node.getId(), (List<PlanNode>)newSources, (ListMultimap<Symbol, Symbol>)outputsToInputs, node.getOutputSymbols()));
    }
}

