/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.trino.connector.MockConnectorAccessControl;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorInsertTableHandle;
import io.trino.connector.MockConnectorMergeTableHandle;
import io.trino.connector.MockConnectorOutputTableHandle;
import io.trino.connector.MockConnectorPageSource;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.connector.MockConnectorTransactionHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.RefreshType;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class MockConnector
implements Connector {
    private static final String DELETE_ROW_ID = "delete_row_id";
    private static final String UPDATE_ROW_ID = "update_row_id";
    private static final String MERGE_ROW_ID = "merge_row_id";
    private final Function<ConnectorMetadata, ConnectorMetadata> metadataWrapper;
    private final Function<ConnectorSession, List<String>> listSchemaNames;
    private final BiFunction<ConnectorSession, String, List<String>> listTables;
    private final Optional<BiFunction<ConnectorSession, SchemaTablePrefix, Iterator<TableColumnsMetadata>>> streamTableColumns;
    private final Optional<MockConnectorFactory.StreamRelationColumns> streamRelationColumns;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews;
    private final Supplier<List<PropertyMetadata<?>>> getViewProperties;
    private final Supplier<List<PropertyMetadata<?>>> getMaterializedViewProperties;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorMaterializedViewDefinition>> getMaterializedViews;
    private final BiFunction<ConnectorSession, SchemaTableName, Boolean> delegateMaterializedViewRefreshToConnector;
    private final BiFunction<ConnectorSession, SchemaTableName, CompletableFuture<?>> refreshMaterializedView;
    private final BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle;
    private final Function<SchemaTableName, List<ColumnMetadata>> getColumns;
    private final Function<SchemaTableName, Optional<String>> getComment;
    private final Function<SchemaTableName, TableStatistics> getTableStatistics;
    private final Function<SchemaTableName, List<String>> checkConstraints;
    private final MockConnectorFactory.ApplyProjection applyProjection;
    private final MockConnectorFactory.ApplyAggregation applyAggregation;
    private final MockConnectorFactory.ApplyJoin applyJoin;
    private final MockConnectorFactory.ApplyTopN applyTopN;
    private final MockConnectorFactory.ApplyFilter applyFilter;
    private final MockConnectorFactory.ApplyTableFunction applyTableFunction;
    private final MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect;
    private final BiFunction<ConnectorSession, SchemaTableName, Optional<CatalogSchemaTableName>> redirectTable;
    private final BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorTableLayout>> getInsertLayout;
    private final BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorTableLayout>> getNewTableLayout;
    private final BiFunction<ConnectorSession, Type, Optional<Type>> getSupportedType;
    private final BiFunction<ConnectorSession, ConnectorTableHandle, ConnectorTableProperties> getTableProperties;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, List<GrantInfo>> listTablePrivileges;
    private final Collection<FunctionMetadata> functions;
    private final MockConnectorFactory.ListRoleGrants roleGrants;
    private final Optional<ConnectorNodePartitioningProvider> partitioningProvider;
    private final Optional<ConnectorAccessControl> accessControl;
    private final Function<SchemaTableName, List<List<?>>> data;
    private final Function<SchemaTableName, Metrics> metrics;
    private final Set<Procedure> procedures;
    private final Set<TableProcedureMetadata> tableProcedures;
    private final Set<ConnectorTableFunction> tableFunctions;
    private final Optional<FunctionProvider> functionProvider;
    private final boolean allowMissingColumnsOnInsert;
    private final Supplier<List<PropertyMetadata<?>>> analyzeProperties;
    private final Supplier<List<PropertyMetadata<?>>> schemaProperties;
    private final Supplier<List<PropertyMetadata<?>>> tableProperties;
    private final Supplier<List<PropertyMetadata<?>>> columnProperties;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final Function<ConnectorTableFunctionHandle, ConnectorSplitSource> tableFunctionSplitsSources;
    private final OptionalInt maxWriterTasks;
    private final BiFunction<ConnectorSession, ConnectorTableExecuteHandle, Optional<ConnectorTableLayout>> getLayoutForTableExecute;
    private final WriterScalingOptions writerScalingOptions;
    private final Supplier<Set<ConnectorCapabilities>> capabilities;
    private final boolean allowSplittingReadIntoMultipleSubQueries;

    MockConnector(Function<ConnectorMetadata, ConnectorMetadata> metadataWrapper, List<PropertyMetadata<?>> sessionProperties, Function<ConnectorSession, List<String>> listSchemaNames, BiFunction<ConnectorSession, String, List<String>> listTables, Optional<BiFunction<ConnectorSession, SchemaTablePrefix, Iterator<TableColumnsMetadata>>> streamTableColumns, Optional<MockConnectorFactory.StreamRelationColumns> streamRelationColumns, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews, Supplier<List<PropertyMetadata<?>>> getViewProperties, Supplier<List<PropertyMetadata<?>>> getMaterializedViewProperties, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorMaterializedViewDefinition>> getMaterializedViews, BiFunction<ConnectorSession, SchemaTableName, Boolean> delegateMaterializedViewRefreshToConnector, BiFunction<ConnectorSession, SchemaTableName, CompletableFuture<?>> refreshMaterializedView, BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle, Function<SchemaTableName, List<ColumnMetadata>> getColumns, Function<SchemaTableName, Optional<String>> getComment, Function<SchemaTableName, TableStatistics> getTableStatistics, Function<SchemaTableName, List<String>> checkConstraints, MockConnectorFactory.ApplyProjection applyProjection, MockConnectorFactory.ApplyAggregation applyAggregation, MockConnectorFactory.ApplyJoin applyJoin, MockConnectorFactory.ApplyTopN applyTopN, MockConnectorFactory.ApplyFilter applyFilter, MockConnectorFactory.ApplyTableFunction applyTableFunction, MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect, BiFunction<ConnectorSession, SchemaTableName, Optional<CatalogSchemaTableName>> redirectTable, BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorTableLayout>> getInsertLayout, BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorTableLayout>> getNewTableLayout, BiFunction<ConnectorSession, Type, Optional<Type>> getSupportedType, BiFunction<ConnectorSession, ConnectorTableHandle, ConnectorTableProperties> getTableProperties, BiFunction<ConnectorSession, SchemaTablePrefix, List<GrantInfo>> listTablePrivileges, Collection<FunctionMetadata> functions, MockConnectorFactory.ListRoleGrants roleGrants, Optional<ConnectorNodePartitioningProvider> partitioningProvider, Optional<ConnectorAccessControl> accessControl, Function<SchemaTableName, List<List<?>>> data, Function<SchemaTableName, Metrics> metrics, Set<Procedure> procedures, Set<TableProcedureMetadata> tableProcedures, Set<ConnectorTableFunction> tableFunctions, Optional<FunctionProvider> functionProvider, boolean allowMissingColumnsOnInsert, Supplier<List<PropertyMetadata<?>>> analyzeProperties, Supplier<List<PropertyMetadata<?>>> schemaProperties, Supplier<List<PropertyMetadata<?>>> tableProperties, Supplier<List<PropertyMetadata<?>>> columnProperties, Function<ConnectorTableFunctionHandle, ConnectorSplitSource> tableFunctionSplitsSources, OptionalInt maxWriterTasks, BiFunction<ConnectorSession, ConnectorTableExecuteHandle, Optional<ConnectorTableLayout>> getLayoutForTableExecute, WriterScalingOptions writerScalingOptions, Supplier<Set<ConnectorCapabilities>> capabilities, boolean allowSplittingReadIntoMultipleSubQueries) {
        this.metadataWrapper = Objects.requireNonNull(metadataWrapper, "metadataWrapper is null");
        this.sessionProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(sessionProperties, "sessionProperties is null"));
        this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
        this.listTables = Objects.requireNonNull(listTables, "listTables is null");
        this.streamTableColumns = Objects.requireNonNull(streamTableColumns, "streamTableColumns is null");
        this.streamRelationColumns = Objects.requireNonNull(streamRelationColumns, "streamRelationColumns is null");
        this.getViews = Objects.requireNonNull(getViews, "getViews is null");
        this.getViewProperties = Objects.requireNonNull(getViewProperties, "getViewProperties is null");
        this.getMaterializedViewProperties = Objects.requireNonNull(getMaterializedViewProperties, "getMaterializedViewProperties is null");
        this.getMaterializedViews = Objects.requireNonNull(getMaterializedViews, "getMaterializedViews is null");
        this.delegateMaterializedViewRefreshToConnector = Objects.requireNonNull(delegateMaterializedViewRefreshToConnector, "delegateMaterializedViewRefreshToConnector is null");
        this.refreshMaterializedView = Objects.requireNonNull(refreshMaterializedView, "refreshMaterializedView is null");
        this.getTableHandle = Objects.requireNonNull(getTableHandle, "getTableHandle is null");
        this.getColumns = Objects.requireNonNull(getColumns, "getColumns is null");
        this.getComment = Objects.requireNonNull(getComment, "getComment is null");
        this.getTableStatistics = Objects.requireNonNull(getTableStatistics, "getTableStatistics is null");
        this.checkConstraints = Objects.requireNonNull(checkConstraints, "checkConstraints is null");
        this.applyProjection = Objects.requireNonNull(applyProjection, "applyProjection is null");
        this.applyAggregation = Objects.requireNonNull(applyAggregation, "applyAggregation is null");
        this.applyJoin = Objects.requireNonNull(applyJoin, "applyJoin is null");
        this.applyTopN = Objects.requireNonNull(applyTopN, "applyTopN is null");
        this.applyFilter = Objects.requireNonNull(applyFilter, "applyFilter is null");
        this.applyTableFunction = Objects.requireNonNull(applyTableFunction, "applyTableFunction is null");
        this.applyTableScanRedirect = Objects.requireNonNull(applyTableScanRedirect, "applyTableScanRedirection is null");
        this.redirectTable = Objects.requireNonNull(redirectTable, "redirectTable is null");
        this.getInsertLayout = Objects.requireNonNull(getInsertLayout, "getInsertLayout is null");
        this.getNewTableLayout = Objects.requireNonNull(getNewTableLayout, "getNewTableLayout is null");
        this.getSupportedType = Objects.requireNonNull(getSupportedType, "getSupportedType is null");
        this.getTableProperties = Objects.requireNonNull(getTableProperties, "getTableProperties is null");
        this.listTablePrivileges = Objects.requireNonNull(listTablePrivileges, "listTablePrivileges is null");
        this.functions = ImmutableList.copyOf(functions);
        this.roleGrants = Objects.requireNonNull(roleGrants, "roleGrants is null");
        this.partitioningProvider = Objects.requireNonNull(partitioningProvider, "partitioningProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.data = Objects.requireNonNull(data, "data is null");
        this.metrics = Objects.requireNonNull(metrics, "metrics is null");
        this.procedures = Objects.requireNonNull(procedures, "procedures is null");
        this.tableProcedures = Objects.requireNonNull(tableProcedures, "tableProcedures is null");
        this.tableFunctions = Objects.requireNonNull(tableFunctions, "tableFunctions is null");
        this.functionProvider = Objects.requireNonNull(functionProvider, "functionProvider is null");
        this.allowMissingColumnsOnInsert = allowMissingColumnsOnInsert;
        this.analyzeProperties = Objects.requireNonNull(analyzeProperties, "analyzeProperties is null");
        this.schemaProperties = Objects.requireNonNull(schemaProperties, "schemaProperties is null");
        this.tableProperties = Objects.requireNonNull(tableProperties, "tableProperties is null");
        this.columnProperties = Objects.requireNonNull(columnProperties, "columnProperties is null");
        this.tableFunctionSplitsSources = Objects.requireNonNull(tableFunctionSplitsSources, "tableFunctionSplitsSources is null");
        this.maxWriterTasks = Objects.requireNonNull(maxWriterTasks, "maxWriterTasks is null");
        this.getLayoutForTableExecute = Objects.requireNonNull(getLayoutForTableExecute, "getLayoutForTableExecute is null");
        this.writerScalingOptions = Objects.requireNonNull(writerScalingOptions, "writerScalingOptions is null");
        this.capabilities = Objects.requireNonNull(capabilities, "capabilities is null");
        this.allowSplittingReadIntoMultipleSubQueries = allowSplittingReadIntoMultipleSubQueries;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return MockConnectorTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
        return this.metadataWrapper.apply(new MockConnectorMetadata());
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return new MockConnectorPageSourceProvider();
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return new MockPageSinkProvider();
    }

    public ConnectorSplitManager getSplitManager() {
        return new ConnectorSplitManager(){

            public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
                return new FixedSplitSource((ConnectorSplit)MockConnectorSplit.MOCK_CONNECTOR_SPLIT);
            }

            public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableFunctionHandle functionHandle) {
                ConnectorSplitSource splits = MockConnector.this.tableFunctionSplitsSources.apply(functionHandle);
                return Objects.requireNonNull(splits, "missing ConnectorSplitSource for table function handle " + functionHandle.getClass().getSimpleName());
            }
        };
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.partitioningProvider.orElseThrow(UnsupportedOperationException::new);
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl.orElseThrow(UnsupportedOperationException::new);
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    public Set<TableProcedureMetadata> getTableProcedures() {
        return this.tableProcedures;
    }

    public Set<ConnectorTableFunction> getTableFunctions() {
        return this.tableFunctions;
    }

    public Optional<FunctionProvider> getFunctionProvider() {
        return this.functionProvider;
    }

    public List<PropertyMetadata<?>> getSchemaProperties() {
        return this.schemaProperties.get();
    }

    public List<PropertyMetadata<?>> getAnalyzeProperties() {
        return this.analyzeProperties.get();
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties.get();
    }

    public List<PropertyMetadata<?>> getViewProperties() {
        return this.getViewProperties.get();
    }

    public List<PropertyMetadata<?>> getMaterializedViewProperties() {
        return this.getMaterializedViewProperties.get();
    }

    public List<PropertyMetadata<?>> getColumnProperties() {
        return this.columnProperties.get();
    }

    public Set<ConnectorCapabilities> getCapabilities() {
        return this.capabilities.get();
    }

    private class MockConnectorMetadata
    implements ConnectorMetadata {
        private MockConnectorMetadata() {
        }

        public boolean schemaExists(ConnectorSession session, String schemaName) {
            return MockConnector.this.listSchemaNames.apply(session).contains(schemaName);
        }

        public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
            return MockConnector.this.applyProjection.apply(session, handle, projections, assignments);
        }

        public Optional<AggregationApplicationResult<ConnectorTableHandle>> applyAggregation(ConnectorSession session, ConnectorTableHandle handle, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
            return MockConnector.this.applyAggregation.apply(session, handle, aggregates, assignments, groupingSets);
        }

        public Optional<JoinApplicationResult<ConnectorTableHandle>> applyJoin(ConnectorSession session, JoinType joinType, ConnectorTableHandle left, ConnectorTableHandle right, List<JoinCondition> joinConditions, Map<String, ColumnHandle> leftAssignments, Map<String, ColumnHandle> rightAssignments, JoinStatistics statistics) {
            return MockConnector.this.applyJoin.apply(session, joinType, left, right, joinConditions, leftAssignments, rightAssignments);
        }

        public Optional<TopNApplicationResult<ConnectorTableHandle>> applyTopN(ConnectorSession session, ConnectorTableHandle handle, long topNCount, List<SortItem> sortItems, Map<String, ColumnHandle> assignments) {
            return MockConnector.this.applyTopN.apply(session, handle, topNCount, sortItems, assignments);
        }

        public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
            return MockConnector.this.applyFilter.apply(session, handle, constraint);
        }

        public Optional<TableFunctionApplicationResult<ConnectorTableHandle>> applyTableFunction(ConnectorSession session, ConnectorTableFunctionHandle handle) {
            return MockConnector.this.applyTableFunction.apply(session, handle);
        }

        public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(ConnectorSession session, ConnectorTableHandle tableHandle) {
            return MockConnector.this.applyTableScanRedirect.apply(session, tableHandle);
        }

        public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName schemaTableName) {
            return MockConnector.this.redirectTable.apply(session, schemaTableName);
        }

        public List<String> listSchemaNames(ConnectorSession session) {
            return MockConnector.this.listSchemaNames.apply(session);
        }

        public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        }

        public void renameSchema(ConnectorSession session, String source, String target) {
        }

        public void setSchemaAuthorization(ConnectorSession session, String schemaName, TrinoPrincipal principal) {
        }

        public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        }

        public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
            if (startVersion.isPresent() || endVersion.isPresent()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
            }
            return MockConnector.this.getTableHandle.apply(session, tableName);
        }

        public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
            MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
            return new ConnectorTableMetadata(table.getTableName(), MockConnector.this.getColumns.apply(table.getTableName()), (Map)ImmutableMap.of(), MockConnector.this.getComment.apply(table.getTableName()), MockConnector.this.checkConstraints.apply(table.getTableName()));
        }

        public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle) {
            MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
            return MockConnector.this.getTableStatistics.apply(table.getTableName());
        }

        public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
            if (schemaName.isPresent()) {
                String schema = schemaName.get();
                return (List)MockConnector.this.listTables.apply(session, schema).stream().map(tableName -> new SchemaTableName(schema, tableName)).collect(ImmutableList.toImmutableList());
            }
            ImmutableList.Builder tableNames = ImmutableList.builder();
            for (String schema : this.listSchemaNames(session)) {
                tableNames.addAll((Iterable)MockConnector.this.listTables.apply(session, schema).stream().map(tableName -> new SchemaTableName(schema, tableName)).collect(ImmutableList.toImmutableList()));
            }
            return tableNames.build();
        }

        public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
            MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
            return (Map)MockConnector.this.getColumns.apply(table.getTableName()).stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> new MockConnectorColumnHandle(column.getName(), column.getType())));
        }

        public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
            MockConnectorColumnHandle mockColumnHandle = (MockConnectorColumnHandle)columnHandle;
            return new ColumnMetadata(mockColumnHandle.getName(), mockColumnHandle.getType());
        }

        public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
            throw new UnsupportedOperationException("The deprecated listTableColumns is not supported because streamTableColumns is implemented instead");
        }

        public Iterator<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
            if (MockConnector.this.streamTableColumns.isPresent()) {
                return MockConnector.this.streamTableColumns.get().apply(session, prefix);
            }
            return this.listTables(session, prefix.getSchema()).stream().filter(arg_0 -> ((SchemaTablePrefix)prefix).matches(arg_0)).map(name -> TableColumnsMetadata.forTable((SchemaTableName)name, MockConnector.this.getColumns.apply((SchemaTableName)name))).iterator();
        }

        public Iterator<RelationColumnsMetadata> streamRelationColumns(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
            if (MockConnector.this.streamRelationColumns.isPresent()) {
                return MockConnector.this.streamRelationColumns.get().apply(session, schemaName, relationFilter);
            }
            return super.streamRelationColumns(session, schemaName, relationFilter);
        }

        public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        }

        public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        }

        public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        }

        public void setTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Optional<Object>> properties) {
        }

        public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        }

        public void setViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        }

        public void setViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        }

        public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        }

        public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        }

        public void setColumnType(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Type type) {
        }

        public void setFieldType(ConnectorSession session, ConnectorTableHandle tableHandle, List<String> fieldPath, Type type) {
            throw new UnsupportedOperationException();
        }

        public void dropNotNullConstraint(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
            throw new UnsupportedOperationException();
        }

        public void setTableAuthorization(ConnectorSession session, SchemaTableName tableName, TrinoPrincipal principal) {
        }

        public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        }

        public void renameField(ConnectorSession session, ConnectorTableHandle tableHandle, List<String> fieldPath, String target) {
            throw new UnsupportedOperationException();
        }

        public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        }

        public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, Map<String, Object> viewProperties, boolean replace) {
        }

        public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        }

        public void setViewAuthorization(ConnectorSession session, SchemaTableName viewName, TrinoPrincipal principal) {
        }

        public void dropView(ConnectorSession session, SchemaTableName viewName) {
        }

        public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> properties, boolean replace, boolean ignoreExisting) {
        }

        public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
            return ImmutableList.copyOf(MockConnector.this.getMaterializedViews.apply(session, schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new)).keySet());
        }

        public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
            return Optional.ofNullable(MockConnector.this.getMaterializedViews.apply(session, viewName.toSchemaTablePrefix()).get(viewName));
        }

        public Map<String, Object> getMaterializedViewProperties(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition materializedViewDefinition) {
            return ImmutableMap.of();
        }

        public MaterializedViewFreshness getMaterializedViewFreshness(ConnectorSession session, SchemaTableName viewName) {
            ConnectorMaterializedViewDefinition view = MockConnector.this.getMaterializedViews.apply(session, viewName.toSchemaTablePrefix()).get(viewName);
            Preconditions.checkArgument((view != null ? 1 : 0) != 0, (String)"Materialized view %s does not exist", (Object)viewName);
            return new MaterializedViewFreshness(view.getStorageTable().isPresent() ? MaterializedViewFreshness.Freshness.FRESH : MaterializedViewFreshness.Freshness.STALE, Optional.empty());
        }

        public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        }

        public boolean delegateMaterializedViewRefreshToConnector(ConnectorSession session, SchemaTableName viewName) {
            return MockConnector.this.delegateMaterializedViewRefreshToConnector.apply(session, viewName);
        }

        public CompletableFuture<?> refreshMaterializedView(ConnectorSession session, SchemaTableName viewName) {
            return MockConnector.this.refreshMaterializedView.apply(session, viewName);
        }

        public ConnectorInsertTableHandle beginRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorTableHandle> sourceTableHandles, RetryMode retryMode, RefreshType refreshType) {
            return new MockConnectorInsertTableHandle(((MockConnectorTableHandle)tableHandle).getTableName());
        }

        public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<ConnectorTableHandle> sourceTableHandles, List<String> sourceTableFunctions) {
            return Optional.empty();
        }

        public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        }

        public void setMaterializedViewProperties(ConnectorSession session, SchemaTableName viewName, Map<String, Optional<Object>> properties) {
        }

        public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
            return MockConnector.this.getViews.apply(session, schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new));
        }

        public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
            return Optional.ofNullable(MockConnector.this.getViews.apply(session, viewName.toSchemaTablePrefix()).get(viewName));
        }

        public Map<String, Object> getViewProperties(ConnectorSession session, SchemaTableName viewName) {
            return (Map)MockConnector.this.getViewProperties.get().stream().collect(ImmutableMap.toImmutableMap(PropertyMetadata::getName, PropertyMetadata::getDefaultValue));
        }

        public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
            return new MockConnectorInsertTableHandle(((MockConnectorTableHandle)tableHandle).getTableName());
        }

        public boolean supportsMissingColumnsOnInsert() {
            return MockConnector.this.allowMissingColumnsOnInsert;
        }

        public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
            return Optional.empty();
        }

        public Optional<ConnectorTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
            MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
            return MockConnector.this.getInsertLayout.apply(session, table.getTableName());
        }

        public Optional<ConnectorTableLayout> getLayoutForTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
            return MockConnector.this.getLayoutForTableExecute.apply(session, tableExecuteHandle);
        }

        public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode, boolean replace) {
            return new MockConnectorOutputTableHandle(tableMetadata.getTable());
        }

        public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
            return Optional.empty();
        }

        public Optional<ConnectorTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
            return MockConnector.this.getNewTableLayout.apply(session, tableMetadata);
        }

        public Optional<Type> getSupportedType(ConnectorSession session, Map<String, Object> tableProperties, Type type) {
            return MockConnector.this.getSupportedType.apply(session, type);
        }

        public RowChangeParadigm getRowChangeParadigm(ConnectorSession session, ConnectorTableHandle tableHandle) {
            return RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW;
        }

        public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
            return new MockConnectorColumnHandle(MockConnector.MERGE_ROW_ID, (Type)BigintType.BIGINT);
        }

        public ConnectorMergeTableHandle beginMerge(ConnectorSession session, ConnectorTableHandle tableHandle, Map<Integer, Collection<ColumnHandle>> updateCaseColumns, RetryMode retryMode) {
            return new MockConnectorMergeTableHandle((MockConnectorTableHandle)tableHandle);
        }

        public void finishMerge(ConnectorSession session, ConnectorMergeTableHandle mergeTableHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        }

        public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
            return MockConnector.this.getTableProperties.apply(session, table);
        }

        public Optional<ConnectorTableExecuteHandle> getTableHandleForExecute(ConnectorSession session, ConnectorAccessControl accessControl, ConnectorTableHandle tableHandle, String procedureName, Map<String, Object> executeProperties, RetryMode retryMode) {
            MockConnectorTableHandle connectorTableHandle = (MockConnectorTableHandle)tableHandle;
            return Optional.of(new MockConnectorTableExecuteHandle(0, connectorTableHandle.getTableName()));
        }

        public void executeTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        }

        public void finishTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> tableExecuteState) {
        }

        public Collection<FunctionMetadata> listFunctions(ConnectorSession session, String schemaName) {
            return MockConnector.this.functions;
        }

        public Collection<FunctionMetadata> getFunctions(ConnectorSession session, SchemaFunctionName name) {
            return (Collection)MockConnector.this.functions.stream().filter(function -> function.getNames().contains(name.getFunctionName())).collect(ImmutableList.toImmutableList());
        }

        public FunctionMetadata getFunctionMetadata(ConnectorSession session, FunctionId functionId) {
            return MockConnector.this.functions.stream().filter(function -> function.getFunctionId().equals((Object)functionId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Function not found: " + String.valueOf(functionId)));
        }

        public FunctionDependencyDeclaration getFunctionDependencies(ConnectorSession session, FunctionId functionId, BoundSignature boundSignature) {
            return FunctionDependencyDeclaration.NO_DEPENDENCIES;
        }

        public Set<String> listRoles(ConnectorSession session) {
            return (Set)MockConnector.this.roleGrants.apply(session, Optional.empty(), Optional.empty(), OptionalLong.empty()).stream().map(RoleGrant::getRoleName).collect(ImmutableSet.toImmutableSet());
        }

        public Set<RoleGrant> listRoleGrants(ConnectorSession session, TrinoPrincipal principal) {
            return (Set)MockConnector.this.roleGrants.apply(session, Optional.empty(), Optional.empty(), OptionalLong.empty()).stream().filter(grant -> grant.getGrantee().equals((Object)principal)).collect(ImmutableSet.toImmutableSet());
        }

        public Set<RoleGrant> listApplicableRoles(ConnectorSession session, TrinoPrincipal principal) {
            return this.listRoleGrants(session, principal);
        }

        public Set<String> listEnabledRoles(ConnectorSession session) {
            return this.listRoles(session);
        }

        public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix prefix) {
            return MockConnector.this.listTablePrivileges.apply(session, prefix);
        }

        public void grantSchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
            this.getMockAccessControl().grantSchemaPrivileges(schemaName, privileges, grantee, grantOption);
        }

        public void revokeSchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, TrinoPrincipal revokee, boolean grantOption) {
            this.getMockAccessControl().revokeSchemaPrivileges(schemaName, privileges, revokee, grantOption);
        }

        public void grantTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
            this.getMockAccessControl().grantTablePrivileges(tableName, privileges, grantee, grantOption);
        }

        public void revokeTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, TrinoPrincipal revokee, boolean grantOption) {
            this.getMockAccessControl().revokeTablePrivileges(tableName, privileges, revokee, grantOption);
        }

        public OptionalInt getMaxWriterTasks(ConnectorSession session) {
            return MockConnector.this.maxWriterTasks;
        }

        public boolean allowSplittingReadIntoMultipleSubQueries(ConnectorSession session, ConnectorTableHandle tableHandle) {
            return MockConnector.this.allowSplittingReadIntoMultipleSubQueries;
        }

        public BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorTableHandle updatedSourceTableHandle) {
            return new BeginTableExecuteResult((Object)tableExecuteHandle, (Object)updatedSourceTableHandle);
        }

        public WriterScalingOptions getNewTableWriterScalingOptions(ConnectorSession session, SchemaTableName tableName, Map<String, Object> tableProperties) {
            return MockConnector.this.writerScalingOptions;
        }

        public WriterScalingOptions getInsertWriterScalingOptions(ConnectorSession session, ConnectorTableHandle tableHandle) {
            return MockConnector.this.writerScalingOptions;
        }

        private MockConnectorAccessControl getMockAccessControl() {
            return (MockConnectorAccessControl)MockConnector.this.getAccessControl();
        }
    }

    private class MockConnectorPageSourceProvider
    implements ConnectorPageSourceProvider {
        private MockConnectorPageSourceProvider() {
        }

        public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
            MockConnectorTableHandle handle = (MockConnectorTableHandle)table;
            SchemaTableName tableName = handle.getTableName();
            List projection = (List)columns.stream().map(MockConnectorColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
            List types = (List)columns.stream().map(MockConnectorColumnHandle.class::cast).map(MockConnectorColumnHandle::getType).collect(ImmutableList.toImmutableList());
            Map<String, Integer> columnIndexes = this.getColumnIndexes(tableName);
            List records = (List)MockConnector.this.data.apply(tableName).stream().map(record -> {
                ImmutableList.Builder projectedRow = ImmutableList.builder();
                for (MockConnectorColumnHandle column : projection) {
                    String columnName = column.getName();
                    if (columnName.equals(MockConnector.DELETE_ROW_ID) || columnName.equals(MockConnector.UPDATE_ROW_ID) || columnName.equals(MockConnector.MERGE_ROW_ID)) {
                        projectedRow.add((Object)0);
                        continue;
                    }
                    Integer index = (Integer)columnIndexes.get(columnName);
                    Objects.requireNonNull(index, "index is null");
                    projectedRow.add(record.get(index));
                }
                return projectedRow.build();
            }).collect(ImmutableList.toImmutableList());
            return new MockConnectorPageSource((ConnectorPageSource)new RecordPageSource((RecordSet)new InMemoryRecordSet((Collection)types, (Iterable)records)), MockConnector.this.metrics.apply(tableName));
        }

        private Map<String, Integer> getColumnIndexes(SchemaTableName tableName) {
            ImmutableMap.Builder columnIndexes = ImmutableMap.builder();
            List<ColumnMetadata> columnMetadata = MockConnector.this.getColumns.apply(tableName);
            for (int index = 0; index < columnMetadata.size(); ++index) {
                columnIndexes.put((Object)columnMetadata.get(index).getName(), (Object)index);
            }
            return columnIndexes.buildOrThrow();
        }
    }

    private static class MockPageSinkProvider
    implements ConnectorPageSinkProvider {
        private MockPageSinkProvider() {
        }

        public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, ConnectorPageSinkId pageSinkId) {
            return new MockPageSink();
        }

        public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, ConnectorPageSinkId pageSinkId) {
            return new MockPageSink();
        }

        public ConnectorMergeSink createMergeSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorMergeTableHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
            return new MockPageSink();
        }
    }

    public static class MockConnectorTableExecuteHandle
    implements ConnectorTableExecuteHandle {
        private final int someFieldForSerializer;
        private final SchemaTableName schemaTableName;

        @JsonCreator
        public MockConnectorTableExecuteHandle(int someFieldForSerializer, SchemaTableName schemaTableName) {
            this.someFieldForSerializer = someFieldForSerializer;
            this.schemaTableName = schemaTableName;
        }

        @JsonProperty
        public int getSomeFieldForSerializer() {
            return this.someFieldForSerializer;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }
    }

    public static enum MockConnectorSplit implements ConnectorSplit
    {
        MOCK_CONNECTOR_SPLIT;


        public Map<String, String> getSplitInfo() {
            return ImmutableMap.of((Object)"info", (Object)"mock connector split");
        }

        public long getRetainedSizeInBytes() {
            return 0L;
        }
    }

    private static class MockPageSink
    implements ConnectorPageSink,
    ConnectorMergeSink {
        private MockPageSink() {
        }

        public CompletableFuture<?> appendPage(Page page) {
            return NOT_BLOCKED;
        }

        public void storeMergedRows(Page page) {
        }

        public CompletableFuture<Collection<Slice>> finish() {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }

        public void abort() {
        }
    }
}

