/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.type.UnknownType;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestSortStatsRule
extends BaseStatsCalculatorTest {
    @Test
    public void testStatsForSortNode() {
        PlanNodeStatsEstimate stats = PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "a"), SymbolStatsEstimate.builder().setNullsFraction(0.3).setLowValue(1.0).setHighValue(30.0).setDistinctValuesCount(20.0).build()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "b"), SymbolStatsEstimate.builder().setNullsFraction(0.6).setLowValue(13.5).setHighValue(Double.POSITIVE_INFINITY).setDistinctValuesCount(40.0).build()).build();
        this.tester().assertStatsFor(pb -> {
            Symbol a = pb.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = pb.symbol("b", (Type)DoubleType.DOUBLE);
            return pb.sort(List.of(b), (PlanNode)pb.values(a, b));
        }).withSourceStats(stats).check(outputStats -> outputStats.equalTo(stats));
    }
}

