/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.secrets.SecretsResolver;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.CommitTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.TestMetadataManager;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.AccessControlManager;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.tree.Commit;
import io.trino.sql.tree.NodeLocation;
import io.trino.testing.TestingEventListenerManager;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestCommitTask {
    private final Metadata metadata = TestMetadataManager.createTestMetadataManager();
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testCommit() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestCommitTask.sessionBuilder().setTransactionId(transactionManager.beginTransaction(false)).build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("COMMIT", session, transactionManager);
        Assertions.assertThat((Optional)stateMachine.getSession().getTransactionId()).isPresent();
        Assertions.assertThat((List)transactionManager.getAllTransactionInfos()).hasSize(1);
        MoreFutures.getFutureValue((Future)new CommitTask(transactionManager).execute(new Commit(new NodeLocation(1, 1)), stateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assertions.assertThat((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId()).isTrue();
        Assertions.assertThat((Optional)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId()).isEmpty();
        Assertions.assertThat((List)transactionManager.getAllTransactionInfos()).isEmpty();
    }

    @Test
    public void testNoTransactionCommit() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestCommitTask.sessionBuilder().build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("COMMIT", session, transactionManager);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new CommitTask(transactionManager).execute(new Commit(new NodeLocation(1, 1)), stateMachine, Collections.emptyList(), WarningCollector.NOOP))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_IN_TRANSACTION});
        Assertions.assertThat((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId()).isFalse();
        Assertions.assertThat((Optional)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId()).isEmpty();
        Assertions.assertThat((List)transactionManager.getAllTransactionInfos()).isEmpty();
    }

    @Test
    public void testUnknownTransactionCommit() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestCommitTask.sessionBuilder().setTransactionId(TransactionId.create()).build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("COMMIT", session, transactionManager);
        ListenableFuture future = new CommitTask(transactionManager).execute(new Commit(new NodeLocation(1, 1)), stateMachine, Collections.emptyList(), WarningCollector.NOOP);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestCommitTask.lambda$testUnknownTransactionCommit$1((Future)future)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.UNKNOWN_TRANSACTION});
        Assertions.assertThat((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId()).isTrue();
        Assertions.assertThat((Optional)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId()).isEmpty();
        Assertions.assertThat((List)transactionManager.getAllTransactionInfos()).isEmpty();
    }

    private QueryStateMachine createQueryStateMachine(String query, Session session, TransactionManager transactionManager) {
        return QueryStateMachine.begin(Optional.empty(), (String)query, Optional.empty(), (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)true, (TransactionManager)transactionManager, (AccessControl)new AccessControlManager(NodeVersion.UNKNOWN, transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig(), OpenTelemetry.noop(), new SecretsResolver((Map)ImmutableMap.of()), "default"), (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, Optional.empty(), (NodeVersion)new NodeVersion("test"));
    }

    private static Session.SessionBuilder sessionBuilder() {
        return TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny");
    }

    private static /* synthetic */ void lambda$testUnknownTransactionCommit$1(Future future) throws Throwable {
        MoreFutures.getFutureValue((Future)future);
    }
}

