/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.ResetSessionTask;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.SessionPropertyManager;
import io.trino.security.AccessControl;
import io.trino.spi.Plugin;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.session.PropertyMetadata;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.ResetSession;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestResetSessionTask {
    private static final String CATALOG_NAME = "my_catalog";
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    private QueryRunner queryRunner;
    private TransactionManager transactionManager;
    private AccessControl accessControl;
    private Metadata metadata;
    private SessionPropertyManager sessionPropertyManager;

    @BeforeAll
    public void setUp() {
        this.queryRunner = new StandaloneQueryRunner(SessionTestUtils.TEST_SESSION);
        this.queryRunner.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withSessionProperty(PropertyMetadata.stringProperty((String)"baz", (String)"test property", null, (boolean)false)).build()));
        this.queryRunner.createCatalog(CATALOG_NAME, "mock", (Map)ImmutableMap.of());
        this.transactionManager = this.queryRunner.getTransactionManager();
        this.accessControl = this.queryRunner.getAccessControl();
        this.metadata = this.queryRunner.getPlannerContext().getMetadata();
        this.sessionPropertyManager = this.queryRunner.getSessionPropertyManager();
    }

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.queryRunner.close();
        this.queryRunner = null;
        this.transactionManager = null;
        this.accessControl = null;
        this.metadata = null;
        this.sessionPropertyManager = null;
    }

    @Test
    public void test() {
        Session session = TestingSession.testSessionBuilder((SessionPropertyManager)this.sessionPropertyManager).setCatalogSessionProperty(CATALOG_NAME, "baz", "blah").build();
        QueryStateMachine stateMachine = QueryStateMachine.begin(Optional.empty(), (String)"reset foo", Optional.empty(), (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, Optional.empty(), (NodeVersion)new NodeVersion("test"));
        MoreFutures.getFutureValue((Future)new ResetSessionTask(this.metadata, this.sessionPropertyManager).execute(new ResetSession(new NodeLocation(1, 1), QualifiedName.of((String)CATALOG_NAME, (String[])new String[]{"baz"})), stateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Set sessionProperties = stateMachine.getResetSessionProperties();
        Assertions.assertThat((Collection)sessionProperties).isEqualTo((Object)ImmutableSet.of((Object)"my_catalog.baz"));
    }
}

