/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.SetSessionAuthorizationTask;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.TestMetadataManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.TrinoException;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.SetSessionAuthorization;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSetSessionAuthorizationTask {
    private TransactionManager transactionManager;
    private AccessControl accessControl;
    private Metadata metadata;
    private SqlParser parser;
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    @BeforeAll
    public void setUp() {
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        this.accessControl = new AllowAllAccessControl();
        this.metadata = TestMetadataManager.builder().withTransactionManager(this.transactionManager).build();
        this.parser = new SqlParser();
    }

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.transactionManager = null;
        this.accessControl = null;
        this.metadata = null;
    }

    @Test
    public void testSetSessionAuthorization() {
        this.assertSetSessionAuthorization("SET SESSION AUTHORIZATION otheruser", Optional.of("otheruser"));
        this.assertSetSessionAuthorization("SET SESSION AUTHORIZATION 'otheruser'", Optional.of("otheruser"));
        this.assertSetSessionAuthorization("SET SESSION AUTHORIZATION \"otheruser\"", Optional.of("otheruser"));
    }

    @Test
    public void testSetSessionAuthorizationInTransaction() {
        String query = "SET SESSION AUTHORIZATION user";
        SetSessionAuthorization statement = (SetSessionAuthorization)this.parser.createStatement(query);
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        QueryStateMachine stateMachine = this.createStateMachine(Optional.of(transactionId), query);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SetSessionAuthorizationTask(this.accessControl, this.transactionManager).execute(statement, stateMachine, Collections.emptyList(), WarningCollector.NOOP)).isInstanceOf(TrinoException.class)).hasMessageContaining("Can't set authorization user in the middle of a transaction");
    }

    private void assertSetSessionAuthorization(String query, Optional<String> expected) {
        SetSessionAuthorization statement = (SetSessionAuthorization)this.parser.createStatement(query);
        QueryStateMachine stateMachine = this.createStateMachine(Optional.empty(), query);
        new SetSessionAuthorizationTask(this.accessControl, this.transactionManager).execute(statement, stateMachine, Collections.emptyList(), WarningCollector.NOOP);
        QueryInfo queryInfo = stateMachine.getQueryInfo(Optional.empty());
        Assertions.assertThat((Optional)queryInfo.getSetAuthorizationUser()).isEqualTo(expected);
    }

    private QueryStateMachine createStateMachine(Optional<TransactionId> transactionId, String query) {
        QueryStateMachine stateMachine = QueryStateMachine.begin(transactionId, (String)query, Optional.empty(), (Session)TestingSession.testSessionBuilder().build(), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, Optional.empty(), (NodeVersion)new NodeVersion("test"));
        return stateMachine;
    }
}

