/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.SetTimeZoneTask;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.spi.TrinoException;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.type.TimeZoneNotSupportedException;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SetTimeZone;
import io.trino.sql.tree.StringLiteral;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSetTimeZoneTask {
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    private QueryRunner queryRunner;

    @BeforeAll
    public void setUp() {
        this.queryRunner = new StandaloneQueryRunner(SessionTestUtils.TEST_SESSION);
    }

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.queryRunner.close();
        this.queryRunner = null;
    }

    @Test
    public void testSetTimeZoneLocal() {
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET TIME ZONE LOCAL");
        SetTimeZone setTimeZone = new SetTimeZone(new NodeLocation(1, 1), Optional.empty());
        this.executeSetTimeZone(setTimeZone, stateMachine);
        Assertions.assertThat((Collection)stateMachine.getResetSessionProperties()).hasSize(1);
        Assertions.assertThat((Collection)stateMachine.getResetSessionProperties()).contains((Object[])new String[]{"time_zone_id"});
    }

    @Test
    public void testSetTimeZoneStringLiteral() {
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET TIME ZONE 'America/Los_Angeles'");
        SetTimeZone setTimeZone = new SetTimeZone(new NodeLocation(1, 1), Optional.of(new StringLiteral("America/Los_Angeles")));
        this.executeSetTimeZone(setTimeZone, stateMachine);
        Map setSessionProperties = stateMachine.getSetSessionProperties();
        Assertions.assertThat((Map)setSessionProperties).hasSize(1);
        Assertions.assertThat((Map)setSessionProperties).containsEntry((Object)"time_zone_id", (Object)"America/Los_Angeles");
    }

    @Test
    public void testSetTimeZoneVarcharFunctionCall() {
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET TIME ZONE concat_ws('/', 'America', 'Los_Angeles')");
        SetTimeZone setTimeZone = new SetTimeZone(new NodeLocation(1, 1), Optional.of(new FunctionCall(new NodeLocation(1, 15), QualifiedName.of((String)"concat_ws"), (List)ImmutableList.of((Object)new StringLiteral(new NodeLocation(1, 25), "/"), (Object)new StringLiteral(new NodeLocation(1, 30), "America"), (Object)new StringLiteral(new NodeLocation(1, 41), "Los_Angeles")))));
        this.executeSetTimeZone(setTimeZone, stateMachine);
        Map setSessionProperties = stateMachine.getSetSessionProperties();
        Assertions.assertThat((Map)setSessionProperties).hasSize(1);
        Assertions.assertThat((Map)setSessionProperties).containsEntry((Object)"time_zone_id", (Object)"America/Los_Angeles");
    }

    @Test
    public void testSetTimeZoneInvalidFunctionCall() {
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET TIME ZONE e()");
        SetTimeZone setTimeZone = new SetTimeZone(new NodeLocation(1, 1), Optional.of(new FunctionCall(new NodeLocation(1, 15), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 15), "e", false))), (List)ImmutableList.of())));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeSetTimeZone(setTimeZone, stateMachine)).isInstanceOf(TrinoException.class)).hasMessage("Expected expression of varchar or interval day-time type, but 'e()' has double type");
    }

    @Test
    public void testSetTimeZoneStringLiteralInvalidZoneId() {
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET TIME ZONE 'Matrix/Zion'");
        SetTimeZone setTimeZone = new SetTimeZone(new NodeLocation(1, 1), Optional.of(new StringLiteral("Matrix/Zion")));
        Assertions.assertThatThrownBy(() -> this.executeSetTimeZone(setTimeZone, stateMachine)).isInstanceOf(TimeZoneNotSupportedException.class);
    }

    @Test
    public void testSetTimeZoneIntervalLiteral() {
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET TIME ZONE INTERVAL '10' HOUR");
        SetTimeZone setTimeZone = new SetTimeZone(new NodeLocation(1, 1), Optional.of(new IntervalLiteral("10", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.HOUR)));
        this.executeSetTimeZone(setTimeZone, stateMachine);
        Map setSessionProperties = stateMachine.getSetSessionProperties();
        Assertions.assertThat((Map)setSessionProperties).hasSize(1);
        Assertions.assertThat((Map)setSessionProperties).containsEntry((Object)"time_zone_id", (Object)"+10:00");
    }

    @Test
    public void testSetTimeZoneIntervalDayTimeTypeFunctionCall() {
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET TIME ZONE parse_duration('8h')");
        SetTimeZone setTimeZone = new SetTimeZone(new NodeLocation(1, 1), Optional.of(new FunctionCall(new NodeLocation(1, 24), QualifiedName.of((String)"parse_duration"), (List)ImmutableList.of((Object)new StringLiteral(new NodeLocation(1, 39), "8h")))));
        this.executeSetTimeZone(setTimeZone, stateMachine);
        Map setSessionProperties = stateMachine.getSetSessionProperties();
        Assertions.assertThat((Map)setSessionProperties).hasSize(1);
        Assertions.assertThat((Map)setSessionProperties).containsEntry((Object)"time_zone_id", (Object)"+08:00");
    }

    @Test
    public void testSetTimeZoneIntervalDayTimeTypeInvalidFunctionCall() {
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET TIME ZONE parse_duration('3601s')");
        SetTimeZone setTimeZone = new SetTimeZone(new NodeLocation(1, 1), Optional.of(new FunctionCall(new NodeLocation(1, 24), QualifiedName.of((String)"parse_duration"), (List)ImmutableList.of((Object)new StringLiteral(new NodeLocation(1, 39), "3601s")))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeSetTimeZone(setTimeZone, stateMachine)).isInstanceOf(TrinoException.class)).hasMessage("Invalid TIME ZONE offset interval: interval contains seconds");
    }

    @Test
    public void testSetTimeZoneIntervalLiteralGreaterThanOffsetTimeZoneMax() {
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET TIME ZONE INTERVAL '15' HOUR");
        SetTimeZone setTimeZone = new SetTimeZone(new NodeLocation(1, 1), Optional.of(new IntervalLiteral("15", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.HOUR)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeSetTimeZone(setTimeZone, stateMachine)).isInstanceOf(TrinoException.class)).hasMessage("Invalid offset minutes 900");
    }

    @Test
    public void testSetTimeZoneIntervalLiteralLessThanOffsetTimeZoneMin() {
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET TIME ZONE INTERVAL -'15' HOUR");
        SetTimeZone setTimeZone = new SetTimeZone(new NodeLocation(1, 1), Optional.of(new IntervalLiteral("15", IntervalLiteral.Sign.NEGATIVE, IntervalLiteral.IntervalField.HOUR)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeSetTimeZone(setTimeZone, stateMachine)).isInstanceOf(TrinoException.class)).hasMessage("Invalid offset minutes -900");
    }

    @Test
    public void testSetTimeIntervalLiteralZoneHourToMinute() {
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET TIME ZONE INTERVAL -'08:00' HOUR TO MINUTE");
        SetTimeZone setTimeZone = new SetTimeZone(new NodeLocation(1, 1), Optional.of(new IntervalLiteral("8", IntervalLiteral.Sign.NEGATIVE, IntervalLiteral.IntervalField.HOUR, Optional.of(IntervalLiteral.IntervalField.MINUTE))));
        this.executeSetTimeZone(setTimeZone, stateMachine);
        Map setSessionProperties = stateMachine.getSetSessionProperties();
        Assertions.assertThat((Map)setSessionProperties).hasSize(1);
        Assertions.assertThat((Map)setSessionProperties).containsEntry((Object)"time_zone_id", (Object)"-08:00");
    }

    private QueryStateMachine createQueryStateMachine(String query) {
        return QueryStateMachine.begin(Optional.empty(), (String)query, Optional.empty(), (Session)TestingSession.testSession(), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.queryRunner.getTransactionManager(), (AccessControl)this.queryRunner.getAccessControl(), (Executor)this.executor, (Metadata)this.queryRunner.getPlannerContext().getMetadata(), (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, Optional.empty(), (NodeVersion)new NodeVersion("test"));
    }

    private void executeSetTimeZone(SetTimeZone setTimeZone, QueryStateMachine stateMachine) {
        SetTimeZoneTask task = new SetTimeZoneTask(this.queryRunner.getPlannerContext(), (AccessControl)this.queryRunner.getAccessControl());
        MoreFutures.getFutureValue((Future)task.execute(setTimeZone, stateMachine, Collections.emptyList(), WarningCollector.NOOP));
    }
}

